/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.k8s;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.uberfire.java.nio.base.WatchContext;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchKey;
import org.uberfire.java.nio.file.Watchable;
import org.uberfire.java.nio.fs.k8s.K8SWatchService;

public class K8SWatchKey
implements WatchKey {
    private final transient K8SWatchService service;
    private final transient Path path;
    private final AtomicReference<State> state = new AtomicReference<State>(State.READY);
    private final AtomicBoolean valid = new AtomicBoolean(true);
    private final BlockingQueue<WatchEvent<?>> events = new LinkedBlockingQueue();
    private final transient Map<WatchEvent.Kind, Event> eventKinds = new ConcurrentHashMap<WatchEvent.Kind, Event>();

    K8SWatchKey(K8SWatchService service, Path path) {
        this.service = service;
        this.path = path;
    }

    public boolean isValid() {
        return !this.service.isClose() && this.valid.get();
    }

    public List<WatchEvent<?>> pollEvents() {
        ArrayList result = new ArrayList(this.events.size());
        this.events.drainTo(result);
        this.eventKinds.clear();
        return Collections.unmodifiableList(result);
    }

    public boolean reset() {
        if (this.isValid()) {
            this.events.clear();
            this.eventKinds.clear();
            return this.state.compareAndSet(State.SIGNALLED, State.READY);
        }
        return false;
    }

    public void cancel() {
        this.valid.set(false);
    }

    public Watchable watchable() {
        return this.path;
    }

    protected boolean postEvent(WatchEvent.Kind kind) {
        Event event = this.eventKinds.computeIfAbsent(kind, k -> {
            Event e = new Event(kind, new Context(this.path.getFileName()));
            return this.events.offer(e) ? e : null;
        });
        if (event == null) {
            return false;
        }
        event.increaseCount();
        return true;
    }

    protected boolean isQueued() {
        return this.state.get() == State.SIGNALLED;
    }

    protected void signal() {
        this.state.compareAndSet(State.READY, State.SIGNALLED);
    }

    private static final class Context
    implements WatchContext {
        private final Path path;

        private Context(Path path) {
            this.path = path;
        }

        public Path getPath() {
            return this.path;
        }

        public Path getOldPath() {
            return this.path;
        }

        public String getSessionId() {
            return "Not implemented";
        }

        public String getMessage() {
            return "Not implemented";
        }

        public String getUser() {
            return "Not implemented";
        }
    }

    private static final class Event
    implements WatchEvent<Context> {
        private final AtomicInteger count = new AtomicInteger(0);
        private final transient WatchEvent.Kind kind;
        private final transient Context context;

        private Event(WatchEvent.Kind kind, Context context) {
            this.kind = kind;
            this.context = context;
        }

        public WatchEvent.Kind kind() {
            return this.kind;
        }

        public int count() {
            return this.count.get();
        }

        public Context context() {
            return this.context;
        }

        private int increaseCount() {
            return this.count.incrementAndGet();
        }
    }

    static enum State {
        READY,
        SIGNALLED;

    }
}

