/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.k8s;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.AbstractBasicFileAttributeView;
import org.uberfire.java.nio.base.BasicFileAttributesImpl;
import org.uberfire.java.nio.base.GeneralPathImpl;
import org.uberfire.java.nio.channels.SeekableByteChannel;
import org.uberfire.java.nio.file.AccessDeniedException;
import org.uberfire.java.nio.file.AccessMode;
import org.uberfire.java.nio.file.AtomicMoveNotSupportedException;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryNotEmptyException;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileStore;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.NotDirectoryException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.AttributeView;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.file.attribute.FileAttributeView;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.java.nio.fs.cloud.CloudClientFactory;
import org.uberfire.java.nio.fs.file.SimpleFileSystemProvider;
import org.uberfire.java.nio.fs.k8s.K8SBasicFileAttributeView;
import org.uberfire.java.nio.fs.k8s.K8SFileChannel;
import org.uberfire.java.nio.fs.k8s.K8SFileStore;
import org.uberfire.java.nio.fs.k8s.K8SFileSystem;
import org.uberfire.java.nio.fs.k8s.K8SFileSystemUtils;

public class K8SFileSystemProvider
extends SimpleFileSystemProvider
implements CloudClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(K8SFileSystemProvider.class);

    public K8SFileSystemProvider() {
        super(null, SimpleFileSystemProvider.OSType.UNIX_LIKE);
        this.fileSystem = new K8SFileSystem((FileSystemProvider)this, "/");
    }

    public String getScheme() {
        return "k8s";
    }

    public InputStream newInputStream(Path path, OpenOption ... options) throws IllegalArgumentException, NoSuchFileException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        this.checkFileNotExistThenThrow(path, false);
        logger.info("Open InputStream to file [{}]", (Object)path);
        return Channels.newInputStream((ReadableByteChannel)((Object)new K8SFileChannel(this.toAbsoluteRealPath(path), this)));
    }

    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        Path aPath = this.toAbsoluteRealPath(path);
        logger.info("Open OutputStream to file [{}]", (Object)aPath);
        return Channels.newOutputStream((WritableByteChannel)((Object)new K8SFileChannel(aPath, this)));
    }

    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        throw new UnsupportedOperationException();
    }

    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        return new K8SFileChannel(this.toAbsoluteRealPath(path), this);
    }

    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"dir", (Object)dir);
        Path aDir = this.toAbsoluteRealPath(dir);
        Optional directoryCm = this.executeCloudFunction(client -> K8SFileSystemUtils.getFsObjCM(client, aDir), KubernetesClient.class);
        if (directoryCm.isPresent()) {
            throw new FileAlreadyExistsException(aDir.toString());
        }
        this.executeCloudFunction(client -> K8SFileSystemUtils.createOrReplaceFSCM(client, aDir, K8SFileSystemUtils.isRoot(aDir) ? Optional.empty() : K8SFileSystemUtils.createOrReplaceParentDirFSCM(client, aDir, 0L, false), Collections.emptyMap(), true), KubernetesClient.class);
    }

    protected Path[] getDirectoryContent(Path dir) {
        ConfigMap dirCM;
        PortablePreconditions.checkNotNull((String)"dir", (Object)dir);
        Path aDir = this.toAbsoluteRealPath(dir);
        if (K8SFileSystemUtils.isRoot(aDir) && !this.executeCloudFunction(client -> K8SFileSystemUtils.getFsObjCM(client, aDir), KubernetesClient.class).isPresent()) {
            this.initRoot();
        }
        if ((dirCM = (ConfigMap)this.executeCloudFunction(client -> K8SFileSystemUtils.getFsObjCM(client, aDir), KubernetesClient.class).orElseThrow(() -> new NotDirectoryException(aDir.toString()))).getData() == null || dirCM.getData().isEmpty()) {
            return new Path[0];
        }
        String separator = aDir.getFileSystem().getSeparator();
        String dirPathString = K8SFileSystemUtils.getPathByFsObjCM((K8SFileSystem)this.fileSystem, dirCM).toString();
        return (Path[])dirCM.getData().keySet().stream().map(fileName -> GeneralPathImpl.create((FileSystem)aDir.getFileSystem(), (String)(dirPathString.endsWith(separator) ? dirPathString : dirPathString.concat(separator)).concat((String)fileName), (boolean)false)).toArray(Path[]::new);
    }

    private synchronized void initRoot() {
        Path root = this.fileSystem.getPath("/", new String[0]);
        this.createDirectory(root, new FileAttribute[0]);
        logger.info("Root directory created.");
    }

    public void delete(Path path, DeleteOption ... options) throws NoSuchFileException, DirectoryNotEmptyException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        this.checkFileNotExistThenThrow(path, false);
        this.deleteIfExists(this.toAbsoluteRealPath(path), options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteIfExists(Path path, DeleteOption ... options) throws DirectoryNotEmptyException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        Path aPath = this.toAbsoluteRealPath(path);
        K8SFileSystemProvider k8SFileSystemProvider = this;
        synchronized (k8SFileSystemProvider) {
            boolean bl;
            try {
                bl = (Boolean)this.executeCloudFunction(client -> K8SFileSystemUtils.deleteAndUpdateParentCM(client, aPath), KubernetesClient.class).get();
            }
            catch (Throwable throwable) {
                this.toGeneralPathImpl(aPath).clearCache();
                throw throwable;
            }
            this.toGeneralPathImpl(aPath).clearCache();
            return bl;
        }
    }

    public boolean isHidden(Path path) throws IllegalArgumentException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        this.checkFileNotExistThenThrow(path, false);
        return path.getFileName().toString().startsWith(".");
    }

    public void checkAccess(Path path, AccessMode ... modes) throws UnsupportedOperationException, NoSuchFileException, AccessDeniedException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        PortablePreconditions.checkNotNull((String)"modes", (Object)modes);
        this.checkFileNotExistThenThrow(path, false);
        for (AccessMode mode : modes) {
            PortablePreconditions.checkNotNull((String)"mode", (Object)mode);
            if (mode != AccessMode.EXECUTE) continue;
            throw new AccessDeniedException(this.toAbsoluteRealPath(path).toString());
        }
    }

    public FileStore getFileStore(Path path) throws IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        return new K8SFileStore(this.toAbsoluteRealPath(path));
    }

    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws NoSuchFileException, UnsupportedOperationException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        PortablePreconditions.checkNotNull((String)"type", type);
        this.checkFileNotExistThenThrow(path, false);
        if (type == BasicFileAttributesImpl.class || type == BasicFileAttributes.class) {
            K8SBasicFileAttributeView view = (K8SBasicFileAttributeView)this.getFileAttributeView(this.toAbsoluteRealPath(path), K8SBasicFileAttributeView.class, options);
            return (A)view.readAttributes();
        }
        return null;
    }

    protected <V extends FileAttributeView> V createFileAttributeView(GeneralPathImpl path, Class<V> type) {
        if (AbstractBasicFileAttributeView.class.isAssignableFrom(type)) {
            K8SBasicFileAttributeView newView = new K8SBasicFileAttributeView((Path)path, this);
            path.addAttrView((AttributeView)newView);
            return (V)((Object)newView);
        }
        return null;
    }

    public void copy(Path source, Path target, CopyOption ... options) throws UnsupportedOperationException, FileAlreadyExistsException, DirectoryNotEmptyException, IOException, SecurityException {
        PortablePreconditions.checkNotNull((String)"source", (Object)source);
        PortablePreconditions.checkNotNull((String)"target", (Object)target);
        this.checkFileExistsThenThrow(target);
        Path aSource = this.toAbsoluteRealPath(source);
        Path aTarget = this.toAbsoluteRealPath(target);
        Optional srcCMOpt = this.executeCloudFunction(client -> K8SFileSystemUtils.getFsObjCM(client, aSource), KubernetesClient.class);
        PortablePreconditions.checkCondition((String)"source must exist", (boolean)srcCMOpt.isPresent());
        ConfigMap srcCM = (ConfigMap)srcCMOpt.orElseThrow(IllegalArgumentException::new);
        if (K8SFileSystemUtils.isDirectory(srcCM)) {
            throw new UnsupportedOperationException(srcCM.getMetadata().getName() + "is a directory.");
        }
        String content = srcCM.getData().getOrDefault("fsobj-content", "");
        long size = Long.parseLong(srcCM.getMetadata().getAnnotations().getOrDefault("k8s.fs.nio.java.uberfire.org/fsobj-size", "0"));
        this.executeCloudFunction(client -> K8SFileSystemUtils.createOrReplaceFSCM(client, aTarget, K8SFileSystemUtils.createOrReplaceParentDirFSCM(client, aTarget, size, false), Collections.singletonMap("fsobj-content", content), false), KubernetesClient.class);
    }

    public void move(Path source, Path target, CopyOption ... options) throws DirectoryNotEmptyException, AtomicMoveNotSupportedException, IOException, SecurityException {
        Path aSource = this.toAbsoluteRealPath(source);
        Path aTarget = this.toAbsoluteRealPath(target);
        try {
            this.copy(aSource, aTarget, new CopyOption[0]);
        }
        catch (Exception e) {
            try {
                this.delete(aTarget, new DeleteOption[0]);
            }
            catch (NoSuchFileException nsfe) {
                throw new IOException("Moving file failed.", e);
            }
            catch (Exception exp) {
                throw new IOException("Moving file failed due to these errors: Copy Source Exception [" + e.getMessage() + "]; Delete Target Exception [" + exp.getMessage() + "].");
            }
        }
        try {
            this.delete(aSource, new DeleteOption[0]);
        }
        catch (Exception e) {
            throw new IOException("Moving file failed with clean Source Exception [" + e.getMessage() + "], which will leave file system in an inconsistent state.");
        }
    }

    protected void checkFileNotExistThenThrow(Path path, boolean isLink) {
        Path aPath = this.toAbsoluteRealPath(path);
        this.executeCloudFunction(client -> K8SFileSystemUtils.getFsObjCM(client, aPath), KubernetesClient.class).orElseThrow(() -> {
            logger.info("File not found [{}]", (Object)aPath.toUri().toString());
            return new NoSuchFileException(aPath.toUri().toString());
        });
    }

    protected void checkFileExistsThenThrow(Path path) {
        Path aPath = this.toAbsoluteRealPath(path);
        if (this.executeCloudFunction(client -> K8SFileSystemUtils.getFsObjCM(client, aPath), KubernetesClient.class).isPresent()) {
            throw new FileAlreadyExistsException(aPath.toString());
        }
    }

    protected Path toAbsoluteRealPath(Path path) {
        if (path.isAbsolute()) {
            if (path.getParent() == null) {
                return path;
            }
            if (path.getParent().toString().contains(".")) {
                this.fileSystem.getPath(path.toRealPath(new LinkOption[0]).toString(), new String[0]);
            } else {
                return path;
            }
        }
        return this.fileSystem.getPath(path.toAbsolutePath().toRealPath(new LinkOption[0]).toString(), new String[0]);
    }
}

