/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.k8s;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.server.mock.KubernetesCrudDispatcher;
import io.fabric8.kubernetes.client.server.mock.KubernetesMockServer;
import io.fabric8.mockwebserver.Context;
import java.net.URI;
import java.util.HashMap;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.java.nio.fs.cloud.CloudClientFactory;
import org.uberfire.java.nio.fs.k8s.K8SFileChannel;
import org.uberfire.java.nio.fs.k8s.K8SFileSystem;
import org.uberfire.java.nio.fs.k8s.K8SFileSystemProvider;

public class K8SFileChannelTest {
    public static KubernetesMockServer SERVER = new KubernetesMockServer(new Context(), new MockWebServer(), new HashMap(), (Dispatcher)new KubernetesCrudDispatcher(), false);
    protected static String TEST_NAMESPACE = "test";
    protected static ThreadLocal<KubernetesClient> CLIENT_FACTORY;
    protected static final FileSystemProvider fsProvider;

    @BeforeClass
    public static void setup() {
        SERVER.init();
        CLIENT_FACTORY = ThreadLocal.withInitial(() -> SERVER.createClient());
    }

    @AfterClass
    public static void tearDown() {
        ((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).delete();
        CLIENT_FACTORY.get().close();
        SERVER.destroy();
    }

    @Test(expected=IOException.class)
    public void testOpenChannelWithInitializationErrors() {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("k8s:///"));
        Path invalid = kfs.getPath("/#weirdFileName$@#^&*", new String[0]);
        new K8SFileChannel(invalid, (CloudClientFactory)fsProvider);
    }

    @Test
    public void testOpenAndCloseChannel() {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("k8s:///"));
        Path valid = kfs.getPath("/test", new String[0]);
        K8SFileChannel k8sfc = new K8SFileChannel(valid, (CloudClientFactory)fsProvider);
        Assert.assertTrue((boolean)k8sfc.isOpen());
        k8sfc.close();
        Assert.assertFalse((boolean)k8sfc.isOpen());
    }

    @Test
    public void testChannelMustBeClosedRegardlessError() {
        K8SFileSystemProvider fsProvider = new K8SFileSystemProvider(){

            public KubernetesClient createKubernetesClient() {
                return CLIENT_FACTORY.get();
            }
        };
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("k8s:///"));
        Path valid = kfs.getPath("/test", new String[0]);
        K8SFileChannel k8sfc = new K8SFileChannel(valid, (CloudClientFactory)fsProvider);
        Assert.assertTrue((boolean)k8sfc.isOpen());
        k8sfc.ccf = null;
        try {
            k8sfc.close();
            Assert.fail((String)"Channel close should throw an exception.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertFalse((boolean)k8sfc.isOpen());
    }

    static {
        fsProvider = new K8SFileSystemProvider(){

            public KubernetesClient createKubernetesClient() {
                return CLIENT_FACTORY.get();
            }
        };
    }
}

