/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.k8s;

import java.net.URI;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.uberfire.java.nio.file.api.FileSystemProviders;
import org.uberfire.java.nio.file.api.FileSystemUtils;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.java.nio.fs.file.SimpleFileSystemProvider;
import org.uberfire.java.nio.fs.k8s.K8SFileSystemProvider;

public class FileSystemProvidersTest {
    @BeforeClass
    public static void setup() {
        Assume.assumeFalse((String)"k8s does not support in Windows platform", (boolean)System.getProperty("os.name").toLowerCase().contains("windows"));
    }

    @Test
    public void generalTests() {
        Assertions.assertThat((List)FileSystemProviders.installedProviders()).hasSize(2);
        Assertions.assertThat((Object)FileSystemProviders.getDefaultProvider()).isInstanceOf(SimpleFileSystemProvider.class);
        Assertions.assertThat((Object)FileSystemProviders.resolveProvider((URI)URI.create("default:///"))).isInstanceOf(SimpleFileSystemProvider.class);
        Assertions.assertThat((Object)FileSystemProviders.resolveProvider((URI)URI.create("file:///"))).isInstanceOf(SimpleFileSystemProvider.class);
        Assertions.assertThat((Object)FileSystemProviders.resolveProvider((URI)URI.create("k8s:///"))).isInstanceOf(K8SFileSystemProvider.class);
    }

    @Test
    public void k8sFileSystemProivdeAsDefaultTests() {
        FileSystemUtils.getConfigProps().setProperty("org.appformer.server.simplified.monitoring.enabled", "true");
        FileSystemUtils.getConfigProps().setProperty("org.kie.server.controller.openshift.enabled", "true");
        Assertions.assertThat((Object)FileSystemProviders.resolveProvider((URI)URI.create("default:///"))).isInstanceOf(K8SFileSystemProvider.class);
        Assertions.assertThat((Object)FileSystemProviders.resolveProvider((URI)URI.create("k8s:///"))).isInstanceOf(K8SFileSystemProvider.class);
        Assertions.assertThat((boolean)FileSystemProviders.resolveProvider((URI)URI.create("k8s:///")).isDefault()).isTrue();
        Assertions.assertThat((Object)FileSystemProviders.getDefaultProvider()).isInstanceOf(K8SFileSystemProvider.class);
        Assertions.assertThat((boolean)((FileSystemProvider)FileSystemProviders.installedProviders().get(0)).isDefault()).isFalse();
    }
}

