/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.k8s;

import com.google.common.collect.Lists;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.server.mock.KubernetesCrudDispatcher;
import io.fabric8.kubernetes.client.server.mock.KubernetesMockServer;
import io.fabric8.mockwebserver.Context;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.uberfire.java.nio.base.attributes.HiddenAttributes;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileStore;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.java.nio.fs.k8s.K8SFileStore;
import org.uberfire.java.nio.fs.k8s.K8SFileSystem;
import org.uberfire.java.nio.fs.k8s.K8SFileSystemProvider;
import org.uberfire.java.nio.fs.k8s.K8SFileSystemUtils;

public class K8SFileSystemInitTest {
    public static KubernetesMockServer SERVER = new KubernetesMockServer(new Context(), new MockWebServer(), new HashMap(), (Dispatcher)new KubernetesCrudDispatcher(), false);
    protected static String TEST_NAMESPACE = "test";
    protected static ThreadLocal<KubernetesClient> CLIENT_FACTORY;
    protected static final FileSystemProvider fsProvider;
    protected static FileStore fstore;

    @BeforeClass
    public static void setup() {
        SERVER.init();
        CLIENT_FACTORY = ThreadLocal.withInitial(() -> SERVER.createClient());
        Assume.assumeFalse((String)"k8s does not support in Windows platform", (boolean)System.getProperty("os.name").toLowerCase().contains("windows"));
        fstore = (FileStore)fsProvider.getFileSystem(URI.create("default:///")).getFileStores().iterator().next();
    }

    @AfterClass
    public static void tearDown() {
        ((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).delete();
        CLIENT_FACTORY.get().close();
        SERVER.destroy();
    }

    @Test
    public void testRoot() throws URISyntaxException {
        FileSystem fileSystem = fsProvider.getFileSystem(URI.create("default:///"));
        Path root = fileSystem.getPath("/", new String[0]);
        Map ne = K8SFileSystemUtils.getFsObjNameElementLabel((Path)root);
        List roots = StreamSupport.stream(fileSystem.getRootDirectories().spliterator(), false).collect(Collectors.toList());
        AssertionsForClassTypes.assertThat(roots).asList().size().isEqualTo(1);
        AssertionsForClassTypes.assertThat(roots.get(0)).isEqualTo((Object)root);
        AssertionsForClassTypes.assertThat((boolean)root.toUri().toString().contains("/master@")).isTrue();
        AssertionsForClassTypes.assertThat((Object)root).isEqualTo((Object)fileSystem.getPath("/path", new String[0]).getRoot());
        AssertionsForClassTypes.assertThat((Object)root).isEqualTo((Object)fileSystem.getPath("/path", new String[0]).getParent());
        AssertionsForClassTypes.assertThat((boolean)root.getRoot().equals(root)).isTrue();
        AssertionsForClassTypes.assertThat((boolean)root.toString().equals("/")).isTrue();
        AssertionsForClassTypes.assertThat((boolean)root.toRealPath(new LinkOption[0]).toString().equals("/")).isTrue();
        AssertionsForClassTypes.assertThat((Object)root.getParent()).isNull();
        AssertionsForClassTypes.assertThat((Object)root.getFileName()).isNull();
        AssertionsForClassTypes.assertThat((int)root.getNameCount()).isEqualTo(0);
        AssertionsForClassTypes.assertThat((boolean)root.iterator().hasNext()).isEqualTo(false);
        AssertionsForClassTypes.assertThat((int)ne.size()).isEqualTo(0);
        AssertionsForClassTypes.assertThat((boolean)K8SFileSystemUtils.getFileNameString((Path)root).equals("/")).isTrue();
    }

    @Test
    public void testInitRoot() {
        ArrayList dirContent;
        FileSystem fs = fsProvider.getFileSystem(URI.create("default:///"));
        Path root = fs.getPath("/", new String[0]);
        Path testParentDir = fs.getPath("/.testParentDir", new String[0]);
        Path testDir = fs.getPath("/.testParentDir/.testInitRoot", new String[0]);
        Path rPath = fs.getPath("./../.testInitRoot", new String[0]);
        AssertionsForClassTypes.assertThat((Object)root.getParent()).isNull();
        AssertionsForClassTypes.assertThat((boolean)root.isAbsolute()).isTrue();
        AssertionsForClassTypes.assertThat((boolean)rPath.isAbsolute()).isFalse();
        AssertionsForClassTypes.assertThat((Object)rPath.getRoot()).isNull();
        AssertionsForClassTypes.assertThat((boolean)testDir.isAbsolute()).isTrue();
        AssertionsForClassTypes.assertThat((Object)testDir.getParent()).isEqualTo((Object)testParentDir);
        AssertionsForClassTypes.assertThat((Object)testDir.getRoot()).isEqualTo((Object)root);
        AssertionsForClassTypes.assertThat((Object)testDir.getFileName()).isEqualTo((Object)rPath.getFileName());
        Path aPath = ((K8SFileSystemProvider)fsProvider).toAbsoluteRealPath(rPath);
        AssertionsForClassTypes.assertThat((Object)aPath.getRoot()).isEqualTo((Object)root);
        AssertionsForClassTypes.assertThat((Object)aPath.getParent()).isNotNull();
        AssertionsForClassTypes.assertThat((boolean)aPath.isAbsolute()).isTrue();
        AssertionsForClassTypes.assertThat((Object)aPath.getFileName()).isEqualTo((Object)rPath.getFileName());
        AssertionsForClassTypes.assertThat((boolean)testDir.isAbsolute()).isTrue();
        AssertionsForClassTypes.assertThat((Object)testDir.getParent()).isEqualTo((Object)testParentDir);
        AssertionsForClassTypes.assertThat((Object)testParentDir.getParent()).isEqualTo((Object)root);
        AssertionsForClassTypes.assertThat((Object)testParentDir).isEqualTo((Object)((K8SFileSystemProvider)fsProvider).toAbsoluteRealPath(testParentDir));
        ((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).createOrReplace((Object[])new ConfigMap[]{(ConfigMap)((Resource)CLIENT_FACTORY.get().configMaps().load(K8SFileSystemInitTest.class.getResourceAsStream("/test-k8sfs-dir-r-empty-configmap.yml"))).get()});
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)root, (LinkOption[])new LinkOption[0])).isTrue();
        try (DirectoryStream stream = Files.newDirectoryStream((Path)root);){
            dirContent = Lists.newArrayList((Iterable)stream);
            AssertionsForClassTypes.assertThat((Object)dirContent).asList().isEmpty();
        }
        ((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).delete();
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)root, (LinkOption[])new LinkOption[0])).isFalse();
        stream = Files.newDirectoryStream((Path)root);
        var8_8 = null;
        try {
            dirContent = Lists.newArrayList((Iterable)stream);
            AssertionsForClassTypes.assertThat((Object)dirContent).asList().isEmpty();
        }
        catch (Throwable dirContent2) {
            var8_8 = dirContent2;
            throw dirContent2;
        }
        finally {
            if (stream != null) {
                if (var8_8 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable dirContent2) {
                        var8_8.addSuppressed(dirContent2);
                    }
                } else {
                    stream.close();
                }
            }
        }
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)root, (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((Object)K8SFileSystemUtils.getFsObjCM((KubernetesClient)CLIENT_FACTORY.get(), (Path)root).getData()).isNotNull();
        Files.createDirectory((Path)testDir, (FileAttribute[])new FileAttribute[0]);
        stream = Files.newDirectoryStream((Path)testParentDir);
        var8_8 = null;
        try {
            dirContent = Lists.newArrayList((Iterable)stream);
            AssertionsForClassTypes.assertThat((Object)dirContent).asList().containsExactly(new Object[]{testDir});
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (var8_8 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testAmbiguousCM() {
        FileSystem fileSystem = fsProvider.getFileSystem(URI.create("default:///"));
        Path file = fileSystem.getPath("/testDir/testFile", new String[0]);
        ((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).createOrReplace((Object[])new ConfigMap[]{(ConfigMap)((Resource)CLIENT_FACTORY.get().configMaps().load(K8SFileSystemInitTest.class.getResourceAsStream("/test-k8sfs-file-configmap.yml"))).get()});
        ((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).createOrReplace((Object[])new ConfigMap[]{(ConfigMap)((Resource)CLIENT_FACTORY.get().configMaps().load(K8SFileSystemInitTest.class.getResourceAsStream("/test-k8sfs-file-dup-configmap.yml"))).get()});
        K8SFileSystemUtils.getFsObjCM((KubernetesClient)CLIENT_FACTORY.get(), (Path)file);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidFsObjCM() {
        FileSystem fileSystem = fsProvider.getFileSystem(URI.create("default:///"));
        ConfigMap cm = (ConfigMap)((Resource)CLIENT_FACTORY.get().configMaps().load(K8SFileSystemInitTest.class.getResourceAsStream("/test-k8sfs-file-invalid-configmap.yml"))).get();
        K8SFileSystemUtils.getPathByFsObjCM((K8SFileSystem)((K8SFileSystem)fileSystem), (ConfigMap)cm);
    }

    @Test
    public void testFileStore() {
        K8SFileSystem fs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        fs.lock();
        fs.unlock();
        AssertionsForClassTypes.assertThat((Object)fs).isNotNull();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testFileStoreGetTotalSpace() {
        fstore.getTotalSpace();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testFileStoreGetUsableSpace() {
        fstore.getUsableSpace();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testFileStoreGetUnallocatedSpace() {
        fstore.getUnallocatedSpace();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testNewFileChannel() {
        FileSystem fs = fsProvider.getFileSystem(URI.create("default:///"));
        fsProvider.newFileChannel(fs.getPath("/", new String[0]), null, new FileAttribute[0]);
    }

    @Test
    public void testGetFileStore() {
        FileSystem fs = fsProvider.getFileSystem(URI.create("default:///"));
        FileStore fstore = fsProvider.getFileStore(fs.getPath("/", new String[0]));
        AssertionsForClassTypes.assertThat((boolean)K8SFileStore.class.isInstance(fstore)).isTrue();
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testCheckFileExistsThenThrow() {
        FileSystem fileSystem = fsProvider.getFileSystem(URI.create("default:///"));
        Path dir = fileSystem.getPath("/testDir", new String[0]);
        ((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).createOrReplace((Object[])new ConfigMap[]{(ConfigMap)((Resource)CLIENT_FACTORY.get().configMaps().load(K8SFileSystemInitTest.class.getResourceAsStream("/test-k8sfs-dir-0-configmap.yml"))).get()});
        fsProvider.createDirectory(dir, new FileAttribute[0]);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCopyDirShouldFail() {
        FileSystem fileSystem = fsProvider.getFileSystem(URI.create("default:///"));
        Path source = fileSystem.getPath("/testDir", new String[0]);
        Path target = fileSystem.getPath("/testDir2", new String[0]);
        ((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).createOrReplace((Object[])new ConfigMap[]{(ConfigMap)((Resource)CLIENT_FACTORY.get().configMaps().load(K8SFileSystemInitTest.class.getResourceAsStream("/test-k8sfs-dir-0-configmap.yml"))).get()});
        fsProvider.copy(source, target, new CopyOption[0]);
    }

    @Test
    public void testReadAttributes() {
        FileSystem fileSystem = fsProvider.getFileSystem(URI.create("default:///"));
        Path dir = fileSystem.getPath("/testDir", new String[0]);
        ((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).createOrReplace((Object[])new ConfigMap[]{(ConfigMap)((Resource)CLIENT_FACTORY.get().configMaps().load(K8SFileSystemInitTest.class.getResourceAsStream("/test-k8sfs-dir-0-configmap.yml"))).get()});
        AssertionsForClassTypes.assertThat((Object)fsProvider.readAttributes(dir, HiddenAttributes.class, new LinkOption[0])).isNull();
        AssertionsForClassTypes.assertThat((Object)fsProvider.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0])).isNotNull();
        AssertionsForClassTypes.assertThat((boolean)fsProvider.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]).isDirectory()).isTrue();
        AssertionsForClassTypes.assertThat((boolean)fsProvider.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]).isRegularFile()).isFalse();
        AssertionsForClassTypes.assertThat((boolean)fsProvider.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]).isSymbolicLink()).isFalse();
        AssertionsForClassTypes.assertThat((long)fsProvider.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]).size()).isEqualTo(19L);
    }

    static {
        fsProvider = new K8SFileSystemProvider(){

            public KubernetesClient createKubernetesClient() {
                return CLIENT_FACTORY.get();
            }
        };
    }
}

