/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.k8s.integrationtests;

import io.fabric8.kubernetes.api.model.DoneableNamespace;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.AssertionsForClassTypes;
import org.awaitility.Awaitility;
import org.awaitility.Duration;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.uberfire.java.nio.base.WatchContext;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardWatchEventKind;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchKey;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.java.nio.fs.k8s.K8SFileSystem;
import org.uberfire.java.nio.fs.k8s.K8SFileSystemProvider;

public class K8SFileSystemProviderIntegrationTest {
    private static final String KUBERNETES_MAIN_API_URL = System.getProperty("kubernetes.master");
    private static final String KUBERNETES_MAIN_API_TOKEN = System.getProperty("kubernetes.auth.token");
    private static final String TEST_NAMESPACE = "k8sfsp-test";
    private static KubernetesClient client;
    protected static final FileSystemProvider fsProvider;

    @BeforeClass
    public static void setup() {
        System.setProperty("kubernetes.namespace", TEST_NAMESPACE);
        Config config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl(KUBERNETES_MAIN_API_URL)).withOauthToken(KUBERNETES_MAIN_API_TOKEN)).withTrustCerts(true)).withNamespace(TEST_NAMESPACE)).build();
        client = new DefaultKubernetesClient(config);
        ((DoneableNamespace)((NamespaceFluent.MetadataNested)((DoneableNamespace)client.namespaces().createOrReplaceWithNew()).withNewMetadata().withName(TEST_NAMESPACE)).endMetadata()).done();
    }

    @After
    public void cleanNamespace() {
        ((NonNamespaceOperation)client.configMaps().inNamespace(TEST_NAMESPACE)).delete();
    }

    @AfterClass
    public static void tearDown() {
        ((Resource)client.namespaces().withName(TEST_NAMESPACE)).delete();
        client.close();
        System.clearProperty("kubernetes.namespace");
    }

    @Test
    public void simpleRootFolderCreateDeleteTest() {
        FileSystem fileSystem = fsProvider.getFileSystem(URI.create("default:///"));
        Path folderInRootFolder = fileSystem.getPath("/test", new String[0]);
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)folderInRootFolder, (LinkOption[])new LinkOption[0])).isFalse();
        AssertionsForClassTypes.assertThat((boolean)Files.deleteIfExists((Path)folderInRootFolder, (DeleteOption[])new DeleteOption[0])).isFalse();
        Files.createDirectory((Path)folderInRootFolder, (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((boolean)Files.deleteIfExists((Path)folderInRootFolder, (DeleteOption[])new DeleteOption[0])).isTrue();
    }

    @Test
    public void simpleRootFileCreateDeleteTest() throws IOException {
        FileSystem fileSystem = fsProvider.getFileSystem(URI.create("default:///"));
        Path fileInRootFolder = fileSystem.getPath("/test.txt", new String[0]);
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)fileInRootFolder, (LinkOption[])new LinkOption[0])).isFalse();
        AssertionsForClassTypes.assertThat((boolean)Files.deleteIfExists((Path)fileInRootFolder, (DeleteOption[])new DeleteOption[0])).isFalse();
        this.createOrEditFile(fileInRootFolder, "Hello");
        AssertionsForClassTypes.assertThat((boolean)Files.deleteIfExists((Path)fileInRootFolder, (DeleteOption[])new DeleteOption[0])).isTrue();
    }

    @Test
    public void testDeleteRoot() throws IOException {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("k8s:///"));
        Path testDir = kfs.getPath("/.testDeleRootDir", new String[0]);
        Path testFile = kfs.getPath("/.testDeleRootDir/.testDeleRootDirFile", new String[0]);
        Path root = testFile.getRoot();
        String testFileContent = "Hello World";
        this.createOrEditFile(testFile, testFileContent);
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)testDir, (LinkOption[])new LinkOption[0])).isTrue();
        Files.delete((Path)root, (DeleteOption[])new DeleteOption[0]);
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)testDir, (LinkOption[])new LinkOption[0])).isFalse();
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)testFile, (LinkOption[])new LinkOption[0])).isFalse();
    }

    @Test
    public void testDeleteFolderWithFiles() throws IOException {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("k8s:///"));
        Path testDir = kfs.getPath("/testDir", new String[0]);
        Path testFirstFile = kfs.getPath("/testDir/testFirstFile", new String[0]);
        Path testSecondFile = kfs.getPath("/testDir/testSecondFile", new String[0]);
        String testFileContent = "Hello World";
        this.createOrEditFile(testFirstFile, testFileContent);
        this.createOrEditFile(testSecondFile, testFileContent);
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)testDir, (LinkOption[])new LinkOption[0])).isTrue();
        Files.delete((Path)testDir, (DeleteOption[])new DeleteOption[0]);
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)testDir, (LinkOption[])new LinkOption[0])).isFalse();
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)testFirstFile, (LinkOption[])new LinkOption[0])).isFalse();
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)testSecondFile, (LinkOption[])new LinkOption[0])).isFalse();
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void simpleRootFolderCreateDuplicateFolderTest() {
        FileSystem fileSystem = fsProvider.getFileSystem(URI.create("default:///"));
        Path folderInRootFolder = fileSystem.getPath("/test", new String[0]);
        Files.createDirectory((Path)folderInRootFolder, (FileAttribute[])new FileAttribute[0]);
        Files.createDirectory((Path)folderInRootFolder, (FileAttribute[])new FileAttribute[0]);
    }

    @Test
    public void simpleRootFileEditFileTest() throws IOException {
        FileSystem fileSystem = fsProvider.getFileSystem(URI.create("default:///"));
        Path fileInRootFolder = fileSystem.getPath("/test.txt", new String[0]);
        this.createOrEditFile(fileInRootFolder, "Hello");
        AssertionsForClassTypes.assertThat((String)this.readFile(fileInRootFolder)).isEqualTo("Hello");
        this.createOrEditFile(fileInRootFolder, "Welcome");
        AssertionsForClassTypes.assertThat((String)this.readFile(fileInRootFolder)).isEqualTo("Welcome");
        this.createOrEditFile(fileInRootFolder, "Hi");
        AssertionsForClassTypes.assertThat((String)this.readFile(fileInRootFolder)).isEqualTo("Hi");
    }

    @Test(expected=NoSuchFileException.class)
    public void inputStreamFromNotExistingFileTest() throws IOException {
        FileSystem fileSystem = fsProvider.getFileSystem(URI.create("default:///"));
        Path fileInRootFolder = fileSystem.getPath("/test.txt", new String[0]);
        this.readFile(fileInRootFolder);
    }

    @Test
    public void testWatchCreateDirectory() {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path root = kfs.getPath("/", new String[0]);
        Path watchDir = kfs.getPath("/watchDir", new String[0]);
        try (WatchService watcher = kfs.newWatchService();){
            watchDir.register(watcher, new WatchEvent.Kind[0]);
            Files.createDirectory((Path)watchDir, (FileAttribute[])new FileAttribute[0]);
            WatchKey createRootKey = watcher.poll(30L, TimeUnit.SECONDS);
            AssertionsForClassTypes.assertThat((boolean)createRootKey.isValid()).isTrue();
            AssertionsForClassTypes.assertThat((Object)createRootKey.watchable()).isEqualTo((Object)root);
            ArrayList rootEvents = new ArrayList();
            Awaitility.await().atMost(Duration.FIVE_SECONDS).until(this.fetchWatchEvents(createRootKey, rootEvents, 1));
            AssertionsForClassTypes.assertThat(rootEvents).asList().hasSize(1);
            WatchEvent firstEvent = (WatchEvent)rootEvents.get(0);
            AssertionsForClassTypes.assertThat((Object)firstEvent.kind()).isEqualTo((Object)StandardWatchEventKind.ENTRY_CREATE);
            AssertionsForClassTypes.assertThat((int)firstEvent.count()).isEqualTo(1);
            AssertionsForClassTypes.assertThat((Object)((WatchContext)firstEvent.context()).getPath()).isNull();
            WatchKey createWatchDirKey = watcher.poll();
            AssertionsForClassTypes.assertThat((boolean)createWatchDirKey.isValid()).isTrue();
            AssertionsForClassTypes.assertThat((Object)createWatchDirKey.watchable()).isEqualTo((Object)watchDir);
            ArrayList watchDirEvents = new ArrayList();
            Awaitility.await().atMost(Duration.FIVE_SECONDS).until(this.fetchWatchEvents(createWatchDirKey, watchDirEvents, 1));
            AssertionsForClassTypes.assertThat(watchDirEvents).asList().hasSize(1);
            WatchEvent firstWatchDirEvent = (WatchEvent)watchDirEvents.get(0);
            AssertionsForClassTypes.assertThat((Object)firstWatchDirEvent.kind()).isEqualTo((Object)StandardWatchEventKind.ENTRY_CREATE);
            AssertionsForClassTypes.assertThat((int)firstWatchDirEvent.count()).isEqualTo(1);
            AssertionsForClassTypes.assertThat((Object)((WatchContext)firstWatchDirEvent.context()).getPath()).isEqualTo((Object)watchDir.getFileName());
            AssertionsForClassTypes.assertThat((Object)watcher.poll()).isNull();
        }
    }

    @Test
    public void testWatchCreateFile() throws IOException {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path root = kfs.getPath("/", new String[0]);
        Path fileInRootFolder = kfs.getPath("/.test.txt", new String[0]);
        try (WatchService watcher = kfs.newWatchService();){
            fileInRootFolder.register(watcher, new WatchEvent.Kind[0]);
            this.createOrEditFile(fileInRootFolder, "Hi");
            WatchKey createRootKey = watcher.poll(30L, TimeUnit.SECONDS);
            AssertionsForClassTypes.assertThat((boolean)createRootKey.isValid()).isTrue();
            AssertionsForClassTypes.assertThat((Object)createRootKey.watchable()).isEqualTo((Object)root);
            ArrayList rootEvents = new ArrayList();
            Awaitility.await().atMost(Duration.FIVE_SECONDS).until(this.fetchWatchEvents(createRootKey, rootEvents, 1));
            AssertionsForClassTypes.assertThat(rootEvents).asList().hasSize(1);
            WatchEvent firstEvent = (WatchEvent)rootEvents.get(0);
            AssertionsForClassTypes.assertThat((Object)firstEvent.kind()).isEqualTo((Object)StandardWatchEventKind.ENTRY_CREATE);
            AssertionsForClassTypes.assertThat((int)firstEvent.count()).isEqualTo(1);
            AssertionsForClassTypes.assertThat((Object)((WatchContext)firstEvent.context()).getPath()).isNull();
            WatchKey createWatchDirKey = watcher.poll();
            AssertionsForClassTypes.assertThat((boolean)createWatchDirKey.isValid()).isTrue();
            AssertionsForClassTypes.assertThat((Object)createWatchDirKey.watchable()).isEqualTo((Object)fileInRootFolder);
            ArrayList watchDirEvents = new ArrayList();
            Awaitility.await().atMost(Duration.FIVE_SECONDS).until(this.fetchWatchEvents(createWatchDirKey, watchDirEvents, 1));
            AssertionsForClassTypes.assertThat(watchDirEvents).asList().hasSize(1);
            WatchEvent firstWatchDirEvent = (WatchEvent)watchDirEvents.get(0);
            AssertionsForClassTypes.assertThat((Object)firstWatchDirEvent.kind()).isEqualTo((Object)StandardWatchEventKind.ENTRY_CREATE);
            AssertionsForClassTypes.assertThat((int)firstWatchDirEvent.count()).isEqualTo(1);
            AssertionsForClassTypes.assertThat((Object)((WatchContext)firstWatchDirEvent.context()).getPath()).isEqualTo((Object)fileInRootFolder.getFileName());
            AssertionsForClassTypes.assertThat((Object)watcher.poll()).isNull();
        }
    }

    @Test
    public void testWatchEditFile() throws IOException {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path root = kfs.getPath("/", new String[0]);
        Path fileInRootFolder = kfs.getPath("/test.txt", new String[0]);
        try (WatchService watcher = kfs.newWatchService();){
            fileInRootFolder.register(watcher, new WatchEvent.Kind[0]);
            this.createOrEditFile(fileInRootFolder, "Hi");
            this.createOrEditFile(fileInRootFolder, "Welcome");
            this.createOrEditFile(fileInRootFolder, "Hello");
            WatchKey createRootKey = watcher.poll(30L, TimeUnit.SECONDS);
            AssertionsForClassTypes.assertThat((boolean)createRootKey.isValid()).isTrue();
            AssertionsForClassTypes.assertThat((Object)createRootKey.watchable()).isEqualTo((Object)root);
            ArrayList rootEvents = new ArrayList();
            Awaitility.await().atMost(Duration.FIVE_SECONDS).until(this.fetchWatchEvents(createRootKey, rootEvents, 2));
            AssertionsForClassTypes.assertThat(rootEvents).asList().hasSize(2);
            WatchEvent firstEvent = (WatchEvent)rootEvents.get(0);
            AssertionsForClassTypes.assertThat((Object)firstEvent.kind()).isEqualTo((Object)StandardWatchEventKind.ENTRY_CREATE);
            AssertionsForClassTypes.assertThat((int)firstEvent.count()).isEqualTo(1);
            AssertionsForClassTypes.assertThat((Object)((WatchContext)firstEvent.context()).getPath()).isNull();
            WatchEvent secondEvent = (WatchEvent)rootEvents.get(1);
            AssertionsForClassTypes.assertThat((Object)secondEvent.kind()).isEqualTo((Object)StandardWatchEventKind.ENTRY_MODIFY);
            AssertionsForClassTypes.assertThat((int)secondEvent.count()).isEqualTo(2);
            AssertionsForClassTypes.assertThat((Object)((WatchContext)secondEvent.context()).getPath()).isNull();
            WatchKey createWatchDirKey = watcher.poll();
            AssertionsForClassTypes.assertThat((boolean)createWatchDirKey.isValid()).isTrue();
            AssertionsForClassTypes.assertThat((Object)createWatchDirKey.watchable()).isEqualTo((Object)fileInRootFolder);
            ArrayList watchDirEvents = new ArrayList();
            Awaitility.await().atMost(Duration.FIVE_SECONDS).until(this.fetchWatchEvents(createWatchDirKey, watchDirEvents, 2));
            AssertionsForClassTypes.assertThat(watchDirEvents).asList().hasSize(2);
            WatchEvent firstWatchDirEvent = (WatchEvent)watchDirEvents.get(0);
            AssertionsForClassTypes.assertThat((Object)firstWatchDirEvent.kind()).isEqualTo((Object)StandardWatchEventKind.ENTRY_CREATE);
            AssertionsForClassTypes.assertThat((int)firstWatchDirEvent.count()).isEqualTo(1);
            AssertionsForClassTypes.assertThat((Object)((WatchContext)firstWatchDirEvent.context()).getPath()).isEqualTo((Object)fileInRootFolder.getFileName());
            WatchEvent secondWatchDirEvent = (WatchEvent)watchDirEvents.get(1);
            AssertionsForClassTypes.assertThat((Object)secondWatchDirEvent.kind()).isEqualTo((Object)StandardWatchEventKind.ENTRY_MODIFY);
            AssertionsForClassTypes.assertThat((int)secondWatchDirEvent.count()).isEqualTo(2);
            AssertionsForClassTypes.assertThat((Object)((WatchContext)secondWatchDirEvent.context()).getPath()).isEqualTo((Object)fileInRootFolder.getFileName());
            AssertionsForClassTypes.assertThat((Object)watcher.poll()).isNull();
        }
    }

    @Test
    public void testWatchDeleteFile() throws IOException {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path root = kfs.getPath("/", new String[0]);
        Path fileInRootFolder = kfs.getPath("/test.txt", new String[0]);
        try (WatchService watcher = kfs.newWatchService();){
            fileInRootFolder.register(watcher, new WatchEvent.Kind[0]);
            this.createOrEditFile(fileInRootFolder, "Hi");
            AssertionsForClassTypes.assertThat((boolean)Files.deleteIfExists((Path)fileInRootFolder, (DeleteOption[])new DeleteOption[0])).isTrue();
            WatchKey createRootKey = watcher.poll(30L, TimeUnit.SECONDS);
            AssertionsForClassTypes.assertThat((boolean)createRootKey.isValid()).isTrue();
            AssertionsForClassTypes.assertThat((Object)createRootKey.watchable()).isEqualTo((Object)root);
            ArrayList rootEvents = new ArrayList();
            Awaitility.await().atMost(Duration.FIVE_SECONDS).until(this.fetchWatchEvents(createRootKey, rootEvents, 2));
            AssertionsForClassTypes.assertThat(rootEvents).asList().hasSize(2);
            WatchEvent firstEvent = (WatchEvent)rootEvents.get(0);
            AssertionsForClassTypes.assertThat((Object)firstEvent.kind()).isEqualTo((Object)StandardWatchEventKind.ENTRY_CREATE);
            AssertionsForClassTypes.assertThat((int)firstEvent.count()).isEqualTo(1);
            AssertionsForClassTypes.assertThat((Object)((WatchContext)firstEvent.context()).getPath()).isNull();
            WatchEvent secondEvent = (WatchEvent)rootEvents.get(1);
            AssertionsForClassTypes.assertThat((Object)secondEvent.kind()).isEqualTo((Object)StandardWatchEventKind.ENTRY_MODIFY);
            AssertionsForClassTypes.assertThat((int)secondEvent.count()).isEqualTo(1);
            AssertionsForClassTypes.assertThat((Object)((WatchContext)secondEvent.context()).getPath()).isNull();
            WatchKey createWatchDirKey = watcher.poll();
            AssertionsForClassTypes.assertThat((boolean)createWatchDirKey.isValid()).isTrue();
            AssertionsForClassTypes.assertThat((Object)createWatchDirKey.watchable()).isEqualTo((Object)fileInRootFolder);
            ArrayList watchDirEvents = new ArrayList();
            Awaitility.await().atMost(Duration.FIVE_SECONDS).until(this.fetchWatchEvents(createWatchDirKey, watchDirEvents, 2));
            AssertionsForClassTypes.assertThat(watchDirEvents).asList().hasSize(2);
            WatchEvent firstWatchDirEvent = (WatchEvent)watchDirEvents.get(0);
            AssertionsForClassTypes.assertThat((Object)firstWatchDirEvent.kind()).isEqualTo((Object)StandardWatchEventKind.ENTRY_CREATE);
            AssertionsForClassTypes.assertThat((int)firstWatchDirEvent.count()).isEqualTo(1);
            AssertionsForClassTypes.assertThat((Object)((WatchContext)firstWatchDirEvent.context()).getPath()).isEqualTo((Object)fileInRootFolder.getFileName());
            WatchEvent thirdWatchDirEvent = (WatchEvent)watchDirEvents.get(1);
            AssertionsForClassTypes.assertThat((Object)thirdWatchDirEvent.kind()).isEqualTo((Object)StandardWatchEventKind.ENTRY_DELETE);
            AssertionsForClassTypes.assertThat((int)thirdWatchDirEvent.count()).isEqualTo(1);
            AssertionsForClassTypes.assertThat((Object)((WatchContext)thirdWatchDirEvent.context()).getPath()).isEqualTo((Object)fileInRootFolder.getFileName());
            AssertionsForClassTypes.assertThat((Object)watcher.poll()).isNull();
        }
    }

    @Test
    public void testCancelWatchKey() {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path root = kfs.getPath("/", new String[0]);
        Path watchDir = kfs.getPath("/watchDir", new String[0]);
        try (WatchService watcher = kfs.newWatchService();){
            watchDir.register(watcher, new WatchEvent.Kind[0]);
            Files.createDirectory((Path)watchDir, (FileAttribute[])new FileAttribute[0]);
            WatchKey createRootKey = watcher.poll(30L, TimeUnit.SECONDS);
            AssertionsForClassTypes.assertThat((boolean)createRootKey.isValid()).isTrue();
            AssertionsForClassTypes.assertThat((Object)createRootKey.watchable()).isEqualTo((Object)root);
            createRootKey.cancel();
            AssertionsForClassTypes.assertThat((boolean)createRootKey.isValid()).isFalse();
        }
    }

    @Test
    public void testResetWatchKey() {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path root = kfs.getPath("/", new String[0]);
        Path watchDir = kfs.getPath("/watchDir", new String[0]);
        try (WatchService watcher = kfs.newWatchService();){
            watchDir.register(watcher, new WatchEvent.Kind[0]);
            Files.createDirectory((Path)watchDir, (FileAttribute[])new FileAttribute[0]);
            WatchKey createRootKey = watcher.poll(30L, TimeUnit.SECONDS);
            AssertionsForClassTypes.assertThat((boolean)createRootKey.isValid()).isTrue();
            AssertionsForClassTypes.assertThat((Object)createRootKey.watchable()).isEqualTo((Object)root);
            AssertionsForClassTypes.assertThat((boolean)createRootKey.reset()).isTrue();
            AssertionsForClassTypes.assertThat((Object)createRootKey.pollEvents()).asList().isEmpty();
        }
    }

    @Test
    public void testResetCancelledWatchKey() {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path root = kfs.getPath("/", new String[0]);
        Path watchDir = kfs.getPath("/watchDir", new String[0]);
        try (WatchService watcher = kfs.newWatchService();){
            watchDir.register(watcher, new WatchEvent.Kind[0]);
            Files.createDirectory((Path)watchDir, (FileAttribute[])new FileAttribute[0]);
            WatchKey createRootKey = watcher.poll(30L, TimeUnit.SECONDS);
            AssertionsForClassTypes.assertThat((boolean)createRootKey.isValid()).isTrue();
            AssertionsForClassTypes.assertThat((Object)createRootKey.watchable()).isEqualTo((Object)root);
            createRootKey.cancel();
            AssertionsForClassTypes.assertThat((boolean)createRootKey.reset()).isFalse();
        }
    }

    @Test
    public void testPollWatchKeyWithTimeout() {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path root = kfs.getPath("/", new String[0]);
        Path watchDir = kfs.getPath("/watchDir", new String[0]);
        try (WatchService watcher = kfs.newWatchService();){
            watchDir.register(watcher, new WatchEvent.Kind[0]);
            Files.createDirectory((Path)watchDir, (FileAttribute[])new FileAttribute[0]);
            WatchKey createRootKey = watcher.poll(1L, TimeUnit.MILLISECONDS);
            AssertionsForClassTypes.assertThat((boolean)createRootKey.isValid()).isTrue();
            AssertionsForClassTypes.assertThat((Object)createRootKey.watchable()).isEqualTo((Object)root);
        }
    }

    @Test(timeout=30000L)
    public void testTakeWatchKey() {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path root = kfs.getPath("/", new String[0]);
        Path watchDir = kfs.getPath("/watchDir", new String[0]);
        try (WatchService watcher = kfs.newWatchService();){
            watchDir.register(watcher, new WatchEvent.Kind[0]);
            Runnable createDirectory = () -> Files.createDirectory((Path)watchDir, (FileAttribute[])new FileAttribute[0]);
            Thread createDirectoryThread = new Thread(createDirectory);
            createDirectoryThread.start();
            WatchKey createRootKey = watcher.take();
            AssertionsForClassTypes.assertThat((boolean)createRootKey.isValid()).isTrue();
            AssertionsForClassTypes.assertThat((Object)createRootKey.watchable()).isEqualTo((Object)root);
        }
    }

    @Test
    public void testCloseAlreadyClosedWatchService() {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        WatchService watcher = kfs.newWatchService();
        watcher.close();
        AssertionsForClassTypes.assertThat((boolean)watcher.isClose()).isTrue();
        watcher.close();
        AssertionsForClassTypes.assertThat((boolean)watcher.isClose()).isTrue();
    }

    private void createOrEditFile(Path file, String fileContent) throws IOException {
        try (OutputStream fileStream = Files.newOutputStream((Path)file, (OpenOption[])new OpenOption[0]);){
            fileStream.write(fileContent.getBytes());
            fileStream.flush();
        }
    }

    private String readFile(Path file) throws IOException {
        try (InputStream fileStream = Files.newInputStream((Path)file, (OpenOption[])new OpenOption[0]);){
            String string = IOUtils.toString((InputStream)fileStream, (String)StandardCharsets.UTF_8.name());
            return string;
        }
    }

    private Callable<Boolean> fetchWatchEvents(final WatchKey watchKey, final List<WatchEvent<?>> foundEvents, final int numberOfEventsExpected) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() {
                foundEvents.addAll(watchKey.pollEvents());
                if (foundEvents.size() >= numberOfEventsExpected) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
    }

    static {
        fsProvider = new K8SFileSystemProvider();
    }
}

