/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.k8s;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.OwnerReferenceBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.io.UnsupportedEncodingException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.InvalidPathException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardWatchEventKind;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.fs.cloud.CloudClientConstants;
import org.uberfire.java.nio.fs.k8s.K8SFileSystem;
import org.uberfire.java.nio.fs.k8s.K8SFileSystemConstants;
import org.uberfire.java.nio.fs.k8s.K8SFileSystemObjectType;

public class K8SFileSystemUtils {
    public static final String APP_NAME = System.getProperty("org.uberfire.java.nio.fs.k8s.app", "unknown");
    private static final Logger logger = LoggerFactory.getLogger(K8SFileSystemUtils.class);

    static Optional<ConfigMap> createOrReplaceParentDirFSCM(KubernetesClient client, Path self, long selfSize, boolean isUpdateForFileDeletion) {
        String selfName = K8SFileSystemUtils.getFileNameString(self);
        Path parent = Optional.ofNullable(self.getParent()).orElseThrow(IllegalArgumentException::new);
        Map parentContent = Optional.ofNullable(K8SFileSystemUtils.getFsObjCM(client, parent)).filter(K8SFileSystemUtils::isDirectory).map(ConfigMap::getData).orElseGet(HashMap::new);
        if (isUpdateForFileDeletion) {
            parentContent.remove(selfName);
        } else {
            parentContent.put(selfName, String.valueOf(selfSize));
        }
        long parentSize = parentContent.values().stream().mapToLong(Long::parseLong).sum();
        return Optional.of(K8SFileSystemUtils.createOrReplaceFSCM(client, parent, K8SFileSystemUtils.isRoot(parent) ? Optional.empty() : K8SFileSystemUtils.createOrReplaceParentDirFSCM(client, parent, parentSize, false), parentContent, true));
    }

    static ConfigMap createOrReplaceFSCM(KubernetesClient client, Path path, Optional<ConfigMap> parentOpt, Map<String, String> content, boolean isDir) {
        String fileName = K8SFileSystemUtils.getFileNameString(path);
        long size = 0L;
        Map<String, String> labels = K8SFileSystemUtils.getFsObjNameElementLabel(path);
        if (isDir) {
            if (labels.isEmpty()) {
                labels.put("k8s.fs.nio.java.uberfire.org/fsobj-type", K8SFileSystemObjectType.ROOT.toString());
            } else {
                labels.put("k8s.fs.nio.java.uberfire.org/fsobj-type", K8SFileSystemObjectType.DIR.toString());
            }
            size = content.values().stream().mapToLong(Long::parseLong).sum();
        } else {
            labels.put("k8s.fs.nio.java.uberfire.org/fsobj-type", K8SFileSystemObjectType.FILE.toString());
            size = parentOpt.map(cm -> Long.parseLong((String)cm.getData().get(fileName))).orElseThrow(() -> new IllegalStateException("File [" + fileName + "] is not found at parent directory [" + path.getParent().toString() + "]"));
        }
        labels.put("k8s.fs.nio.java.uberfire.org/fsobj-app", APP_NAME);
        ConcurrentHashMap<String, String> annotations = new ConcurrentHashMap<String, String>();
        annotations.put("k8s.fs.nio.java.uberfire.org/fsobj-lastModifiedTimestamp", ZonedDateTime.now().format(DateTimeFormatter.ISO_INSTANT));
        annotations.put("k8s.fs.nio.java.uberfire.org/fsobj-size", String.valueOf(size));
        String cmName = Optional.ofNullable(K8SFileSystemUtils.getFsObjCM(client, path)).map(cm -> cm.getMetadata().getName()).orElseGet(() -> "k8s-fsobj-" + UUID.randomUUID().toString());
        return parentOpt.map(parent -> (ConfigMap)client.configMaps().createOrReplace((Object[])new ConfigMap[]{((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(cmName)).withLabels(labels)).withAnnotations(annotations)).withOwnerReferences(new OwnerReference[]{((OwnerReferenceBuilder)((OwnerReferenceBuilder)((OwnerReferenceBuilder)((OwnerReferenceBuilder)new OwnerReferenceBuilder().withApiVersion(parent.getApiVersion())).withKind(parent.getKind())).withName(parent.getMetadata().getName())).withUid(parent.getMetadata().getUid())).build()})).endMetadata()).withData(content)).build()})).orElseGet(() -> (ConfigMap)client.configMaps().createOrReplace((Object[])new ConfigMap[]{((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(cmName)).withLabels(labels)).withAnnotations(annotations)).endMetadata()).withData(content)).build()}));
    }

    static boolean deleteAndUpdateParentCM(KubernetesClient client, Path path) {
        ConfigMap cm = K8SFileSystemUtils.getFsObjCM(client, path);
        if (cm != null && ((Boolean)((EditReplacePatchDeletable)((Resource)client.configMaps().withName(cm.getMetadata().getName())).cascading(true)).delete()).booleanValue()) {
            Optional.ofNullable(path.getParent()).ifPresent(p -> K8SFileSystemUtils.createOrReplaceParentDirFSCM(client, path, 0L, true));
            return true;
        }
        return false;
    }

    static ConfigMap getFsObjCM(KubernetesClient client, Path path) {
        int nameCount = path.getNameCount();
        Map<String, String> labels = K8SFileSystemUtils.getFsObjNameElementLabel(path);
        if (labels.isEmpty()) {
            labels.put("k8s.fs.nio.java.uberfire.org/fsobj-type", K8SFileSystemObjectType.ROOT.toString());
        }
        labels.put("k8s.fs.nio.java.uberfire.org/fsobj-app", APP_NAME);
        Object[] configMaps = ((ConfigMapList)((FilterWatchListDeletable)client.configMaps().withLabels(labels)).list()).getItems().stream().filter(cm -> cm.getMetadata().getLabels().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("k8s.fs.nio.java.uberfire.org/fsobj-name-")).count() == (long)nameCount).toArray();
        if (configMaps.length > 1) {
            throw new IllegalStateException("Ambiguous K8S FileSystem object name: [" + path.toString() + "]; should not have be associated with more than one K8S FileSystem ConfigMaps.");
        }
        if (configMaps.length == 1) {
            return (ConfigMap)configMaps[0];
        }
        return null;
    }

    static byte[] getFsObjContentBytes(ConfigMap cm) {
        byte[] content = new byte[]{};
        try {
            content = ((String)cm.getData().get("fsobj-content")).getBytes(CloudClientConstants.ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            logger.warn("Invalid encoding [{}], returns zero length byte array content.", (Object)CloudClientConstants.ENCODING);
        }
        catch (Exception e) {
            logger.error("Retrieve content from FsOjbCM [{}] failed, due to", (Object)cm, (Object)e);
        }
        return content;
    }

    static Map<String, String> getFsObjNameElementLabel(Path path) {
        ConcurrentHashMap<String, String> labels = new ConcurrentHashMap<String, String>();
        path.iterator().forEachRemaining(pathElement -> K8SFileSystemUtils.validateAndBuildPathLabel(labels, pathElement));
        return labels;
    }

    static void validateAndBuildPathLabel(Map<String, String> labels, Path pathElement) {
        StringBuilder nameKeyBuilder = new StringBuilder("k8s.fs.nio.java.uberfire.org/fsobj-name-");
        String pathElementStr = pathElement.toString();
        nameKeyBuilder.append(labels.size());
        if (K8SFileSystemConstants.K8S_FS_NAME_RESTRICATION.matcher(pathElementStr).matches() && pathElementStr.length() < 63) {
            if (pathElementStr.startsWith(".")) {
                pathElementStr = pathElementStr.substring(1);
                nameKeyBuilder.append(".").append("1");
            }
        } else {
            throw new InvalidPathException(pathElementStr, "A valid k8s filesystem object name must be less than 63 characters and valid by '" + K8SFileSystemConstants.K8S_FS_NAME_RESTRICATION.toString() + "'");
        }
        labels.put(nameKeyBuilder.toString(), pathElementStr);
    }

    static String getFileNameString(Path path) {
        return Optional.ofNullable(path.getFileName()).map(Object::toString).orElse("/");
    }

    static long getSize(ConfigMap fileCM) {
        return Long.parseLong(fileCM.getMetadata().getAnnotations().getOrDefault("k8s.fs.nio.java.uberfire.org/fsobj-size", "0"));
    }

    static long getCreationTime(ConfigMap fileCM) {
        return K8SFileSystemUtils.parseTimestamp(fileCM.getMetadata().getCreationTimestamp()).getEpochSecond();
    }

    static long getLastModifiedTime(ConfigMap fileCM) {
        return K8SFileSystemUtils.parseTimestamp((String)fileCM.getMetadata().getAnnotations().get("k8s.fs.nio.java.uberfire.org/fsobj-lastModifiedTimestamp")).getEpochSecond();
    }

    static Path getPathByFsObjCM(K8SFileSystem fs, ConfigMap cm) {
        StringBuilder pathBuilder = new StringBuilder();
        Map labels = cm.getMetadata().getLabels();
        ConcurrentHashMap labelsToBeSorted = new ConcurrentHashMap();
        if (labels.isEmpty() || !labels.containsKey("k8s.fs.nio.java.uberfire.org/fsobj-type")) {
            throw new IllegalArgumentException("Invalid K8SFileSystem ConfigMap - Missing required labels");
        }
        if (labels.containsValue(K8SFileSystemObjectType.ROOT.toString())) {
            return fs.getPath(fs.getSeparator(), new String[0]);
        }
        labels.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("k8s.fs.nio.java.uberfire.org/fsobj-name-")).forEach(entry -> labelsToBeSorted.put(K8SFileSystemUtils.extractPathElementIndex((String)entry.getKey()), entry));
        labelsToBeSorted.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> pathBuilder.append(fs.getSeparator()).append(K8SFileSystemUtils.extractPathElementStringWithHiddenIndicator((Map.Entry)entry.getValue())));
        return fs.getPath(pathBuilder.toString(), new String[0]);
    }

    static Float extractPathElementIndex(String pathElement) {
        return Float.valueOf(Float.parseFloat(pathElement.substring("k8s.fs.nio.java.uberfire.org/fsobj-name-".length())));
    }

    static String extractPathElementStringWithHiddenIndicator(Map.Entry<String, String> entry) {
        String pes = entry.getValue();
        if (entry.getKey().endsWith(".".concat("1"))) {
            return ".".concat(pes);
        }
        return pes;
    }

    public static boolean isRoot(Path path) {
        return path.getParent() == null;
    }

    static boolean isFile(ConfigMap fileCM) {
        return K8SFileSystemObjectType.FILE.toString().equals(fileCM.getMetadata().getLabels().getOrDefault("k8s.fs.nio.java.uberfire.org/fsobj-type", K8SFileSystemObjectType.UNKNOWN.toString()));
    }

    static boolean isDirectory(ConfigMap fileCM) {
        return K8SFileSystemObjectType.DIR.toString().equals(fileCM.getMetadata().getLabels().getOrDefault("k8s.fs.nio.java.uberfire.org/fsobj-type", K8SFileSystemObjectType.UNKNOWN.toString())) || K8SFileSystemObjectType.ROOT.toString().equals(fileCM.getMetadata().getLabels().getOrDefault("k8s.fs.nio.java.uberfire.org/fsobj-type", K8SFileSystemObjectType.UNKNOWN.toString()));
    }

    static Optional<WatchEvent.Kind> mapActionToKind(Watcher.Action action) {
        switch (action) {
            case ADDED: {
                return Optional.of(StandardWatchEventKind.ENTRY_CREATE);
            }
            case DELETED: {
                return Optional.of(StandardWatchEventKind.ENTRY_DELETE);
            }
            case MODIFIED: {
                return Optional.of(StandardWatchEventKind.ENTRY_MODIFY);
            }
        }
        return Optional.empty();
    }

    static Instant parseTimestamp(String timestamp) {
        return Optional.ofNullable(timestamp).map(ts -> ZonedDateTime.parse(ts, DateTimeFormatter.ISO_DATE_TIME).toInstant()).orElse(Instant.now());
    }
}

