/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.k8s;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.server.mock.KubernetesCrudDispatcher;
import io.fabric8.kubernetes.client.server.mock.KubernetesMockServer;
import io.fabric8.mockwebserver.Context;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;
import org.assertj.core.api.AssertionsForClassTypes;
import org.awaitility.Awaitility;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.uberfire.java.nio.base.WatchContext;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardWatchEventKind;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.java.nio.fs.k8s.K8SFileSystem;
import org.uberfire.java.nio.fs.k8s.K8SFileSystemProvider;
import org.uberfire.java.nio.fs.k8s.K8SFileSystemUtils;
import org.uberfire.java.nio.fs.k8s.K8SWatchKey;
import org.uberfire.java.nio.fs.k8s.K8SWatchService;

public class K8SWatchServiceTest {
    public static KubernetesMockServer SERVER = new KubernetesMockServer(new Context(), new MockWebServer(), new HashMap(), (Dispatcher)new KubernetesCrudDispatcher(), false);
    protected static String TEST_NAMESPACE = "test";
    protected static ThreadLocal<KubernetesClient> CLIENT_FACTORY;
    protected static final FileSystemProvider fsProvider;

    @BeforeClass
    public static void setup() {
        SERVER.init();
        CLIENT_FACTORY = ThreadLocal.withInitial(() -> SERVER.createClient());
        Assume.assumeFalse((String)"k8s does not support in Windows platform", (boolean)System.getProperty("os.name").toLowerCase().contains("windows"));
        ((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).createOrReplace((Object[])new ConfigMap[]{(ConfigMap)((Resource)CLIENT_FACTORY.get().configMaps().load(K8SWatchServiceTest.class.getResourceAsStream("/test-k8sfs-dir-r-configmap.yml"))).get()});
        ((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).createOrReplace((Object[])new ConfigMap[]{(ConfigMap)((Resource)CLIENT_FACTORY.get().configMaps().load(K8SWatchServiceTest.class.getResourceAsStream("/test-k8sfs-dir-0-configmap.yml"))).get()});
    }

    @AfterClass
    public static void tearDown() {
        ((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).delete();
        CLIENT_FACTORY.get().close();
        SERVER.destroy();
    }

    @Test
    public void testSetup() {
        FileSystem fileSystem = fsProvider.getFileSystem(URI.create("default:///"));
        Path root = fileSystem.getPath("/", new String[0]);
        Path dir = fileSystem.getPath("/testDir", new String[0]);
        AssertionsForClassTypes.assertThat((Object)root.getFileSystem().provider()).isEqualTo((Object)fsProvider);
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)root, (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)dir, (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.isDirectory((Path)root, (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.isDirectory((Path)root, (LinkOption[])new LinkOption[0])).isTrue();
    }

    @Test
    public void testWatchServiceOpenAndClose() throws URISyntaxException {
        FileSystem fileSystem = fsProvider.getFileSystem(URI.create("default:///"));
        WatchService ws = fileSystem.newWatchService();
        AssertionsForClassTypes.assertThat((boolean)ws.isClose()).isFalse();
        ws.close();
        Awaitility.await().until(() -> ((WatchService)ws).isClose());
        AssertionsForClassTypes.assertThat((boolean)ws.isClose()).isTrue();
    }

    @Test
    public void testMapActionToKind() {
        AssertionsForClassTypes.assertThat((boolean)K8SFileSystemUtils.mapActionToKind((Watcher.Action)Watcher.Action.ERROR).isPresent()).isFalse();
        AssertionsForClassTypes.assertThat((Object)((WatchEvent.Kind)K8SFileSystemUtils.mapActionToKind((Watcher.Action)Watcher.Action.ADDED).get())).isEqualTo((Object)StandardWatchEventKind.ENTRY_CREATE);
        AssertionsForClassTypes.assertThat((Object)((WatchEvent.Kind)K8SFileSystemUtils.mapActionToKind((Watcher.Action)Watcher.Action.MODIFIED).get())).isEqualTo((Object)StandardWatchEventKind.ENTRY_MODIFY);
        AssertionsForClassTypes.assertThat((Object)((WatchEvent.Kind)K8SFileSystemUtils.mapActionToKind((Watcher.Action)Watcher.Action.DELETED).get())).isEqualTo((Object)StandardWatchEventKind.ENTRY_DELETE);
    }

    @Test
    public void testWatchKey() {
        K8SFileSystem fileSystem = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path dir = fileSystem.getPath("/testDir", new String[0]);
        final boolean isWSClosed = false;
        K8SWatchKey wk = new K8SWatchKey(new K8SWatchService(fileSystem){

            public boolean isClose() {
                return isWSClosed;
            }
        }, dir);
        AssertionsForClassTypes.assertThat((boolean)wk.isValid()).isTrue();
        AssertionsForClassTypes.assertThat((Object)wk.pollEvents()).asList().isEmpty();
        AssertionsForClassTypes.assertThat((Object)wk.watchable()).isEqualTo((Object)dir);
        AssertionsForClassTypes.assertThat((boolean)wk.postEvent(StandardWatchEventKind.ENTRY_CREATE)).isTrue();
        AssertionsForClassTypes.assertThat((boolean)wk.isQueued()).isFalse();
        wk.signal();
        AssertionsForClassTypes.assertThat((boolean)wk.isQueued()).isTrue();
        AssertionsForClassTypes.assertThat((boolean)wk.reset()).isTrue();
        AssertionsForClassTypes.assertThat((Object)wk.pollEvents()).asList().isEmpty();
        AssertionsForClassTypes.assertThat((boolean)wk.isQueued()).isFalse();
        AssertionsForClassTypes.assertThat((boolean)wk.postEvent(StandardWatchEventKind.ENTRY_DELETE)).isTrue();
        wk.signal();
        AssertionsForClassTypes.assertThat((boolean)wk.isQueued()).isTrue();
        List eventList = wk.pollEvents();
        AssertionsForClassTypes.assertThat((int)eventList.size()).isEqualTo(1);
        WatchEvent event = (WatchEvent)eventList.get(0);
        AssertionsForClassTypes.assertThat((Object)event.kind()).isEqualTo((Object)StandardWatchEventKind.ENTRY_DELETE);
        AssertionsForClassTypes.assertThat((int)event.count()).isEqualTo(1);
        WatchContext wc = (WatchContext)event.context();
        AssertionsForClassTypes.assertThat((Object)wc.getPath()).isEqualTo((Object)dir.getFileName());
        AssertionsForClassTypes.assertThat((Object)wc.getOldPath()).isEqualTo((Object)dir.getFileName());
        AssertionsForClassTypes.assertThat((String)wc.getSessionId()).isEqualTo("Not implemented");
        AssertionsForClassTypes.assertThat((String)wc.getMessage()).isEqualTo("Not implemented");
        AssertionsForClassTypes.assertThat((String)wc.getUser()).isEqualTo("Not implemented");
        wk.cancel();
        AssertionsForClassTypes.assertThat((boolean)wk.isValid()).isFalse();
    }

    static {
        fsProvider = new K8SFileSystemProvider(){

            public KubernetesClient createKubernetesClient() {
                return CLIENT_FACTORY.get();
            }
        };
    }
}

