/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.k8s;

import com.google.common.collect.Lists;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.server.mock.KubernetesCrudDispatcher;
import io.fabric8.kubernetes.client.server.mock.KubernetesMockServer;
import io.fabric8.mockwebserver.Context;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.InvalidPathException;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.java.nio.fs.cloud.CloudClientConstants;
import org.uberfire.java.nio.fs.k8s.K8SFileSystem;
import org.uberfire.java.nio.fs.k8s.K8SFileSystemObjectType;
import org.uberfire.java.nio.fs.k8s.K8SFileSystemProvider;
import org.uberfire.java.nio.fs.k8s.K8SFileSystemUtils;

public class K8SFileSystemTest {
    public static KubernetesMockServer SERVER = new KubernetesMockServer(new Context(), new MockWebServer(), new HashMap(), (Dispatcher)new KubernetesCrudDispatcher(), false);
    protected static String TEST_NAMESPACE = "test";
    protected static ThreadLocal<KubernetesClient> CLIENT_FACTORY;
    protected static final FileSystemProvider fsProvider;

    protected String newFileWithContent(Path newFile, String testFileContent) throws java.io.IOException {
        Files.createFile((Path)newFile, (FileAttribute[])new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter((Path)newFile, (Charset)StandardCharsets.UTF_8, (OpenOption[])new OpenOption[0]);){
            writer.write(testFileContent, 0, testFileContent.length());
        }
        return testFileContent;
    }

    @BeforeClass
    public static void setup() {
        SERVER.init();
        CLIENT_FACTORY = ThreadLocal.withInitial(() -> SERVER.createClient());
        Assume.assumeFalse((String)"k8s does not support in Windows platform", (boolean)System.getProperty("os.name").toLowerCase().contains("windows"));
        ((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).createOrReplace((Object[])new ConfigMap[]{(ConfigMap)((Resource)CLIENT_FACTORY.get().configMaps().load(K8SFileSystemTest.class.getResourceAsStream("/test-k8sfs-dir-r-configmap.yml"))).get()});
        ((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).createOrReplace((Object[])new ConfigMap[]{(ConfigMap)((Resource)CLIENT_FACTORY.get().configMaps().load(K8SFileSystemTest.class.getResourceAsStream("/test-k8sfs-dir-0-configmap.yml"))).get()});
        ((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).createOrReplace((Object[])new ConfigMap[]{(ConfigMap)((Resource)CLIENT_FACTORY.get().configMaps().load(K8SFileSystemTest.class.getResourceAsStream("/test-k8sfs-file-configmap.yml"))).get()});
        ((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).createOrReplace((Object[])new ConfigMap[]{(ConfigMap)((Resource)CLIENT_FACTORY.get().configMaps().load(K8SFileSystemTest.class.getResourceAsStream("/test-k8sfs-dir-00-configmap.yml"))).get()});
    }

    @AfterClass
    public static void tearDown() {
        ((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).delete();
        CLIENT_FACTORY.get().close();
        SERVER.destroy();
    }

    @Test
    public void testSetup() {
        FileSystem fileSystem = fsProvider.getFileSystem(URI.create("default:///"));
        Path root = fileSystem.getPath("/", new String[0]);
        AssertionsForClassTypes.assertThat((Object)root.getFileSystem().provider()).isEqualTo((Object)fsProvider);
    }

    @Test
    public void testGetCMByName() {
        AssertionsForClassTypes.assertThat((Object)((ConfigMap)((Resource)((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).withName("dummy")).get())).isNull();
        AssertionsForClassTypes.assertThat((Object)((ConfigMap)((Resource)((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).withName("k8s-fsobj-86403b0c-78b7-11e9-ad76-8c16458eff35")).get())).isNotNull();
        AssertionsForClassTypes.assertThat((Object)((ConfigMap)((Resource)((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).withName("k8s-fsobj-e6bb5ba5-527f-11e9-8a93-8c16458eff35")).get())).isNotNull();
    }

    @Test
    public void testCreateOrReplaceFSCM() throws java.io.IOException {
        FileSystem fileSystem = fsProvider.getFileSystem(URI.create("default:///"));
        Path testDir = fileSystem.getPath("/testCreateOrReplaceFSCMDir", new String[0]);
        Path testFile = fileSystem.getPath("/testCreateOrReplaceFSCMDir/testCreateOrReplaceFSCMFile", new String[0]);
        K8SFileSystemUtils.createOrReplaceFSCM((KubernetesClient)CLIENT_FACTORY.get(), (Path)testDir, (Optional)K8SFileSystemUtils.createOrReplaceParentDirFSCM((KubernetesClient)CLIENT_FACTORY.get(), (Path)testDir, (long)0L, (boolean)false), Collections.emptyMap(), (boolean)true);
        ConfigMap testDirCM = K8SFileSystemUtils.getFsObjCM((KubernetesClient)CLIENT_FACTORY.get(), (Path)testDir);
        ConfigMap rootCM = (ConfigMap)((Resource)((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).withName("k8s-fsobj-e6bb5ba5-527f-11e9-8a93-8c16458eff35")).get();
        AssertionsForClassTypes.assertThat((Object)testDirCM).isNotNull();
        AssertionsForClassTypes.assertThat((String)((String)testDirCM.getMetadata().getLabels().get("k8s.fs.nio.java.uberfire.org/fsobj-name-0"))).isEqualTo("testCreateOrReplaceFSCMDir");
        AssertionsForClassTypes.assertThat((String)((String)testDirCM.getMetadata().getLabels().get("k8s.fs.nio.java.uberfire.org/fsobj-type"))).isEqualTo(K8SFileSystemObjectType.DIR.toString());
        AssertionsForClassTypes.assertThat((String)((String)testDirCM.getMetadata().getAnnotations().get("k8s.fs.nio.java.uberfire.org/fsobj-size"))).isEqualTo("0");
        AssertionsForClassTypes.assertThat((boolean)testDirCM.getData().isEmpty()).isTrue();
        AssertionsForClassTypes.assertThat((String)((OwnerReference)testDirCM.getMetadata().getOwnerReferences().get(0)).getKind()).isEqualTo(rootCM.getKind());
        AssertionsForClassTypes.assertThat((String)((OwnerReference)testDirCM.getMetadata().getOwnerReferences().get(0)).getName()).isEqualTo(rootCM.getMetadata().getName());
        String testFileContent = "Hello World";
        this.newFileWithContent(testFile, testFileContent);
        ConfigMap newDirCM = K8SFileSystemUtils.getFsObjCM((KubernetesClient)CLIENT_FACTORY.get(), (Path)fileSystem.getPath("/testCreateOrReplaceFSCMDir", new String[0]));
        ConfigMap newFileCM = K8SFileSystemUtils.getFsObjCM((KubernetesClient)CLIENT_FACTORY.get(), (Path)testFile);
        AssertionsForClassTypes.assertThat((Object)newDirCM).isNotNull();
        AssertionsForClassTypes.assertThat((Object)newFileCM).isNotNull();
        AssertionsForClassTypes.assertThat((String)((String)newDirCM.getMetadata().getAnnotations().get("k8s.fs.nio.java.uberfire.org/fsobj-lastModifiedTimestamp"))).isNotNull();
        AssertionsForClassTypes.assertThat((String)((String)newFileCM.getMetadata().getAnnotations().get("k8s.fs.nio.java.uberfire.org/fsobj-lastModifiedTimestamp"))).isNotNull();
        AssertionsForClassTypes.assertThat((String)((String)newFileCM.getData().get("fsobj-content"))).isEqualTo(testFileContent);
        AssertionsForClassTypes.assertThat((long)Files.size((Path)testFile)).isEqualTo((long)testFileContent.length());
    }

    @Test
    public void testGetFsObjCM() {
        FileSystem fileSystem = fsProvider.getFileSystem(URI.create("default:///"));
        Path root = fileSystem.getPath("/", new String[0]);
        Path dir = fileSystem.getPath("/testDir", new String[0]);
        Path file = fileSystem.getPath("/testDir/testFile", new String[0]);
        ConfigMap rootCM = (ConfigMap)((Resource)((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).withName("k8s-fsobj-e6bb5ba5-527f-11e9-8a93-8c16458eff35")).get();
        ConfigMap dirCM = (ConfigMap)((Resource)((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).withName("k8s-fsobj-e6bb5ba5-527f-11e9-8a93-8c16458eff36")).get();
        ConfigMap fileCM = (ConfigMap)((Resource)((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).withName("k8s-fsobj-86403b0c-78b7-11e9-ad76-8c16458eff35")).get();
        AssertionsForClassTypes.assertThat((Object)K8SFileSystemUtils.getFsObjCM((KubernetesClient)CLIENT_FACTORY.get(), (Path)root)).isEqualTo((Object)rootCM);
        AssertionsForClassTypes.assertThat((Object)K8SFileSystemUtils.getFsObjCM((KubernetesClient)CLIENT_FACTORY.get(), (Path)dir)).isEqualTo((Object)dirCM);
        AssertionsForClassTypes.assertThat((Object)K8SFileSystemUtils.getFsObjCM((KubernetesClient)CLIENT_FACTORY.get(), (Path)file)).isEqualTo((Object)fileCM);
    }

    @Test
    public void testGetFsObjContentBytes() {
        ConfigMap fileCM = (ConfigMap)((Resource)((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).withName("k8s-fsobj-86403b0c-78b7-11e9-ad76-8c16458eff35")).get();
        String fileContent = new String(K8SFileSystemUtils.getFsObjContentBytes((ConfigMap)fileCM), Charset.forName(CloudClientConstants.ENCODING));
        AssertionsForClassTypes.assertThat((String)fileContent).isEqualTo("This is a test file");
    }

    @Test
    public void testGetFsObjNameElement() {
        FileSystem fileSystem = fsProvider.getFileSystem(URI.create("default:///"));
        Path aFile = fileSystem.getPath("/testDir/../testDir/./testFile", new String[0]);
        Map ne = K8SFileSystemUtils.getFsObjNameElementLabel((Path)((K8SFileSystemProvider)fsProvider).toAbsoluteRealPath(aFile));
        AssertionsForClassTypes.assertThat((int)ne.size()).isEqualTo(2);
        AssertionsForClassTypes.assertThat((boolean)ne.containsValue("testDir")).isTrue();
        AssertionsForClassTypes.assertThat((boolean)ne.containsValue("testFile")).isTrue();
    }

    @Test
    public void testGetSize() {
        ConfigMap cfm = (ConfigMap)((Resource)((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).withName("k8s-fsobj-86403b0c-78b7-11e9-ad76-8c16458eff35")).get();
        AssertionsForClassTypes.assertThat((long)K8SFileSystemUtils.getSize((ConfigMap)cfm)).isEqualTo(19L);
    }

    @Test
    public void testGetCreationTime() {
        ConfigMap cfm = (ConfigMap)((Resource)((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).withName("k8s-fsobj-86403b0c-78b7-11e9-ad76-8c16458eff35")).get();
        AssertionsForClassTypes.assertThat((long)K8SFileSystemUtils.getCreationTime((ConfigMap)cfm)).isEqualTo(0L);
    }

    @Test
    public void testGetPathByFsObjCM() {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path f = kfs.getPath("/testDir/testFile", new String[0]);
        AssertionsForClassTypes.assertThat((Object)f.getRoot()).isNotNull();
        AssertionsForClassTypes.assertThat((int)f.getNameCount()).isEqualTo(2);
        AssertionsForClassTypes.assertThat((Object)f.getParent()).isEqualTo((Object)kfs.getPath("/testDir", new String[0]));
        AssertionsForClassTypes.assertThat((String)f.getName(0).toString()).isEqualTo("testDir");
        AssertionsForClassTypes.assertThat((String)f.getName(1).toString()).isEqualTo("testFile");
        AssertionsForClassTypes.assertThat((String)f.toUri().toString()).isEqualTo(fsProvider.getScheme() + ":///testDir/testFile");
        ConfigMap rootCM = (ConfigMap)((Resource)((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).withName("k8s-fsobj-e6bb5ba5-527f-11e9-8a93-8c16458eff35")).get();
        ConfigMap dirCM = (ConfigMap)((Resource)((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).withName("k8s-fsobj-e6bb5ba5-527f-11e9-8a93-8c16458eff36")).get();
        ConfigMap fileCM = (ConfigMap)((Resource)((NonNamespaceOperation)CLIENT_FACTORY.get().configMaps().inNamespace(TEST_NAMESPACE)).withName("k8s-fsobj-86403b0c-78b7-11e9-ad76-8c16458eff35")).get();
        AssertionsForClassTypes.assertThat((Object)K8SFileSystemUtils.getPathByFsObjCM((K8SFileSystem)kfs, (ConfigMap)rootCM)).isEqualTo((Object)kfs.getPath("/", new String[0]));
        AssertionsForClassTypes.assertThat((Object)K8SFileSystemUtils.getPathByFsObjCM((K8SFileSystem)kfs, (ConfigMap)dirCM)).isEqualTo((Object)kfs.getPath("/testDir", new String[0]));
        AssertionsForClassTypes.assertThat((Object)K8SFileSystemUtils.getPathByFsObjCM((K8SFileSystem)kfs, (ConfigMap)fileCM)).isEqualTo((Object)kfs.getPath("/testDir/testFile", new String[0]));
    }

    @Test
    public void testIsFile() {
        ConfigMap cfm = (ConfigMap)((Resource)CLIENT_FACTORY.get().configMaps().load(K8SFileSystemTest.class.getResourceAsStream("/test-k8sfs-file-configmap.yml"))).get();
        AssertionsForClassTypes.assertThat((boolean)K8SFileSystemUtils.isFile((ConfigMap)cfm)).isTrue();
        AssertionsForClassTypes.assertThat((boolean)K8SFileSystemUtils.isDirectory((ConfigMap)cfm)).isFalse();
    }

    @Test
    public void testIsDir() {
        ConfigMap cfm = (ConfigMap)((Resource)CLIENT_FACTORY.get().configMaps().load(K8SFileSystemTest.class.getResourceAsStream("/test-k8sfs-dir-0-configmap.yml"))).get();
        AssertionsForClassTypes.assertThat((boolean)K8SFileSystemUtils.isFile((ConfigMap)cfm)).isFalse();
        AssertionsForClassTypes.assertThat((boolean)K8SFileSystemUtils.isDirectory((ConfigMap)cfm)).isTrue();
    }

    @Test
    public void testFileMetadata() {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path d = kfs.getPath("/testDir", new String[0]);
        Path f = kfs.getPath("/testDir/testFile", new String[0]);
        Path e = kfs.getPath("/doesNotExist", new String[0]);
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)e, (LinkOption[])new LinkOption[0])).isFalse();
        AssertionsForClassTypes.assertThat((boolean)Files.notExists((Path)e, (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.isDirectory((Path)d, (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.isRegularFile((Path)d, (LinkOption[])new LinkOption[0])).isFalse();
        AssertionsForClassTypes.assertThat((boolean)Files.isDirectory((Path)f, (LinkOption[])new LinkOption[0])).isFalse();
        AssertionsForClassTypes.assertThat((boolean)Files.isRegularFile((Path)f, (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.isReadable((Path)f)).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.isWritable((Path)f)).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.isExecutable((Path)f)).isFalse();
    }

    @Test
    public void testDelete() throws java.io.IOException {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path f = kfs.getPath("/testDeleteFile", new String[0]);
        String testFileContent = "Hello World";
        this.newFileWithContent(f, testFileContent);
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)f, (LinkOption[])new LinkOption[0])).isTrue();
        Files.delete((Path)f, (DeleteOption[])new DeleteOption[0]);
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)f, (LinkOption[])new LinkOption[0])).isFalse();
    }

    @Test(expected=NoSuchFileException.class)
    public void testDeleteNotExistingFile() {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path f = kfs.getPath("/testDeleteNotExistingFile", new String[0]);
        Files.delete((Path)f, (DeleteOption[])new DeleteOption[0]);
    }

    @Test
    public void testDeleteIfExists() throws java.io.IOException {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path f = kfs.getPath("/testDeleteIfExists", new String[0]);
        AssertionsForClassTypes.assertThat((boolean)Files.deleteIfExists((Path)f, (DeleteOption[])new DeleteOption[0])).isFalse();
        String testFileContent = "Hello World";
        this.newFileWithContent(f, testFileContent);
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)f, (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.deleteIfExists((Path)f, (DeleteOption[])new DeleteOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)f, (LinkOption[])new LinkOption[0])).isFalse();
    }

    @Test
    public void testCopy() throws java.io.IOException {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path src = kfs.getPath("/testCopySrc", new String[0]);
        Path target = kfs.getPath("/testCopyTarget", new String[0]);
        String testFileContent = "Test copy capability";
        this.newFileWithContent(src, testFileContent);
        Files.copy((Path)src, (Path)target, (CopyOption[])new CopyOption[0]);
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)target, (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((String)((String)K8SFileSystemUtils.getFsObjCM((KubernetesClient)CLIENT_FACTORY.get(), (Path)target).getData().get("fsobj-content"))).isEqualTo(testFileContent);
    }

    @Test
    public void testMove() throws java.io.IOException {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path src = kfs.getPath("/testMoveSrc", new String[0]);
        Path target = kfs.getPath("/testMoveTarget", new String[0]);
        String testFileContent = "Test move capability";
        this.newFileWithContent(src, testFileContent);
        Files.move((Path)src, (Path)target, (CopyOption[])new CopyOption[0]);
        AssertionsForClassTypes.assertThat((boolean)Files.notExists((Path)src, (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)target, (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((String)((String)K8SFileSystemUtils.getFsObjCM((KubernetesClient)CLIENT_FACTORY.get(), (Path)target).getData().get("fsobj-content"))).isEqualTo(testFileContent);
    }

    @Test
    public void testCreateAndReadDir() {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path testDir = kfs.getPath("/testDir", new String[0]);
        Path testFile = kfs.getPath("/testDir/testFile", new String[0]);
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)testDir, (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.isDirectory((Path)testDir, (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.isHidden((Path)testDir)).isFalse();
        try (DirectoryStream stream = Files.newDirectoryStream((Path)testDir);){
            ArrayList dirContent = Lists.newArrayList((Iterable)stream);
            AssertionsForClassTypes.assertThat((Object)dirContent).asList().containsExactly(new Object[]{testFile});
        }
    }

    @Test
    public void testCreateAndReadHiddenDir() {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path aDir = kfs.getPath("/.testCreateAndReadDir", new String[0]);
        Path root = aDir.getRoot();
        Files.createDirectory((Path)aDir, (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)aDir, (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.isDirectory((Path)aDir, (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.isHidden((Path)aDir)).isTrue();
        try (DirectoryStream stream = Files.newDirectoryStream((Path)root);){
            ArrayList dirContent = Lists.newArrayList((Iterable)stream);
            AssertionsForClassTypes.assertThat((Object)dirContent).asList().contains(new Object[]{aDir});
        }
    }

    @Test
    public void testCreateDuplicateDirectory() {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path testDir = kfs.getPath("/testCreateDuplicateDirectory", new String[0]);
        Files.createDirectory((Path)testDir, (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)testDir, (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.isDirectory((Path)testDir, (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((Throwable)AssertionsForClassTypes.catchThrowable(() -> Files.createDirectory((Path)testDir, (FileAttribute[])new FileAttribute[0]))).isInstanceOf(FileAlreadyExistsException.class);
    }

    @Test
    public void testOverwriteFile() throws java.io.IOException {
        String line;
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path testFile = kfs.getPath("/testOverwriteFile", new String[0]);
        String content = "Large content, blah, blah, blah...";
        String smallerContent = "Small";
        this.newFileWithContent(testFile, "Large content, blah, blah, blah...");
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)testFile, (LinkOption[])new LinkOption[0])).isTrue();
        try (BufferedWriter writer = Files.newBufferedWriter((Path)testFile, (Charset)Charset.forName("UTF-8"), (OpenOption[])new OpenOption[0]);){
            writer.write("Small", 0, "Small".length());
        }
        StringBuffer sb = new StringBuffer();
        try (BufferedReader reader = Files.newBufferedReader((Path)testFile, (Charset)Charset.forName("UTF-8"));){
            line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        AssertionsForClassTypes.assertThat((String)sb.toString()).isEqualTo("Small");
        try (BufferedWriter writer = Files.newBufferedWriter((Path)testFile, (Charset)Charset.forName("UTF-8"), (OpenOption[])new OpenOption[0]);){
            writer.write("Large content, blah, blah, blah...", 0, "Large content, blah, blah, blah...".length());
        }
        sb = new StringBuffer();
        reader = Files.newBufferedReader((Path)testFile, (Charset)Charset.forName("UTF-8"));
        try {
            line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        AssertionsForClassTypes.assertThat((String)sb.toString()).isEqualTo("Large content, blah, blah, blah...");
    }

    @Test
    public void testParentDirShouldBeUpdatedAfterDelete() throws java.io.IOException {
        ArrayList dirContent;
        FileSystem fileSystem = fsProvider.getFileSystem(URI.create("default:///"));
        Path root = fileSystem.getPath("/", new String[0]);
        Path testDir = fileSystem.getPath("/testParentDirShouldBeUpdatedAfterDeleteDir", new String[0]);
        Path testFile = fileSystem.getPath("/testParentDirShouldBeUpdatedAfterDeleteDir/testParentDirShouldBeUpdatedAfterDeleteFile", new String[0]);
        this.newFileWithContent(testFile, "I'm here");
        AssertionsForClassTypes.assertThat((boolean)Files.deleteIfExists((Path)testFile, (DeleteOption[])new DeleteOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((long)Files.size((Path)testDir)).isEqualTo(0L);
        AssertionsForClassTypes.assertThat((boolean)K8SFileSystemUtils.getFsObjCM((KubernetesClient)CLIENT_FACTORY.get(), (Path)testDir).getData().isEmpty()).isTrue();
        try (DirectoryStream stream = Files.newDirectoryStream((Path)root);){
            dirContent = Lists.newArrayList((Iterable)stream);
            AssertionsForClassTypes.assertThat((Object)dirContent).asList().contains(new Object[]{testDir});
        }
        stream = Files.newDirectoryStream((Path)testDir);
        try {
            dirContent = Lists.newArrayList((Iterable)stream);
            AssertionsForClassTypes.assertThat((Object)dirContent).asList().isEmpty();
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    @Test
    public void testFileNameValidation() {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path invalid = kfs.getPath("/#weirdFileName$@#^&*", new String[0]);
        Path hidden = kfs.getPath("/.testFileNameValidation", new String[0]);
        Path tooLongFileName = kfs.getPath("/testFileNameValidationForTooLongFileNameWhichIsLongerThanSixtyThreeCharacters", new String[0]);
        AssertionsForClassTypes.assertThat((Throwable)AssertionsForClassTypes.catchThrowable(() -> K8SFileSystemUtils.validateAndBuildPathLabel(new HashMap(), (Path)invalid.getFileName()))).isInstanceOf(InvalidPathException.class);
        AssertionsForClassTypes.assertThat((Throwable)AssertionsForClassTypes.catchThrowable(() -> K8SFileSystemUtils.validateAndBuildPathLabel(new HashMap(), (Path)hidden.getFileName()))).isNull();
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThat((Throwable)AssertionsForClassTypes.catchThrowable(() -> this.newFileWithContent(invalid, "blah..."))).isInstanceOf(IOException.class)).hasRootCauseInstanceOf(InvalidPathException.class);
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThat((Throwable)AssertionsForClassTypes.catchThrowable(() -> this.newFileWithContent(tooLongFileName, "blah..."))).isInstanceOf(IOException.class)).hasRootCauseInstanceOf(InvalidPathException.class);
    }

    @Test
    public void testCreateHiddenFile() throws java.io.IOException {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path hidden = kfs.getPath("/.testCreateHiddenDir/.testCreateHiddenFile", new String[0]);
        this.newFileWithContent(hidden, "blah...");
        ConfigMap cm = K8SFileSystemUtils.getFsObjCM((KubernetesClient)CLIENT_FACTORY.get(), (Path)hidden);
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)hidden, (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.isHidden((Path)hidden)).isTrue();
        AssertionsForClassTypes.assertThat((Object)K8SFileSystemUtils.getPathByFsObjCM((K8SFileSystem)kfs, (ConfigMap)cm)).isEqualTo((Object)hidden);
    }

    @Test
    public void testCopyHiddenFile() throws java.io.IOException {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path src = kfs.getPath("/.testCopyHiddenFileSrcFile", new String[0]);
        Path target = kfs.getPath("/.testCopyHiddenFileTargetFile", new String[0]);
        String testFileContent = "Test copy capability";
        this.newFileWithContent(src, testFileContent);
        Files.copy((Path)src, (Path)target, (CopyOption[])new CopyOption[0]);
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)target, (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.isHidden((Path)target)).isTrue();
        AssertionsForClassTypes.assertThat((String)((String)K8SFileSystemUtils.getFsObjCM((KubernetesClient)CLIENT_FACTORY.get(), (Path)target).getData().get("fsobj-content"))).isEqualTo(testFileContent);
    }

    @Test
    public void testMoveHiddenFile() throws java.io.IOException {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path src = kfs.getPath("/.testMoveHiddenFileSrc", new String[0]);
        Path targetPublic = kfs.getPath("/testMoveHiddenFileTargetPublic", new String[0]);
        Path targetHidden = kfs.getPath("/.testMoveHiddenFileTargetHidden", new String[0]);
        String testFileContent = "Test move capability";
        this.newFileWithContent(src, testFileContent);
        Files.move((Path)src, (Path)targetPublic, (CopyOption[])new CopyOption[0]);
        AssertionsForClassTypes.assertThat((boolean)Files.notExists((Path)src, (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)targetPublic, (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.isHidden((Path)targetPublic)).isFalse();
        AssertionsForClassTypes.assertThat((String)((String)K8SFileSystemUtils.getFsObjCM((KubernetesClient)CLIENT_FACTORY.get(), (Path)targetPublic).getData().get("fsobj-content"))).isEqualTo(testFileContent);
        Files.move((Path)targetPublic, (Path)targetHidden, (CopyOption[])new CopyOption[0]);
        AssertionsForClassTypes.assertThat((boolean)Files.notExists((Path)targetPublic, (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.exists((Path)targetHidden, (LinkOption[])new LinkOption[0])).isTrue();
        AssertionsForClassTypes.assertThat((boolean)Files.isHidden((Path)targetHidden)).isTrue();
        AssertionsForClassTypes.assertThat((String)((String)K8SFileSystemUtils.getFsObjCM((KubernetesClient)CLIENT_FACTORY.get(), (Path)targetHidden).getData().get("fsobj-content"))).isEqualTo(testFileContent);
    }

    @Test
    public void testReadNotExistingFile() throws java.io.IOException {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path testFile = kfs.getPath("/testReadNotExistingFile", new String[0]);
        AssertionsForClassTypes.assertThat((Throwable)AssertionsForClassTypes.catchThrowable(() -> Files.newBufferedReader((Path)testFile, (Charset)Charset.forName("UTF-8")))).isInstanceOf(NoSuchFileException.class);
    }

    @Test
    public void testIsHiddenNotExistingFile() {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path testFile = kfs.getPath("/testIsHiddenNotExistingFile", new String[0]);
        AssertionsForClassTypes.assertThat((Throwable)AssertionsForClassTypes.catchThrowable(() -> Files.isHidden((Path)testFile))).isInstanceOf(IOException.class);
    }

    @Test
    public void testIsHiddenManyNestedFolders() {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path testFolder11 = kfs.getPath("/testIsHiddenManyNestedFolders/1/2/3/4/5/6/7/8/9/10/11", new String[0]);
        Path testFolder12 = kfs.getPath("/testIsHiddenManyNestedFolders/1/2/3/4/5/6/7/8/9/10/11/.12", new String[0]);
        Files.createDirectory((Path)testFolder12, (FileAttribute[])new FileAttribute[0]);
        AssertionsForClassTypes.assertThat((boolean)Files.isHidden((Path)testFolder11)).isFalse();
        AssertionsForClassTypes.assertThat((boolean)Files.isHidden((Path)testFolder12)).isTrue();
    }

    @Test
    public void testGetDirectoryContentManyNestedFolders() {
        K8SFileSystem kfs = (K8SFileSystem)fsProvider.getFileSystem(URI.create("default:///"));
        Path testFolder11 = kfs.getPath("/testGetDirectoryContentManyNestedFolders/1/2/3/4/5/6/7/8/9/.10/11", new String[0]);
        Path testFolder12 = kfs.getPath("/testGetDirectoryContentManyNestedFolders/1/2/3/4/5/6/7/8/9/.10/11/.12", new String[0]);
        Files.createDirectory((Path)testFolder12, (FileAttribute[])new FileAttribute[0]);
        Object[] directoryContent = ((K8SFileSystemProvider)fsProvider).getDirectoryContent(testFolder11);
        AssertionsForClassTypes.assertThat((Object[])directoryContent).contains((Object[])new Path[]{testFolder12});
    }

    static {
        fsProvider = new K8SFileSystemProvider(){

            public KubernetesClient createKubernetesClient() {
                return CLIENT_FACTORY.get();
            }
        };
    }
}

