/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.base;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.uberfire.java.nio.base.AttrsStorage;
import org.uberfire.java.nio.base.ExtendedAttributeView;
import org.uberfire.java.nio.base.Properties;
import org.uberfire.java.nio.file.attribute.AttributeView;

public class AttrsStorageImpl
implements AttrsStorage {
    final Properties content = new Properties();
    final Map<String, AttributeView> viewsNameIndex = new HashMap<String, AttributeView>();
    final Map<Class<?>, AttributeView> viewsTypeIndex = new HashMap();

    @Override
    public AttrsStorage getAttrStorage() {
        return this;
    }

    @Override
    public <V extends AttributeView> void addAttrView(V view) {
        this.viewsNameIndex.put(view.name(), view);
        if (view instanceof ExtendedAttributeView) {
            ExtendedAttributeView extendedView = (ExtendedAttributeView)view;
            for (Class type : extendedView.viewTypes()) {
                this.viewsTypeIndex.put(type, view);
            }
        } else {
            this.viewsTypeIndex.put(view.getClass(), view);
        }
    }

    @Override
    public <V extends AttributeView> V getAttrView(Class<V> type) {
        return (V)this.viewsTypeIndex.get(type);
    }

    @Override
    public <V extends AttributeView> V getAttrView(String name) {
        return (V)this.viewsNameIndex.get(name);
    }

    @Override
    public void clear() {
        this.viewsNameIndex.clear();
        this.viewsTypeIndex.clear();
        this.content.clear();
    }

    @Override
    public Properties toProperties() {
        return this.buildProperties(false);
    }

    @Override
    public void loadContent(Properties properties) {
        this.content.clear();
        for (Map.Entry attr : properties.entrySet()) {
            this.content.put((String)attr.getKey(), attr.getValue());
        }
    }

    @Override
    public Map<String, Object> getContent() {
        return Collections.unmodifiableMap(this.buildProperties(false));
    }

    @Override
    public Map<String, Object> getAllContent() {
        return Collections.unmodifiableMap(this.buildProperties(true));
    }

    private synchronized Properties buildProperties(boolean includesNonSerializable) {
        Properties properties = new Properties(this.content);
        for (Map.Entry<String, AttributeView> view : this.viewsNameIndex.entrySet()) {
            if (!includesNonSerializable && (!(view.getValue() instanceof ExtendedAttributeView) || !((ExtendedAttributeView)view.getValue()).isSerializable())) continue;
            ExtendedAttributeView extendedView = (ExtendedAttributeView)view.getValue();
            for (Map.Entry<String, Object> attr : extendedView.readAllAttributes().entrySet()) {
                properties.put(attr.getKey(), attr.getValue());
            }
        }
        return properties;
    }
}

