/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.base;

import java.io.File;
import java.net.URI;
import org.apache.commons.lang3.SystemUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.ObjectAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.java.nio.base.GeneralPathImpl;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.spi.FileSystemProvider;

public class GeneralPathTest {
    private static final String DEFAULT_PATH = new File("").getAbsolutePath().replace('\\', '/') + "/";
    final FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);

    @Test
    public void testSimpleAbsoluteUnix() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        AssertionsForClassTypes.assertThat((boolean)path.isAbsolute()).isTrue();
        AssertionsForClassTypes.assertThat((Object)path.toAbsolutePath()).isEqualTo((Object)path);
        AssertionsForClassTypes.assertThat((String)path.toString()).isEqualTo("/path/to/file.txt");
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)path.getFileSystem()).isNotNull()).isEqualTo((Object)this.fs);
        AssertionsForClassTypes.assertThat((Object)path.getFileName()).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.getFileName().toString()).isEqualTo("file.txt");
        AssertionsForClassTypes.assertThat((int)path.getNameCount()).isEqualTo(3);
        AssertionsForClassTypes.assertThat((Object)path.getName(0)).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.getName(0).toString()).isEqualTo("path");
        AssertionsForClassTypes.assertThat((Object)path.getName(1)).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.getName(1).toString()).isEqualTo("to");
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)path.getName(2)).isNotNull()).isEqualTo((Object)path.getFileName());
        AssertionsForClassTypes.assertThat((Object)path.subpath(0, 1)).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.subpath(0, 1).toString()).isEqualTo("path");
        AssertionsForClassTypes.assertThat((Object)path.subpath(1, 2)).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.subpath(1, 2).toString()).isEqualTo("to");
        AssertionsForClassTypes.assertThat((Object)path.subpath(0, 2)).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.subpath(0, 2).toString()).isEqualTo("path/to");
        AssertionsForClassTypes.assertThat((Object)path.subpath(1, 3)).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.subpath(1, 3).toString()).isEqualTo("to/file.txt");
        int i = 0;
        for (Path currentPath : path) {
            AssertionsForClassTypes.assertThat((Object)currentPath).isEqualTo((Object)path.getName(i));
            ++i;
        }
        AssertionsForClassTypes.assertThat((Object)path.getParent()).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.getParent().toString()).isEqualTo("/path/to");
        AssertionsForClassTypes.assertThat((Object)path.getParent().getParent()).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.getParent().getParent().toString()).isEqualTo("/path");
        AssertionsForClassTypes.assertThat((Object)path.getParent().getParent().getParent()).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.getParent().getParent().getParent().toString()).isEqualTo("/");
        AssertionsForClassTypes.assertThat((Object)path.getRoot().getParent()).isNull();
        AssertionsForClassTypes.assertThat((Object)path.getRoot()).isNotNull();
        ((AbstractStringAssert)AssertionsForClassTypes.assertThat((String)path.getRoot().toString()).isNotNull()).isEqualTo("/");
    }

    @Test
    public void testSimpleRootUnix() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/", (boolean)false);
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        AssertionsForClassTypes.assertThat((boolean)path.isAbsolute()).isTrue();
        AssertionsForClassTypes.assertThat((String)path.toString()).isEqualTo("/");
        AssertionsForClassTypes.assertThat((Object)path.getFileName()).isNull();
        AssertionsForClassTypes.assertThat((int)path.getNameCount()).isEqualTo(0);
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)path.getRoot()).isNotNull()).isEqualTo((Object)path);
        try {
            path.getName(0);
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (Exception e) {
            AssertionsForClassTypes.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class);
        }
    }

    @Test
    public void startsWith() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        Assert.assertTrue((boolean)path.startsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"/path", (boolean)false)));
        Assert.assertTrue((boolean)path.startsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to", (boolean)false)));
        Assert.assertTrue((boolean)path.startsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false)));
        Assert.assertFalse((boolean)path.startsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"/p/th/to/file.txt", (boolean)false)));
        Assert.assertFalse((boolean)path.startsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"/some/other/path/to/file.txt", (boolean)false)));
        Assert.assertFalse((boolean)path.startsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to/file.txt", (boolean)false)));
        Assert.assertFalse((boolean)path.startsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to", (boolean)false)));
        Assert.assertFalse((boolean)path.startsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"to", (boolean)false)));
    }

    @Test
    public void startsWithWindows() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"\\");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to\\file.txt", (boolean)false);
        GeneralPathImpl unixFormatPath = GeneralPathImpl.create((FileSystem)this.fs, (String)"/c:/path/to/file.txt", (boolean)false);
        Assert.assertTrue((boolean)path.startsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\", (boolean)false)));
        Assert.assertTrue((boolean)path.startsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path", (boolean)false)));
        Assert.assertTrue((boolean)path.startsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to\\", (boolean)false)));
        Assert.assertTrue((boolean)path.startsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to\\file.txt", (boolean)false)));
        Assert.assertFalse((boolean)path.startsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\to\\file.txt", (boolean)false)));
        Assert.assertFalse((boolean)path.startsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"d:\\", (boolean)false)));
        Assert.assertFalse((boolean)path.startsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"/d:/", (boolean)false)));
        Assert.assertFalse((boolean)path.startsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"d:\\path\\to\\file.txt", (boolean)false)));
        Assert.assertTrue((boolean)path.startsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"/c:/", (boolean)false)));
        Assert.assertTrue((boolean)path.startsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"/c:/path/", (boolean)false)));
        Assert.assertTrue((boolean)unixFormatPath.startsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\", (boolean)false)));
        Assert.assertTrue((boolean)unixFormatPath.startsWith((Path)path));
        Assert.assertTrue((boolean)path.startsWith((Path)unixFormatPath));
    }

    @Test
    public void endsWith() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        Assert.assertTrue((boolean)path.endsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"file.txt", (boolean)false)));
        Assert.assertTrue((boolean)path.endsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"to/file.txt", (boolean)false)));
        Assert.assertTrue((boolean)path.endsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false)));
        Assert.assertFalse((boolean)path.endsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"filename.txt", (boolean)false)));
        Assert.assertFalse((boolean)path.endsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"/some/other/path/to/file.txt", (boolean)false)));
        Assert.assertFalse((boolean)path.endsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"txt", (boolean)false)));
    }

    @Test
    public void endsWithWindows() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"\\");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to\\file.txt", (boolean)false);
        GeneralPathImpl unixFormatPath = GeneralPathImpl.create((FileSystem)this.fs, (String)"/c:/path/to/file.txt", (boolean)false);
        Assert.assertTrue((boolean)path.endsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"file.txt", (boolean)false)));
        Assert.assertFalse((boolean)path.endsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"anotherfile.txt", (boolean)false)));
        Assert.assertTrue((boolean)path.endsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"to\\file.txt", (boolean)false)));
        Assert.assertTrue((boolean)path.endsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"to/file.txt", (boolean)false)));
        Assert.assertFalse((boolean)path.endsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\different\\path\\to\\file.txt", (boolean)false)));
        Assert.assertFalse((boolean)path.endsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"d:\\path\\to\\another\\file.txt", (boolean)false)));
        Assert.assertTrue((boolean)unixFormatPath.endsWith((Path)GeneralPathImpl.create((FileSystem)this.fs, (String)"to\\file.txt", (boolean)false)));
        Assert.assertTrue((boolean)path.endsWith((Path)unixFormatPath));
        Assert.assertTrue((boolean)unixFormatPath.endsWith((Path)path));
    }

    @Test
    public void testSimpleRelativeUnix() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to/file.txt", (boolean)false);
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        AssertionsForClassTypes.assertThat((boolean)path.isAbsolute()).isFalse();
        AssertionsForClassTypes.assertThat((String)path.toString()).isEqualTo("path/to/file.txt");
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)path.getFileSystem()).isNotNull()).isEqualTo((Object)this.fs);
        AssertionsForClassTypes.assertThat((Object)path.getFileName()).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.getFileName().toString()).isEqualTo("file.txt");
        AssertionsForClassTypes.assertThat((int)path.getNameCount()).isEqualTo(3);
        AssertionsForClassTypes.assertThat((Object)path.getName(0)).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.getName(0).toString()).isEqualTo("path");
        AssertionsForClassTypes.assertThat((Object)path.getName(1)).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.getName(1).toString()).isEqualTo("to");
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)path.getName(2)).isNotNull()).isEqualTo((Object)path.getFileName());
        AssertionsForClassTypes.assertThat((Object)path.subpath(0, 1)).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.subpath(0, 1).toString()).isEqualTo("path");
        AssertionsForClassTypes.assertThat((Object)path.subpath(1, 2)).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.subpath(1, 2).toString()).isEqualTo("to");
        AssertionsForClassTypes.assertThat((Object)path.subpath(0, 2)).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.subpath(0, 2).toString()).isEqualTo("path/to");
        AssertionsForClassTypes.assertThat((Object)path.subpath(1, 3)).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.subpath(1, 3).toString()).isEqualTo("to/file.txt");
        int i = 0;
        for (Path currentPath : path) {
            AssertionsForClassTypes.assertThat((Object)currentPath).isEqualTo((Object)path.getName(i));
            ++i;
        }
        AssertionsForClassTypes.assertThat((Object)path.getParent()).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.getParent().toString()).isEqualTo("path/to");
        AssertionsForClassTypes.assertThat((Object)path.getParent().getParent()).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.getParent().getParent().toString()).isEqualTo("path");
        AssertionsForClassTypes.assertThat((Object)path.getParent().getParent().getParent()).isNull();
        AssertionsForClassTypes.assertThat((Object)path.getRoot()).isNull();
        AssertionsForClassTypes.assertThat((Object)path.toAbsolutePath()).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.toAbsolutePath().toString()).isEqualTo(DEFAULT_PATH + "path/to/file.txt");
    }

    @Test
    public void testSimpleAbsoluteWindows() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"\\");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to\\file.txt", (boolean)false);
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        AssertionsForClassTypes.assertThat((boolean)path.isAbsolute()).isTrue();
        AssertionsForClassTypes.assertThat((Object)path.toAbsolutePath()).isEqualTo((Object)path);
        AssertionsForClassTypes.assertThat((String)path.toString()).isEqualTo("c:\\path\\to\\file.txt");
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)path.getFileSystem()).isNotNull()).isEqualTo((Object)this.fs);
        AssertionsForClassTypes.assertThat((Object)path.getFileName()).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.getFileName().toString()).isEqualTo("file.txt");
        AssertionsForClassTypes.assertThat((int)path.getNameCount()).isEqualTo(3);
        AssertionsForClassTypes.assertThat((Object)path.getName(0)).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.getName(0).toString()).isEqualTo("path");
        AssertionsForClassTypes.assertThat((Object)path.getName(1)).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.getName(1).toString()).isEqualTo("to");
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)path.getName(2)).isNotNull()).isEqualTo((Object)path.getFileName());
        AssertionsForClassTypes.assertThat((Object)path.subpath(0, 1)).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.subpath(0, 1).toString()).isEqualTo("path");
        AssertionsForClassTypes.assertThat((Object)path.subpath(1, 2)).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.subpath(1, 2).toString()).isEqualTo("to");
        AssertionsForClassTypes.assertThat((Object)path.subpath(0, 2)).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.subpath(0, 2).toString()).isEqualTo("path\\to");
        AssertionsForClassTypes.assertThat((Object)path.subpath(1, 3)).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.subpath(1, 3).toString()).isEqualTo("to\\file.txt");
        int i = 0;
        for (Path currentPath : path) {
            AssertionsForClassTypes.assertThat((Object)currentPath).isEqualTo((Object)path.getName(i));
            ++i;
        }
        AssertionsForClassTypes.assertThat((Object)path.getParent()).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.getParent().toString()).isEqualTo("c:\\path\\to");
        AssertionsForClassTypes.assertThat((Object)path.getParent().getParent()).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.getParent().getParent().toString()).isEqualTo("c:\\path");
        AssertionsForClassTypes.assertThat((Object)path.getParent().getParent().getParent()).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.getParent().getParent().getParent().toString()).isEqualTo("c:\\");
        AssertionsForClassTypes.assertThat((Object)path.getRoot().getParent()).isNull();
        AssertionsForClassTypes.assertThat((Object)path.getRoot()).isNotNull();
        ((AbstractStringAssert)AssertionsForClassTypes.assertThat((String)path.getRoot().toString()).isNotNull()).isEqualTo("c:\\");
    }

    @Test
    public void testSimpleRootWindows() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"\\");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\", (boolean)false);
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        AssertionsForClassTypes.assertThat((boolean)path.isAbsolute()).isTrue();
        AssertionsForClassTypes.assertThat((String)path.toString()).isEqualTo("c:\\");
        AssertionsForClassTypes.assertThat((Object)path.getFileName()).isNull();
        AssertionsForClassTypes.assertThat((int)path.getNameCount()).isEqualTo(0);
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)path.getRoot()).isNotNull()).isEqualTo((Object)path);
        try {
            path.getName(0);
            Assertions.failBecauseExceptionWasNotThrown(IllegalArgumentException.class);
        }
        catch (Exception e) {
            AssertionsForClassTypes.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class);
        }
    }

    @Test
    public void testSimpleRelativeWindows() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"\\");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"path\\to\\file.txt", (boolean)false);
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        AssertionsForClassTypes.assertThat((boolean)path.isAbsolute()).isFalse();
        AssertionsForClassTypes.assertThat((String)path.toString()).isEqualTo("path\\to\\file.txt");
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)path.getFileSystem()).isNotNull()).isEqualTo((Object)this.fs);
        AssertionsForClassTypes.assertThat((Object)path.getFileName()).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.getFileName().toString()).isEqualTo("file.txt");
        AssertionsForClassTypes.assertThat((int)path.getNameCount()).isEqualTo(3);
        AssertionsForClassTypes.assertThat((Object)path.getName(0)).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.getName(0).toString()).isEqualTo("path");
        AssertionsForClassTypes.assertThat((Object)path.getName(1)).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.getName(1).toString()).isEqualTo("to");
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)path.getName(2)).isNotNull()).isEqualTo((Object)path.getFileName());
        AssertionsForClassTypes.assertThat((Object)path.subpath(0, 1)).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.subpath(0, 1).toString()).isEqualTo("path");
        AssertionsForClassTypes.assertThat((Object)path.subpath(1, 2)).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.subpath(1, 2).toString()).isEqualTo("to");
        AssertionsForClassTypes.assertThat((Object)path.subpath(0, 2)).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.subpath(0, 2).toString()).isEqualTo("path\\to");
        AssertionsForClassTypes.assertThat((Object)path.subpath(1, 3)).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.subpath(1, 3).toString()).isEqualTo("to\\file.txt");
        int i = 0;
        for (Path currentPath : path) {
            AssertionsForClassTypes.assertThat((Object)currentPath).isEqualTo((Object)path.getName(i));
            ++i;
        }
        AssertionsForClassTypes.assertThat((Object)path.getParent()).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.getParent().toString()).isEqualTo("path\\to");
        AssertionsForClassTypes.assertThat((Object)path.getParent().getParent()).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.getParent().getParent().toString()).isEqualTo("path");
        AssertionsForClassTypes.assertThat((Object)path.getParent().getParent().getParent()).isNull();
        AssertionsForClassTypes.assertThat((Object)path.toAbsolutePath()).isNotNull();
        this.assertWindowsPath(path.toAbsolutePath().toString(), DEFAULT_PATH.replaceAll("/", "\\\\") + "path\\to\\file.txt");
        AssertionsForClassTypes.assertThat((Object)path.getRoot()).isNull();
    }

    @Test
    public void testToFile() throws Exception {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        File file = File.createTempFile("foo", "bar");
        GeneralPathImpl path = GeneralPathImpl.newFromFile((FileSystem)this.fs, (File)file);
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        AssertionsForClassTypes.assertThat((String)path.toString()).isEqualTo(file.getAbsolutePath());
        AssertionsForClassTypes.assertThat((File)path.toFile()).isEqualTo((Object)file);
    }

    @Test
    public void testAbsloluteSimpleToURIUnix() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)false);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        URI uri = path.toUri();
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        AssertionsForClassTypes.assertThat((URI)uri).isNotNull();
        AssertionsForClassTypes.assertThat((String)uri.toString()).isEqualTo("file:///path/to/file.txt");
    }

    @Test
    public void testAbsoluteToURIUnix() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        URI uri = path.toUri();
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        AssertionsForClassTypes.assertThat((URI)uri).isNotNull();
        AssertionsForClassTypes.assertThat((String)uri.toString()).isEqualTo("default:///path/to/file.txt");
        Path realPath = path.toRealPath(new LinkOption[0]);
        AssertionsForClassTypes.assertThat((Object)realPath).isNotNull();
        AssertionsForClassTypes.assertThat((Object)realPath.toRealPath(new LinkOption[0])).isEqualTo((Object)realPath);
        AssertionsForClassTypes.assertThat((URI)realPath.toUri()).isNotNull();
        AssertionsForClassTypes.assertThat((String)realPath.toUri().toString()).isEqualTo("file:///path/to/file.txt");
    }

    @Test
    public void testRelativeToURIUnix() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to/file.txt", (boolean)false);
        URI uri = path.toUri();
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        AssertionsForClassTypes.assertThat((URI)uri).isNotNull();
        AssertionsForClassTypes.assertThat((String)uri.toString()).isEqualTo("default://" + DEFAULT_PATH + "path/to/file.txt");
        AssertionsForClassTypes.assertThat((String)path.toRealPath(new LinkOption[0]).toUri().toString()).isEqualTo("file://" + DEFAULT_PATH + "path/to/file.txt");
    }

    @Test
    public void testAbsoluteToURIWindows() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"\\");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to\\file.txt", (boolean)false);
        URI uri = path.toUri();
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        AssertionsForClassTypes.assertThat((URI)uri).isNotNull();
        AssertionsForClassTypes.assertThat((String)uri.toString()).isEqualTo("default:///c:/path/to/file.txt");
        Path realPath = path.toRealPath(new LinkOption[0]);
        AssertionsForClassTypes.assertThat((Object)realPath).isNotNull();
        AssertionsForClassTypes.assertThat((Object)realPath.toRealPath(new LinkOption[0])).isEqualTo((Object)realPath);
        AssertionsForClassTypes.assertThat((URI)realPath.toUri()).isNotNull();
        AssertionsForClassTypes.assertThat((String)realPath.toUri().toString()).isEqualTo("file:///c:/path/to/file.txt");
    }

    @Test
    public void testRelativeToURIWindows() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"\\");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"path\\to\\file.txt", (boolean)false);
        URI uri = path.toUri();
        AssertionsForClassTypes.assertThat((URI)uri).isNotNull();
        this.assertWindowsUri(uri.toString(), "default:///", DEFAULT_PATH + "path/to/file.txt");
        AssertionsForClassTypes.assertThat((Object)path).isNotNull();
        this.assertWindowsUri(path.toRealPath(new LinkOption[0]).toUri().toString(), "file:///", DEFAULT_PATH + "path/to/file.txt");
    }

    @Test
    public void testResolve() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/", (boolean)false);
        Path resolvedPath = path.resolve("some/file.text");
        AssertionsForClassTypes.assertThat((Object)resolvedPath).isNotNull();
        AssertionsForClassTypes.assertThat((String)resolvedPath.toString()).isEqualTo("/path/to/some/file.text");
        Path resolvedPath2 = path.resolve("/some/file.text");
        AssertionsForClassTypes.assertThat((Object)resolvedPath2).isNotNull();
        AssertionsForClassTypes.assertThat((String)resolvedPath2.toString()).isEqualTo("/some/file.text");
        GeneralPathImpl path2 = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to", (boolean)false);
        Path resolvedPath3 = path2.resolve("/some/file.text");
        AssertionsForClassTypes.assertThat((Object)resolvedPath3).isNotNull();
        AssertionsForClassTypes.assertThat((String)resolvedPath3.toString()).isEqualTo("/some/file.text");
        Path resolvedPath4 = path2.resolve("some/file.text");
        AssertionsForClassTypes.assertThat((Object)resolvedPath4).isNotNull();
        AssertionsForClassTypes.assertThat((String)resolvedPath4.toString()).isEqualTo("/path/to/some/file.text");
        Path resolvedPath5 = path2.resolve("");
        AssertionsForClassTypes.assertThat((Object)resolvedPath5).isNotNull();
        AssertionsForClassTypes.assertThat((String)resolvedPath5.toString()).isEqualTo(path2.toString());
        AssertionsForClassTypes.assertThat((Object)resolvedPath5).isEqualTo((Object)path2);
    }

    @Test
    public void checkResolveNull() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathTest.lambda$checkResolveNull$0((Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'other' should be not null!");
    }

    @Test
    public void checkResolveNull2() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathTest.lambda$checkResolveNull2$1((Path)path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'other' should be not null!");
    }

    @Test
    public void testNormalize() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/", (boolean)false);
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)path.normalize()).isNotNull()).isEqualTo((Object)path);
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)path.normalize().normalize()).isNotNull()).isEqualTo((Object)path.normalize());
        GeneralPathImpl path2 = GeneralPathImpl.create((FileSystem)this.fs, (String)"/some/path/../../to", (boolean)false);
        AssertionsForClassTypes.assertThat((Object)path2.normalize()).isNotNull();
        AssertionsForClassTypes.assertThat((String)path2.normalize().toString()).isEqualTo("/to");
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)path2.normalize().normalize()).isNotNull()).isEqualTo((Object)path2.normalize());
    }

    @Test
    public void testNormalizeWindows() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"\\");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to\\", (boolean)false);
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)path.normalize()).isNotNull()).isEqualTo((Object)path);
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)path.normalize().normalize()).isNotNull()).isEqualTo((Object)path.normalize());
        GeneralPathImpl path2 = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\some\\path\\..\\..\\to", (boolean)false);
        AssertionsForClassTypes.assertThat((Object)path2.normalize()).isNotNull();
        AssertionsForClassTypes.assertThat((String)path2.normalize().toString()).isEqualTo("c:\\to");
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)path2.normalize().normalize()).isNotNull()).isEqualTo((Object)path2.normalize());
    }

    @Test
    public void testResolveSibling() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/", (boolean)false);
        Path resolvedPath = path.resolveSibling("some/file.text");
        AssertionsForClassTypes.assertThat((Object)resolvedPath).isNotNull();
        AssertionsForClassTypes.assertThat((String)resolvedPath.toString()).isEqualTo("/path/some/file.text");
        Path resolvedPath2 = path.resolveSibling("/some/file.text");
        AssertionsForClassTypes.assertThat((Object)resolvedPath2).isNotNull();
        AssertionsForClassTypes.assertThat((String)resolvedPath2.toString()).isEqualTo("/some/file.text");
        GeneralPathImpl path2 = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to", (boolean)false);
        Path resolvedPath3 = path2.resolveSibling("/some/file.text");
        AssertionsForClassTypes.assertThat((Object)resolvedPath3).isNotNull();
        AssertionsForClassTypes.assertThat((String)resolvedPath3.toString()).isEqualTo("/some/file.text");
        Path resolvedPath4 = path2.resolveSibling("some/file.text");
        AssertionsForClassTypes.assertThat((Object)resolvedPath4).isNotNull();
        AssertionsForClassTypes.assertThat((String)resolvedPath4.toString()).isEqualTo("/path/some/file.text");
        Path resolvedPath5 = path2.resolveSibling("");
        AssertionsForClassTypes.assertThat((Object)resolvedPath5).isNotNull();
        AssertionsForClassTypes.assertThat((String)resolvedPath5.toString()).isEqualTo(path2.getParent().toString());
        AssertionsForClassTypes.assertThat((Object)resolvedPath5).isEqualTo((Object)path2.getParent());
    }

    @Test
    public void testRelativize() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to", (boolean)false);
        GeneralPathImpl other = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/some/place", (boolean)false);
        Path relative = path.relativize((Path)other);
        AssertionsForClassTypes.assertThat((Object)relative).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative.toString()).isEqualTo("some/place");
        GeneralPathImpl path2 = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/some/place", (boolean)false);
        GeneralPathImpl other2 = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to", (boolean)false);
        Path relative2 = path2.relativize((Path)other2);
        AssertionsForClassTypes.assertThat((Object)relative2).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative2.toString()).isEqualTo("../..");
        GeneralPathImpl path3 = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to", (boolean)false);
        GeneralPathImpl other3 = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to", (boolean)false);
        Path relative3 = path3.relativize((Path)other3);
        AssertionsForClassTypes.assertThat((Object)relative3).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative3.toString()).isEqualTo("");
        GeneralPathImpl path4 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to", (boolean)false);
        GeneralPathImpl other4 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to/some/place", (boolean)false);
        Path relative4 = path4.relativize((Path)other4);
        AssertionsForClassTypes.assertThat((Object)relative4).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative4.toString()).isEqualTo("some/place");
        GeneralPathImpl path5 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to", (boolean)false);
        GeneralPathImpl other5 = GeneralPathImpl.create((FileSystem)this.fs, (String)"some/place", (boolean)false);
        Path relative5 = path5.relativize((Path)other5);
        AssertionsForClassTypes.assertThat((Object)relative5).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative5.toString()).isEqualTo("../../some/place");
        GeneralPathImpl path6 = GeneralPathImpl.create((FileSystem)this.fs, (String)"some/place", (boolean)false);
        GeneralPathImpl other6 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to", (boolean)false);
        Path relative6 = path6.relativize((Path)other6);
        AssertionsForClassTypes.assertThat((Object)relative6).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative6.toString()).isEqualTo("../../path/to");
        GeneralPathImpl path7 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to/some/thing/here", (boolean)false);
        GeneralPathImpl other7 = GeneralPathImpl.create((FileSystem)this.fs, (String)"some/place", (boolean)false);
        Path relative7 = path7.relativize((Path)other7);
        AssertionsForClassTypes.assertThat((Object)relative7).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative7.toString()).isEqualTo("../../../../../some/place");
        GeneralPathImpl path8 = GeneralPathImpl.create((FileSystem)this.fs, (String)"some/place", (boolean)false);
        GeneralPathImpl other8 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to/some/thing/here", (boolean)false);
        Path relative8 = path8.relativize((Path)other8);
        AssertionsForClassTypes.assertThat((Object)relative8).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative8.toString()).isEqualTo("../../path/to/some/thing/here");
        GeneralPathImpl path9 = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to", (boolean)false);
        GeneralPathImpl other9 = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to", (boolean)false);
        Path relative9 = path9.relativize((Path)other9);
        AssertionsForClassTypes.assertThat((Object)relative9).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative9.toString()).isEqualTo("");
        GeneralPathImpl path10 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to", (boolean)false);
        GeneralPathImpl other10 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to", (boolean)false);
        Path relative10 = path10.relativize((Path)other10);
        AssertionsForClassTypes.assertThat((Object)relative10).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative10.toString()).isEqualTo("");
        GeneralPathImpl path11 = GeneralPathImpl.create((FileSystem)this.fs, (String)"", (boolean)false);
        GeneralPathImpl other11 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to", (boolean)false);
        Path relative11 = path11.relativize((Path)other11);
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)relative11).isNotNull()).isEqualTo((Object)other11);
    }

    @Test
    public void testRelativizeIlegal1() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to", (boolean)false);
        GeneralPathImpl other = GeneralPathImpl.create((FileSystem)this.fs, (String)"some/place", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathTest.lambda$testRelativizeIlegal1$2((Path)path, (Path)other)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Could not relativize path 'otherx', 'isAbsolute()' for 'this' and 'otherx' should be equal.");
    }

    @Test
    public void testRelativizeIlegal2() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"some/place", (boolean)false);
        GeneralPathImpl other = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathTest.lambda$testRelativizeIlegal2$3((Path)path, (Path)other)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Could not relativize path 'otherx', 'isAbsolute()' for 'this' and 'otherx' should be equal.");
    }

    @Test
    public void testRelativizeIlegal3() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"", (boolean)false);
        GeneralPathImpl other = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathTest.lambda$testRelativizeIlegal3$4((Path)path, (Path)other)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Could not relativize path 'otherx', 'isAbsolute()' for 'this' and 'otherx' should be equal.");
    }

    @Test
    public void testRelativizeWindows() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"\\");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to", (boolean)false);
        GeneralPathImpl other = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to\\some\\place", (boolean)false);
        Path relative = path.relativize((Path)other);
        AssertionsForClassTypes.assertThat((Object)relative).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative.toString()).isEqualTo("some\\place");
        GeneralPathImpl path2 = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to\\some\\place", (boolean)false);
        GeneralPathImpl other2 = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to", (boolean)false);
        Path relative2 = path2.relativize((Path)other2);
        AssertionsForClassTypes.assertThat((Object)relative2).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative2.toString()).isEqualTo("..\\..");
        GeneralPathImpl path3 = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path/to", (boolean)false);
        GeneralPathImpl other3 = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path/to", (boolean)false);
        Path relative3 = path3.relativize((Path)other3);
        AssertionsForClassTypes.assertThat((Object)relative3).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative3.toString()).isEqualTo("");
        GeneralPathImpl path4 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path\\to", (boolean)false);
        GeneralPathImpl other4 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path\\to\\some\\place", (boolean)false);
        Path relative4 = path4.relativize((Path)other4);
        AssertionsForClassTypes.assertThat((Object)relative4).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative4.toString()).isEqualTo("some\\place");
        GeneralPathImpl path5 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path\\to", (boolean)false);
        GeneralPathImpl other5 = GeneralPathImpl.create((FileSystem)this.fs, (String)"some\\place", (boolean)false);
        Path relative5 = path5.relativize((Path)other5);
        AssertionsForClassTypes.assertThat((Object)relative5).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative5.toString()).isEqualTo("..\\..\\some\\place");
        GeneralPathImpl path6 = GeneralPathImpl.create((FileSystem)this.fs, (String)"some\\place", (boolean)false);
        GeneralPathImpl other6 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path\\to", (boolean)false);
        Path relative6 = path6.relativize((Path)other6);
        AssertionsForClassTypes.assertThat((Object)relative6).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative6.toString()).isEqualTo("..\\..\\path\\to");
        GeneralPathImpl path7 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path\\to\\some\\thing\\here", (boolean)false);
        GeneralPathImpl other7 = GeneralPathImpl.create((FileSystem)this.fs, (String)"some\\place", (boolean)false);
        Path relative7 = path7.relativize((Path)other7);
        AssertionsForClassTypes.assertThat((Object)relative7).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative7.toString()).isEqualTo("..\\..\\..\\..\\..\\some\\place");
        GeneralPathImpl path8 = GeneralPathImpl.create((FileSystem)this.fs, (String)"some\\place", (boolean)false);
        GeneralPathImpl other8 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path\\to\\some\\thing\\here", (boolean)false);
        Path relative8 = path8.relativize((Path)other8);
        AssertionsForClassTypes.assertThat((Object)relative8).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative8.toString()).isEqualTo("..\\..\\path\\to\\some\\thing\\here");
        GeneralPathImpl path9 = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to", (boolean)false);
        GeneralPathImpl other9 = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to", (boolean)false);
        Path relative9 = path9.relativize((Path)other9);
        AssertionsForClassTypes.assertThat((Object)relative9).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative9.toString()).isEqualTo("");
        GeneralPathImpl path10 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path\\to", (boolean)false);
        GeneralPathImpl other10 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path\\to", (boolean)false);
        Path relative10 = path10.relativize((Path)other10);
        AssertionsForClassTypes.assertThat((Object)relative10).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative10.toString()).isEqualTo("");
        GeneralPathImpl path11 = GeneralPathImpl.create((FileSystem)this.fs, (String)"", (boolean)false);
        GeneralPathImpl other11 = GeneralPathImpl.create((FileSystem)this.fs, (String)"path\\to", (boolean)false);
        Path relative11 = path11.relativize((Path)other11);
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)relative11).isNotNull()).isEqualTo((Object)other11);
        GeneralPathImpl path12 = GeneralPathImpl.create((FileSystem)this.fs, (String)"/c:/path/to", (boolean)false);
        GeneralPathImpl other12 = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to\\some\\place", (boolean)false);
        Path relative12 = path12.relativize((Path)other12);
        AssertionsForClassTypes.assertThat((Object)relative12).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative12.toString()).isEqualTo("some\\place");
        GeneralPathImpl path13 = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to\\some\\place", (boolean)false);
        GeneralPathImpl other13 = GeneralPathImpl.create((FileSystem)this.fs, (String)"/c:/path/to", (boolean)false);
        Path relative13 = path13.relativize((Path)other13);
        AssertionsForClassTypes.assertThat((Object)relative13).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative13.toString()).isEqualTo("..\\..");
        GeneralPathImpl path14 = GeneralPathImpl.create((FileSystem)this.fs, (String)"/c:/path/to/some/place", (boolean)false);
        GeneralPathImpl other14 = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to", (boolean)false);
        Path relative14 = path14.relativize((Path)other14);
        AssertionsForClassTypes.assertThat((Object)relative14).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative14.toString()).isEqualTo("../..");
        GeneralPathImpl path15 = GeneralPathImpl.create((FileSystem)this.fs, (String)"/c:/path/to/some/place", (boolean)false);
        GeneralPathImpl other15 = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to\\some\\other\\place", (boolean)false);
        Path relative15 = path15.relativize((Path)other15);
        AssertionsForClassTypes.assertThat((Object)relative15).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative15.toString()).isEqualTo("../other/place");
        GeneralPathImpl path16 = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to\\some\\place", (boolean)false);
        GeneralPathImpl other16 = GeneralPathImpl.create((FileSystem)this.fs, (String)"/c:/path/to/some/other/place", (boolean)false);
        Path relative16 = path16.relativize((Path)other16);
        AssertionsForClassTypes.assertThat((Object)relative16).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative16.toString()).isEqualTo("..\\other\\place");
        GeneralPathImpl path17 = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to\\some\\place", (boolean)false);
        GeneralPathImpl other17 = GeneralPathImpl.create((FileSystem)this.fs, (String)"/c:/path/to/some/place", (boolean)false);
        Path relative17 = path17.relativize((Path)other17);
        AssertionsForClassTypes.assertThat((Object)relative17).isNotNull();
        AssertionsForClassTypes.assertThat((String)relative17.toString()).isEmpty();
        AssertionsForClassTypes.assertThat((boolean)other17.relativize((Path)path17).toString().isEmpty());
    }

    @Test
    public void testRelativizeWindowsIllegal1() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"\\");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to", (boolean)false);
        GeneralPathImpl other = GeneralPathImpl.create((FileSystem)this.fs, (String)"some\\place", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathTest.lambda$testRelativizeWindowsIllegal1$5((Path)path, (Path)other)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Could not relativize path 'otherx', 'isAbsolute()' for 'this' and 'otherx' should be equal.");
    }

    @Test
    public void testRelativizeWindowsIllegal2() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"\\");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"some\\place", (boolean)false);
        GeneralPathImpl other = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathTest.lambda$testRelativizeWindowsIllegal2$6((Path)path, (Path)other)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Could not relativize path 'otherx', 'isAbsolute()' for 'this' and 'otherx' should be equal.");
    }

    @Test
    public void testRelativizeWindowsIllegal3() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"\\");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"", (boolean)false);
        GeneralPathImpl other = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathTest.lambda$testRelativizeWindowsIllegal3$7((Path)path, (Path)other)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Could not relativize path 'otherx', 'isAbsolute()' for 'this' and 'otherx' should be equal.");
    }

    @Test
    public void testRelativizeWindowsIllegal4() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"\\");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"d:\\path\\to", (boolean)false);
        GeneralPathImpl other = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathTest.lambda$testRelativizeWindowsIllegal4$8((Path)path, (Path)other)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Could not relativize path 'otherx', 'getRoot()' for 'this' and 'otherx' should be equal.");
    }

    @Test
    public void testRelativizeWindowsIllegal5() {
        FileSystemProvider fsprovider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fsprovider.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)fsprovider.getScheme()).thenReturn((Object)"file");
        Mockito.when((Object)this.fs.provider()).thenReturn((Object)fsprovider);
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"\\");
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/d:/path/to", (boolean)false);
        GeneralPathImpl other = GeneralPathImpl.create((FileSystem)this.fs, (String)"c:\\path\\to", (boolean)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GeneralPathTest.lambda$testRelativizeWindowsIllegal5$9((Path)path, (Path)other)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Could not relativize path 'otherx', 'getRoot()' for 'this' and 'otherx' should be equal.");
    }

    private void assertWindowsUri(String actualUri, String expectedUriScheme, String expectedUriPath) {
        String expectedPathPrefix = this.determineWindowsPathPrefix();
        AssertionsForClassTypes.assertThat((String)actualUri).isEqualTo(expectedUriScheme + expectedPathPrefix + expectedUriPath);
    }

    private void assertWindowsPath(String actualPath, String expectedPath) {
        String expectedPathPrefix = this.determineWindowsPathPrefix();
        AssertionsForClassTypes.assertThat((String)actualPath).isEqualTo(expectedPathPrefix + expectedPath);
    }

    private String determineWindowsPathPrefix() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return "";
        }
        return "C:";
    }

    private static /* synthetic */ void lambda$testRelativizeWindowsIllegal5$9(Path path, Path other) throws Throwable {
        path.relativize(other);
    }

    private static /* synthetic */ void lambda$testRelativizeWindowsIllegal4$8(Path path, Path other) throws Throwable {
        path.relativize(other);
    }

    private static /* synthetic */ void lambda$testRelativizeWindowsIllegal3$7(Path path, Path other) throws Throwable {
        path.relativize(other);
    }

    private static /* synthetic */ void lambda$testRelativizeWindowsIllegal2$6(Path path, Path other) throws Throwable {
        path.relativize(other);
    }

    private static /* synthetic */ void lambda$testRelativizeWindowsIllegal1$5(Path path, Path other) throws Throwable {
        path.relativize(other);
    }

    private static /* synthetic */ void lambda$testRelativizeIlegal3$4(Path path, Path other) throws Throwable {
        path.relativize(other);
    }

    private static /* synthetic */ void lambda$testRelativizeIlegal2$3(Path path, Path other) throws Throwable {
        path.relativize(other);
    }

    private static /* synthetic */ void lambda$testRelativizeIlegal1$2(Path path, Path other) throws Throwable {
        path.relativize(other);
    }

    private static /* synthetic */ void lambda$checkResolveNull2$1(Path path) throws Throwable {
        path.resolve((Path)null);
    }

    private static /* synthetic */ void lambda$checkResolveNull$0(Path path) throws Throwable {
        path.resolve((String)null);
    }
}

