/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.base;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.java.nio.base.Properties;

public class PropertiesTest {
    @Test
    public void testState() throws IOException {
        File fcontent = File.createTempFile("foo", "bar");
        Properties properties = new Properties();
        Date dt = new Date();
        properties.put("int", (Object)10453);
        properties.put("long", (Object)1000000L);
        properties.put("date", (Object)dt);
        FileOutputStream out = new FileOutputStream(fcontent);
        properties.store((OutputStream)out);
        Properties loadProperties = new Properties();
        FileInputStream in = new FileInputStream(fcontent);
        loadProperties.load((InputStream)in);
        Assert.assertNotNull((Object)properties.get((Object)"int"));
        Assert.assertNotNull((Object)properties.get((Object)"long"));
        Assert.assertNotNull((Object)properties.get((Object)"date"));
        Assert.assertEquals((Object)10453, (Object)properties.get((Object)"int"));
        Assert.assertEquals((Object)1000000L, (Object)properties.get((Object)"long"));
        Assert.assertEquals((Object)dt, (Object)properties.get((Object)"date"));
    }

    @Test
    public void testEmptyState() throws IOException {
        File fcontent = File.createTempFile("foo2", "bar");
        Properties loadProperties = new Properties();
        FileInputStream in = new FileInputStream(fcontent);
        loadProperties.load((InputStream)in);
        Assert.assertEquals((long)0L, (long)loadProperties.size());
    }

    @Test
    public void testNullValues() throws IOException {
        HashMap<String, String> original = new HashMap<String, String>();
        original.put("key1", "value1");
        original.put("key2", null);
        Properties properties = new Properties(original);
        Assert.assertEquals((long)1L, (long)properties.size());
        Assert.assertTrue((boolean)properties.containsKey((Object)"key1"));
        Assert.assertEquals((Object)"value1", (Object)properties.get((Object)"key1"));
        Assert.assertFalse((boolean)properties.containsKey((Object)"key2"));
    }
}

