/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.base;

import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.java.nio.base.GeneralPathImpl;
import org.uberfire.java.nio.file.FileSystem;

public class GeneralPathEqualsTest {
    final FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
    final FileSystem nfs = (FileSystem)Mockito.mock(FileSystem.class);

    @Before
    public void setup() {
        Mockito.when((Object)this.fs.getSeparator()).thenReturn((Object)"/");
        Mockito.when((Object)this.nfs.getSeparator()).thenReturn((Object)"/");
    }

    @Test
    public void testEquals() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        AssertionsForClassTypes.assertThat((Object)path).isEqualTo((Object)path);
        AssertionsForClassTypes.assertThat((boolean)path.equals(new Object())).isFalse();
        AssertionsForClassTypes.assertThat((Object)path).isNotEqualTo((Object)GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)true));
        AssertionsForClassTypes.assertThat((Object)path).isNotEqualTo((Object)GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to/file.txt", (boolean)false));
        AssertionsForClassTypes.assertThat((Object)path).isNotEqualTo((Object)GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txts", (boolean)false));
        AssertionsForClassTypes.assertThat((Object)path).isNotEqualTo((Object)GeneralPathImpl.create((FileSystem)this.nfs, (String)"/path/to/file.txts", (boolean)false));
        AssertionsForClassTypes.assertThat((Object)path.getRoot()).isNotEqualTo((Object)path);
    }

    @Test
    public void testEqualsWindows() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to/file.txt", (boolean)false);
        GeneralPathImpl wpath = GeneralPathImpl.create((FileSystem)this.fs, (String)"path\\to\\file.txt", (boolean)false);
        AssertionsForClassTypes.assertThat((Object)path).isNotEqualTo((Object)wpath);
    }

    @Test
    public void testHashCode() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)false);
        AssertionsForClassTypes.assertThat((int)path.hashCode()).isEqualTo(path.hashCode());
        AssertionsForClassTypes.assertThat((int)path.hashCode()).isNotEqualTo(new Object().hashCode());
        AssertionsForClassTypes.assertThat((int)path.hashCode()).isNotEqualTo(GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txt", (boolean)true).hashCode());
        AssertionsForClassTypes.assertThat((int)path.hashCode()).isNotEqualTo(GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to/file.txt", (boolean)false).hashCode());
        AssertionsForClassTypes.assertThat((int)path.hashCode()).isNotEqualTo(GeneralPathImpl.create((FileSystem)this.fs, (String)"/path/to/file.txts", (boolean)false).hashCode());
        AssertionsForClassTypes.assertThat((int)path.hashCode()).isNotEqualTo(GeneralPathImpl.create((FileSystem)this.nfs, (String)"/path/to/file.txts", (boolean)false).hashCode());
        AssertionsForClassTypes.assertThat((int)path.getRoot().hashCode()).isNotEqualTo(path.hashCode());
    }

    @Test
    public void testHashCodeWindows() {
        GeneralPathImpl path = GeneralPathImpl.create((FileSystem)this.fs, (String)"path/to/file.txt", (boolean)false);
        GeneralPathImpl wpath = GeneralPathImpl.create((FileSystem)this.fs, (String)"path\\to\\file.txt", (boolean)false);
        AssertionsForClassTypes.assertThat((int)path.hashCode()).isNotEqualTo(wpath.hashCode());
    }
}

