# Summary

* [Introduction](README.md)
* [Overview](overview/overview.md)
   * [What is Uberfire](overview/whatIsUberfire.md)
   * [How it all fits together](overview/howitallfitstogether.md)
* [Getting Started](gettingStarted/gettingStarted.md)
   * [5 mins introduction](gettingStarted/5minIntroduction.md)
   * [Improving your first App](gettingStarted/improvingYourFirstApp.md)
   * [Running Uberfire Showcase](gettingStarted/runningUberfireShowcase.md)
* [Tutorial](tutorial/tutorial.md)
   * [Creating UF Tasks project](tutorial/createUfTasks.md)
   * [Layout of Uberfire Archetype](tutorial/layoutArchetype.md)
   * [Setup Dev Enviroment](tutorial/setupDevEnv.md)
       * [Intellij IDEA](tutorial/intellij_idea.md)
       * [Eclipse](tutorial/eclipse.md)
   * [UF tasks](tutorial/ufTasks.md)
   * [Deploy Tomcat](tutorial/deployTomcat.md)
   * [Deploy Wildfly](tutorial/deployWildfly.md)
* [Uberfire Model](overview/uberfireModel.md)
  * [Workbench](overview/workbench.md)
    * [Header](overview/header.md)
    * [Footer](overview/footer.md)
    * [Menu](overview/menu.md)
    * [Perspective](overview/perspective.md)
    * [Panel](overview/panel.md)
    * [Part](overview/part.md)
    * [Component](overview/component.md)
      * [Screen](overview/screen.md)
      * [Editor](overview/editor.md)
      * [PopUp](overview/popup.md)
      * [SplashScreen](overview/splashScreen.md)
    * [Docks](overview/docks.md)
  * [VFS](overview/vfs.md)
  * [Plugins](overview/plugins.md)
  * [Uberfire Extensions](overview/uberfireExtensions.md)
* [Architecture](architecture/architecture.md)
   * [UberFire Architecture Overview](architecture/overview.md)
   * [App Architecture](architecture/appArchitecture.md)
       * [Backend+Client](architecture/backEndClient.md)
           * [Clustering](architecture/clustering.md)
       * [Client side only](architecture/clientSideOnly.md)
* [Components](components/components.md)
   * [Workbench](components/workbench.md)
       * [Components](components/wbComponents.md)
           * [Perspective](components/perspective.md)
               * [Type](components/type.md)
               * [Components](components/perspectivelifecyclemd.md)
           * [Panel](components/panel.md)
               * [Components](components/panellifecycle.md)
           * [Part](components/part.md)
               * [Components](components/partLifecycle.md)
   * [Security](security/security.md)
        * [Workbench Assets](security/workbenchAssets.md)
        * [Home Perspectives](security/homePerspectives.md)
        * [Authorization Management API](security/authorizationAPI.md)
             * [Resource Actions](security/resourceActions.md)
             * [Permission Checks](security/permissionChecks.md)
             * [Fluent API](security/fluentAPI.md)
             * [Annotations](security/annotations.md)
             * [Permission Resolution](security/permissionResolution.md)
        * [Authorization Policy Storage](security/authzPolicyStorage.md)
        * [Extensibility](security/extensionPoints.md)
   * [VFS](components/vfs.md)
       * [VFS](components/preferences.md)
   * [Javascript API](components/jsAPI.md)
       * [Angular Integration](components/angular.md)
   * [App Styling](components/appStyling.md)
       * [Bootstrap](components/bootstrap.md)
       * [PatternFly](components/patternFly.md)
* [UberFire Extensions](uberfireExtensions/uberfireExtensions.md)
   * [Wires](uberfireExtensions/wires.md)
   * [Widgets](uberfireExtensions/widgets.md)
       * [Ace Editor](uberfireExtensions/aceEditor.md)
       * [Markdown](uberfireExtensions/markdown.md)
   * [Property Editor](uberfireExtensions/propertyEditor.md)
   * [Security](uberfireExtensions/security.md)
   * [Metadata](uberfireExtensions/metadata.md)
       * [Automatic VFS Index/Search](uberfireExtensions/automaticVFSIndexSearch.md)
   * [Self Service App](uberfireExtensions/selfServiceApp.md)
   * [RAD Extensions (tech module: Runtime Plugins)](uberfireExtensions/radExtensions.md)
   * [App Directory](uberfireExtensions/appDirectory.md)
   * [Third Party Extensions](uberfireExtensions/thirdPartExtensions.md)
   * [Social Activities](uberfireExtensions/socialActivities.md)
   * [Guvnor](uberfireExtensions/guvnor.md)
   * [Dashbuilder](uberfireExtensions/dashbuilder.md)
   * [Simple Docks](uberfireExtensions/docks.md)
   * [Breadcrumbs](uberfireExtensions/breadcrumbs.md)
   * [Admin Page](uberfireExtensions/adminPage.md)
   * [Preferences](uberfireExtensions/preferences.md)
       * [Beans API](uberfireExtensions/preferencesBeansAPI.md)
       * [Edition Screen](uberfireExtensions/preferencesEditionScreen.md)
       * [Low-level Storage API](uberfireExtensions/preferencesLowLevelStorageAPI.md)
* [Integration](integration/integration.md)
   * [From Angular](integration/fromAngular.md)
   * [To Angular](integration/toAngular.md)
* [Deploying](deploying/deploying.md)
   * [Tomcat](deploying/tomcat.md)
   * [WildFly](deploying/wildfly.md)
   * [WAS8](deploying/was8.md)
   * [Web Logic ?](deploying/weblogic.md)
   * [JBoss EAP 6.3](deploying/jbosseap.md)
       * [Clustering](deploying/clustering.md)
* [Who Uses Uberfire](whoUses/whoUses.md)
   * [jBPM](whoUses/jbpm.md)
   * [Drools Workbench](whoUses/drools.md)
   * [DashBuilder](whoUses/dashbuilder.md)
* [FAQ](faq/faq.md)
   * [General Questions](faq/faqGeneral.md)
* [How to Contribute](contribute/howTo.md)
   * [Build from Source](contribute/buildFromSource.md)

