/*
 * Copyright 2017 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.uberfire.ext.metadata.model.impl;

import org.uberfire.ext.metadata.model.KProperty;

public class KPropertyImpl<T> implements KProperty<T> {

    private String name;
    private T value;
    private boolean searchable;

    public KPropertyImpl(String name,
                         T value,
                         boolean searchable) {
        this.name = name;
        this.value = value;
        this.searchable = searchable;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public boolean isSearchable() {
        return this.searchable;
    }
}
