/*
 * Copyright 2015 JBoss, by Red Hat, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.uberfire.ext.metadata.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.enterprise.inject.Alternative;

import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.ext.metadata.engine.Indexer;

/**
 * Container for Indexers setup by CDI after IOServiceIndexedImpl has been created
 */
@Alternative
public class IndexersFactory {

    private final List<Indexer> indexers = new ArrayList<>();

    public void addIndexer(final Indexer indexer) {
        indexers.add(PortablePreconditions.checkNotNull("indexer",
                                                        indexer));
    }

    public List<Indexer> getIndexers() {
        return Collections.unmodifiableList(indexers);
    }

    public void clear() {
        indexers.clear();
    }
}
