/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.shared.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.ext.preferences.shared.UsernameProvider;
import org.uberfire.ext.preferences.shared.impl.DefaultPreferenceScopeTypes;
import org.uberfire.ext.preferences.shared.impl.DefaultScopes;
import org.uberfire.ext.preferences.shared.impl.UsernameProviderMock;
import org.uberfire.ext.preferences.shared.impl.exception.InvalidPreferenceScopeException;
import org.uberfire.mocks.SessionInfoMock;
import org.uberfire.rpc.SessionInfo;

public class DefaultPreferenceScopeTypesTest {
    private DefaultPreferenceScopeTypes defaultPreferenceScopeTypes;

    @Before
    public void setup() {
        SessionInfoMock sessionInfo = new SessionInfoMock();
        this.defaultPreferenceScopeTypes = new DefaultPreferenceScopeTypes((UsernameProvider)new UsernameProviderMock((SessionInfo)sessionInfo));
    }

    @Test
    public void typesRequireKeyTest() {
        Assert.assertFalse((boolean)this.defaultPreferenceScopeTypes.typeRequiresKey(DefaultScopes.ALL_USERS.type()));
        Assert.assertFalse((boolean)this.defaultPreferenceScopeTypes.typeRequiresKey(DefaultScopes.ENTIRE_APPLICATION.type()));
        Assert.assertTrue((boolean)this.defaultPreferenceScopeTypes.typeRequiresKey(DefaultScopes.COMPONENT.type()));
        Assert.assertFalse((boolean)this.defaultPreferenceScopeTypes.typeRequiresKey(DefaultScopes.USER.type()));
    }

    @Test
    public void defaultKeysForTypesTest() {
        Assert.assertEquals((Object)DefaultScopes.ALL_USERS.type(), (Object)this.defaultPreferenceScopeTypes.getDefaultKeyFor(DefaultScopes.ALL_USERS.type()));
        Assert.assertEquals((Object)DefaultScopes.ENTIRE_APPLICATION.type(), (Object)this.defaultPreferenceScopeTypes.getDefaultKeyFor(DefaultScopes.ENTIRE_APPLICATION.type()));
        Assert.assertEquals((Object)"admin", (Object)this.defaultPreferenceScopeTypes.getDefaultKeyFor(DefaultScopes.USER.type()));
    }

    @Test(expected=InvalidPreferenceScopeException.class)
    public void defaultKeysForTypesThatDoNotHaveDefaultKeysTest() {
        this.defaultPreferenceScopeTypes.getDefaultKeyFor(DefaultScopes.COMPONENT.type());
    }

    @Test
    public void isEmptyTest() {
        Assert.assertTrue((boolean)this.defaultPreferenceScopeTypes.isEmpty(null));
        Assert.assertTrue((boolean)this.defaultPreferenceScopeTypes.isEmpty(""));
        Assert.assertTrue((boolean)this.defaultPreferenceScopeTypes.isEmpty("  "));
        Assert.assertFalse((boolean)this.defaultPreferenceScopeTypes.isEmpty("anyString"));
    }
}

