/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.preferences.shared.impl;

import java.util.ArrayList;
import java.util.List;
import org.uberfire.annotations.FallbackImplementation;
import org.uberfire.preferences.shared.PreferenceScope;
import org.uberfire.preferences.shared.PreferenceScopeFactory;
import org.uberfire.preferences.shared.PreferenceScopeResolutionStrategy;
import org.uberfire.preferences.shared.PreferenceScopeResolver;
import org.uberfire.preferences.shared.impl.DefaultPreferenceScopeResolver;
import org.uberfire.preferences.shared.impl.DefaultScopes;
import org.uberfire.preferences.shared.impl.PreferenceScopeResolutionStrategyInfo;

@FallbackImplementation
public class DefaultPreferenceScopeResolutionStrategy
implements PreferenceScopeResolutionStrategy {
    private PreferenceScopeResolutionStrategyInfo info;
    private PreferenceScopeResolver resolver;

    protected DefaultPreferenceScopeResolutionStrategy() {
    }

    public DefaultPreferenceScopeResolutionStrategy(PreferenceScopeFactory scopeFactory, String componentKey) {
        List<PreferenceScope> order = this.getScopeOrder(scopeFactory, componentKey);
        PreferenceScope defaultScope = this.getDefaultScope(order);
        this.info = new PreferenceScopeResolutionStrategyInfo(order, defaultScope);
        this.resolver = new DefaultPreferenceScopeResolver(order);
    }

    @Override
    public PreferenceScopeResolutionStrategyInfo getInfo() {
        return this.info;
    }

    @Override
    public PreferenceScopeResolver getScopeResolver() {
        return this.resolver;
    }

    public PreferenceScope getDefaultScope(List<PreferenceScope> order) {
        return order.get(0);
    }

    private List<PreferenceScope> getScopeOrder(PreferenceScopeFactory scopeFactory, String componentKey) {
        ArrayList<PreferenceScope> order = new ArrayList<PreferenceScope>();
        this.addUserComponentScope(order, scopeFactory, componentKey);
        this.addUserEntireApplicationScope(order, scopeFactory);
        this.addAllUsersComponentScope(order, scopeFactory, componentKey);
        this.addAllUsersEntireApplicationScope(order, scopeFactory);
        return order;
    }

    private void addUserComponentScope(List<PreferenceScope> order, PreferenceScopeFactory scopeFactory, String componentKey) {
        if (componentKey != null) {
            PreferenceScope userScope = scopeFactory.createScope(DefaultScopes.USER.type());
            PreferenceScope componentScope = scopeFactory.createScope(DefaultScopes.COMPONENT.type(), componentKey);
            order.add(scopeFactory.createScope(userScope, componentScope));
        }
    }

    private void addUserEntireApplicationScope(List<PreferenceScope> order, PreferenceScopeFactory scopeFactory) {
        PreferenceScope userScope = scopeFactory.createScope(DefaultScopes.USER.type());
        PreferenceScope entireApplicationScope = scopeFactory.createScope(DefaultScopes.ENTIRE_APPLICATION.type());
        order.add(scopeFactory.createScope(userScope, entireApplicationScope));
    }

    private void addAllUsersComponentScope(List<PreferenceScope> order, PreferenceScopeFactory scopeFactory, String componentKey) {
        if (componentKey != null) {
            PreferenceScope allUsersScope = scopeFactory.createScope(DefaultScopes.ALL_USERS.type());
            PreferenceScope componentScope = scopeFactory.createScope(DefaultScopes.COMPONENT.type(), componentKey);
            order.add(scopeFactory.createScope(allUsersScope, componentScope));
        }
    }

    private void addAllUsersEntireApplicationScope(List<PreferenceScope> order, PreferenceScopeFactory scopeFactory) {
        PreferenceScope allUsersScope = scopeFactory.createScope(DefaultScopes.ALL_USERS.type());
        PreferenceScope entireApplicationScope = scopeFactory.createScope(DefaultScopes.ENTIRE_APPLICATION.type());
        order.add(scopeFactory.createScope(allUsersScope, entireApplicationScope));
    }
}

