/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.preferences.shared.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.mocks.SessionInfoMock;
import org.uberfire.preferences.shared.PreferenceScope;
import org.uberfire.preferences.shared.PreferenceScopeTypes;
import org.uberfire.preferences.shared.UsernameProvider;
import org.uberfire.preferences.shared.impl.DefaultPreferenceScopeTypes;
import org.uberfire.preferences.shared.impl.DefaultPreferenceScopesForTests;
import org.uberfire.preferences.shared.impl.DefaultScopes;
import org.uberfire.preferences.shared.impl.PreferenceScopeFactoryImpl;
import org.uberfire.preferences.shared.impl.UsernameProviderMock;
import org.uberfire.preferences.shared.impl.exception.InvalidPreferenceScopeException;
import org.uberfire.rpc.SessionInfo;

public class PreferenceScopeFactoryImplTest {
    private PreferenceScopeFactoryImpl scopeFactory;
    private PreferenceScope genericScope;

    @Before
    public void setup() {
        this.genericScope = (PreferenceScope)Mockito.mock(PreferenceScope.class);
        SessionInfoMock sessionInfo = new SessionInfoMock();
        DefaultPreferenceScopeTypes scopeTypes = new DefaultPreferenceScopeTypes((UsernameProvider)new UsernameProviderMock((SessionInfo)sessionInfo));
        this.scopeFactory = new PreferenceScopeFactoryImpl((PreferenceScopeTypes)scopeTypes);
    }

    @Test
    public void createScopeByTypeWithDefaultKeyTest() {
        PreferenceScope userScope = this.scopeFactory.createScope(DefaultScopes.USER.type());
        Assert.assertEquals((Object)DefaultScopes.USER.type(), (Object)userScope.type());
        Assert.assertEquals((Object)"admin", (Object)userScope.key());
    }

    @Test(expected=InvalidPreferenceScopeException.class)
    public void createScopeByTypeWithoutDefaultKeyTest() {
        this.scopeFactory.createScope(DefaultScopes.COMPONENT.type());
    }

    @Test
    public void createScopeByTypeAndKeyWithoutDefaultKeyTest() {
        PreferenceScope componentScope = this.scopeFactory.createScope(DefaultScopes.COMPONENT.type(), "my-component");
        Assert.assertEquals((Object)DefaultScopes.COMPONENT.type(), (Object)componentScope.type());
        Assert.assertEquals((Object)"my-component", (Object)componentScope.key());
    }

    @Test(expected=InvalidPreferenceScopeException.class)
    public void createScopeByTypeAndKeyWithDefaultKeyTest() {
        this.scopeFactory.createScope(DefaultScopes.USER.type(), "user");
    }

    @Test
    public void createScopeByTypeAndChildScopeWithDefaultKeyTest() {
        PreferenceScope userScope = this.scopeFactory.createScope(DefaultScopes.USER.type(), this.genericScope);
        Assert.assertEquals((Object)DefaultScopes.USER.type(), (Object)userScope.type());
        Assert.assertEquals((Object)"admin", (Object)userScope.key());
    }

    @Test(expected=InvalidPreferenceScopeException.class)
    public void createScopeByTypeAndChildScopeWithoutDefaultKeyTest() {
        this.scopeFactory.createScope(DefaultScopes.COMPONENT.type(), this.genericScope);
    }

    @Test
    public void createScopeByTypeKeyAndChildScopeWithoutDefaultKeyTest() {
        PreferenceScope componentScope = this.scopeFactory.createScope(DefaultScopes.COMPONENT.type(), "my-component", this.genericScope);
        Assert.assertEquals((Object)DefaultScopes.COMPONENT.type(), (Object)componentScope.type());
        Assert.assertEquals((Object)"my-component", (Object)componentScope.key());
    }

    @Test(expected=InvalidPreferenceScopeException.class)
    public void createScopeByTypeKeyAndChildScopeWithDefaultKeyTest() {
        this.scopeFactory.createScope(DefaultScopes.USER.type(), "user", this.genericScope);
    }

    @Test
    public void createHierarchicalScopeByScopesTest() {
        PreferenceScope scope = this.scopeFactory.createScope(new PreferenceScope[]{DefaultPreferenceScopesForTests.userScope, DefaultPreferenceScopesForTests.entireApplicationScope});
        Assert.assertEquals((Object)DefaultScopes.USER.type(), (Object)scope.type());
        Assert.assertEquals((Object)"my-user", (Object)scope.key());
        PreferenceScope childScope = scope.childScope();
        Assert.assertEquals((Object)DefaultScopes.ENTIRE_APPLICATION.type(), (Object)childScope.type());
        Assert.assertEquals((Object)DefaultScopes.ENTIRE_APPLICATION.type(), (Object)childScope.key());
        Assert.assertNull((Object)childScope.childScope());
    }

    @Test
    public void cloneScopeTest() {
        PreferenceScope newScope;
        PreferenceScope scope = this.scopeFactory.createScope(new PreferenceScope[]{DefaultPreferenceScopesForTests.userScope, DefaultPreferenceScopesForTests.entireApplicationScope});
        Assert.assertTrue((scope != (newScope = this.scopeFactory.cloneScope(scope)) ? 1 : 0) != 0);
        Assert.assertEquals((Object)scope, (Object)newScope);
    }
}

