/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.preferences.shared.impl.validation;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.preferences.shared.impl.validation.ConstrainedValuesValidator;
import org.uberfire.preferences.shared.impl.validation.ValidationResult;

public class ConstrainedValuesValidatorTest {
    private static final Collection<String> VALUES = Arrays.asList("value1", "value2", "value3");
    private static final Function<Object, String> VALUE_PARSER = Object::toString;
    private ConstrainedValuesValidator<String> tested;

    @Before
    public void setup() {
        this.tested = new ConstrainedValuesValidator(() -> VALUES, VALUE_PARSER);
    }

    @Test
    public void testValues() {
        ConstrainedValuesValidatorTest.assertResultSuccess(this.tested.validate((Object)"value1"));
        ConstrainedValuesValidatorTest.assertResultSuccess(this.tested.validate((Object)"value2"));
        ConstrainedValuesValidatorTest.assertResultSuccess(this.tested.validate((Object)"value3"));
        ConstrainedValuesValidatorTest.assertResultFailed(this.tested.validate((Object)"value4"));
    }

    static void assertResultSuccess(ValidationResult result) {
        Assert.assertTrue((boolean)result.isValid());
    }

    static void assertResultFailed(ValidationResult result) {
        Assert.assertFalse((boolean)result.isValid());
        Assert.assertEquals((long)1L, (long)result.getMessagesBundleKeys().size());
        Assert.assertEquals((Object)"PropertyValidator.ConstrainedValuesValidator.NotAllowed", result.getMessagesBundleKeys().get(0));
    }
}

