/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.preferences.shared.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.preferences.shared.impl.DefaultPreferenceScopeResolver;
import org.uberfire.preferences.shared.impl.DefaultPreferenceScopesForTests;
import org.uberfire.preferences.shared.impl.exception.InvalidPreferenceScopeException;

public class DefaultPreferenceScopeResolverTest {
    private DefaultPreferenceScopeResolver scopeResolver;

    @Before
    public void setup() {
        this.scopeResolver = new DefaultPreferenceScopeResolver(DefaultPreferenceScopesForTests.defaultOrder);
    }

    @Test
    public void resolveValidScopesTest() {
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.userEntireApplicationScope, (Object)this.scopeResolver.resolve(new String[]{DefaultPreferenceScopesForTests.userScopeType}));
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.allUsersComponentScope, (Object)this.scopeResolver.resolve(new String[]{DefaultPreferenceScopesForTests.componentScopeType}));
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.allUsersEntireApplicationScope, (Object)this.scopeResolver.resolve(new String[]{DefaultPreferenceScopesForTests.allUsersScopeType}));
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.allUsersEntireApplicationScope, (Object)this.scopeResolver.resolve(new String[]{DefaultPreferenceScopesForTests.entireApplicationScopeType}));
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.userComponentScope, (Object)this.scopeResolver.resolve(new String[]{DefaultPreferenceScopesForTests.userScopeType, DefaultPreferenceScopesForTests.componentScopeType}));
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.userEntireApplicationScope, (Object)this.scopeResolver.resolve(new String[]{DefaultPreferenceScopesForTests.userScopeType, DefaultPreferenceScopesForTests.entireApplicationScopeType}));
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.allUsersComponentScope, (Object)this.scopeResolver.resolve(new String[]{DefaultPreferenceScopesForTests.allUsersScopeType, DefaultPreferenceScopesForTests.componentScopeType}));
        Assert.assertEquals((Object)DefaultPreferenceScopesForTests.allUsersEntireApplicationScope, (Object)this.scopeResolver.resolve(new String[]{DefaultPreferenceScopesForTests.allUsersScopeType, DefaultPreferenceScopesForTests.entireApplicationScopeType}));
    }

    @Test(expected=InvalidPreferenceScopeException.class)
    public void tryResolveWithInvalidScopeTypeTest() {
        this.scopeResolver.resolve(new String[]{"invalidScopeType"});
    }

    @Test(expected=InvalidPreferenceScopeException.class)
    public void tryResolveWithNoScopeTypesTest() {
        this.scopeResolver.resolve(new String[0]);
    }

    @Test(expected=InvalidPreferenceScopeException.class)
    public void tryResolveWithThreeScopeTypesTest() {
        this.scopeResolver.resolve(new String[]{DefaultPreferenceScopesForTests.userScopeType, DefaultPreferenceScopesForTests.componentScopeType, DefaultPreferenceScopesForTests.entireApplicationScopeType});
    }
}

