/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.preferences.shared.impl.validation;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.preferences.shared.impl.validation.NumberPropertyValidator;
import org.uberfire.preferences.shared.impl.validation.ValidationResult;

public class NumberPropertyValidatorTest {
    private NumberPropertyValidator numberPropertyValidator;

    @Before
    public void setup() {
        this.numberPropertyValidator = new NumberPropertyValidator();
    }

    @Test
    public void emptyValueTest() {
        this.failureTest("");
    }

    @Test
    public void nonNumberFormatTest() {
        this.failureTest("xyz");
    }

    @Test
    public void positiveValueTest() {
        this.failureTest("-1");
    }

    @Test
    public void validNumberTest() {
        ValidationResult validationResult = this.numberPropertyValidator.validate("15");
        Assert.assertTrue((boolean)validationResult.isValid());
        Assert.assertEquals((long)0L, (long)validationResult.getMessagesBundleKeys().size());
    }

    private void failureTest(String value) {
        ValidationResult validationResult = this.numberPropertyValidator.validate(value);
        Assert.assertFalse((boolean)validationResult.isValid());
        Assert.assertEquals((long)1L, (long)validationResult.getMessagesBundleKeys().size());
        Assert.assertEquals((Object)"PropertyValidator.NumberPropertyValidator.NotAllowed", validationResult.getMessagesBundleKeys().get(0));
    }
}

