/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.backend;

import javax.enterprise.context.ContextNotActiveException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.ext.preferences.backend.ServerUsernameProvider;
import org.uberfire.mocks.SessionInfoMock;
import org.uberfire.rpc.SessionInfo;

public class ServerUsernameProviderTest {
    private SessionInfo sessionInfo;
    private ServerUsernameProvider serverUsernameProvider;

    @Before
    public void setup() {
        this.sessionInfo = (SessionInfo)Mockito.spy((Object)new SessionInfoMock());
        this.serverUsernameProvider = new ServerUsernameProvider(this.sessionInfo);
    }

    @Test
    public void testLoggedUserName() {
        String username = this.serverUsernameProvider.get();
        ((SessionInfo)Mockito.verify((Object)this.sessionInfo)).getIdentity();
        Assert.assertEquals((Object)this.sessionInfo.getIdentity().getIdentifier(), (Object)username);
    }

    @Test
    public void testNotLoggedUserName() {
        ((SessionInfo)Mockito.doThrow((Throwable)new ContextNotActiveException()).when((Object)this.sessionInfo)).getIdentity();
        String username = this.serverUsernameProvider.get();
        ((SessionInfo)Mockito.verify((Object)this.sessionInfo)).getIdentity();
        Assert.assertEquals((Object)"not-logged-user", (Object)username);
    }
}

