/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.preferences.backend;

import java.util.Arrays;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.preferences.backend.InvalidDefaultPreferenceBeanGeneratedImpl;
import org.uberfire.preferences.backend.MyInnerPreferenceBeanGeneratedImpl;
import org.uberfire.preferences.backend.MyPreferenceBeanGeneratedImpl;
import org.uberfire.preferences.backend.PreferenceBeanDefaultValueRecorder;
import org.uberfire.preferences.shared.bean.BasePreference;
import org.uberfire.preferences.shared.bean.BasePreferencePortable;
import org.uberfire.preferences.shared.bean.PreferenceBeanStore;

public class PreferenceBeanDefaultValueRecorderTest {
    private PreferenceBeanStore store;
    private PreferenceBeanDefaultValueRecorder defaultValueRecorder;

    @Before
    public void setup() {
        this.store = (PreferenceBeanStore)Mockito.mock(PreferenceBeanStore.class);
        this.defaultValueRecorder = (PreferenceBeanDefaultValueRecorder)Mockito.spy(PreferenceBeanDefaultValueRecorder.class);
    }

    @Test
    public void initializePreferenceValuesTest() {
        MyPreferenceBeanGeneratedImpl myPreference = (MyPreferenceBeanGeneratedImpl)Mockito.spy((Object)new MyPreferenceBeanGeneratedImpl(this.store));
        MyInnerPreferenceBeanGeneratedImpl myInnerPreference = (MyInnerPreferenceBeanGeneratedImpl)Mockito.spy((Object)new MyInnerPreferenceBeanGeneratedImpl(this.store));
        List<BasePreference> preferences = Arrays.asList(myPreference, myInnerPreference);
        ((PreferenceBeanDefaultValueRecorder)Mockito.doReturn(preferences).when((Object)this.defaultValueRecorder)).getPreferences();
        this.defaultValueRecorder.initializePreferenceValues();
        ((PreferenceBeanStore)Mockito.verify((Object)this.store, (VerificationMode)Mockito.times((int)1))).saveDefaultValue((BasePreferencePortable)Mockito.anyObject(), (Command)Mockito.anyObject(), (ParameterizedCommand)Mockito.anyObject());
        InOrder ordenatedVerification = Mockito.inOrder((Object[])new Object[]{this.store, myPreference, myInnerPreference});
        ((MyPreferenceBeanGeneratedImpl)ordenatedVerification.verify((Object)myPreference)).saveDefaultValue();
        ((PreferenceBeanStore)ordenatedVerification.verify((Object)this.store)).saveDefaultValue((BasePreferencePortable)Mockito.anyObject(), (Command)Mockito.anyObject(), (ParameterizedCommand)Mockito.anyObject());
        ((MyInnerPreferenceBeanGeneratedImpl)ordenatedVerification.verify((Object)myInnerPreference)).saveDefaultValue();
    }

    @Test(expected=RuntimeException.class)
    public void initializePreferenceValuesWithInvalidDefaultValueInstanceTest() {
        InvalidDefaultPreferenceBeanGeneratedImpl invalidDefaultPreference = (InvalidDefaultPreferenceBeanGeneratedImpl)Mockito.spy((Object)new InvalidDefaultPreferenceBeanGeneratedImpl(this.store));
        List<BasePreference> preferences = Arrays.asList(invalidDefaultPreference);
        ((PreferenceBeanDefaultValueRecorder)Mockito.doReturn(preferences).when((Object)this.defaultValueRecorder)).getPreferences();
        this.defaultValueRecorder.initializePreferenceValues();
    }
}

