/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.preferences.backend;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import javax.enterprise.event.Event;
import org.jboss.errai.marshalling.server.MappingContextSingleton;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.uberfire.backend.server.io.object.ObjectStorage;
import org.uberfire.backend.server.io.object.ObjectStorageImpl;
import org.uberfire.backend.server.spaces.SpacesAPIImpl;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.mocks.FileSystemTestingUtils;
import org.uberfire.mocks.SessionInfoMock;
import org.uberfire.preferences.backend.CustomObject;
import org.uberfire.preferences.backend.PreferenceStorageImpl;
import org.uberfire.preferences.backend.ServerUsernameProvider;
import org.uberfire.preferences.shared.PreferenceScope;
import org.uberfire.preferences.shared.PreferenceScopeFactory;
import org.uberfire.preferences.shared.PreferenceScopeTypes;
import org.uberfire.preferences.shared.UsernameProvider;
import org.uberfire.preferences.shared.impl.DefaultPreferenceScopeResolutionStrategy;
import org.uberfire.preferences.shared.impl.DefaultPreferenceScopeTypes;
import org.uberfire.preferences.shared.impl.DefaultScopes;
import org.uberfire.preferences.shared.impl.PreferenceScopeFactoryImpl;
import org.uberfire.preferences.shared.impl.PreferenceScopeImpl;
import org.uberfire.preferences.shared.impl.PreferenceScopeResolutionStrategyInfo;
import org.uberfire.preferences.shared.impl.PreferenceScopedValue;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.spaces.SpacesAPI;

public class PreferenceStorageImplTest {
    private static final String allUsersScopeType = DefaultScopes.ALL_USERS.type();
    private static final String entireApplicationScopeType = DefaultScopes.ENTIRE_APPLICATION.type();
    private static final String userScopeType = DefaultScopes.USER.type();
    private static final String allUsersScopeKey = allUsersScopeType;
    private static final String entireApplicationScopeKey = entireApplicationScopeType;
    private static final String userScopeKey = "my-user";
    private static final PreferenceScopeImpl allUsersScope = new PreferenceScopeImpl(allUsersScopeType, allUsersScopeKey, null);
    private static final PreferenceScopeImpl entireApplicationScope = new PreferenceScopeImpl(entireApplicationScopeType, entireApplicationScopeKey, null);
    private static final PreferenceScopeImpl userScope = new PreferenceScopeImpl(userScopeType, "my-user", null);
    private static FileSystemTestingUtils fileSystemTestingUtils = new FileSystemTestingUtils();
    private PreferenceScope userEntireApplicationScope;
    private PreferenceScope allUsersEntireApplicationScope;
    private PreferenceStorageImpl preferenceStorageServiceBackendImpl;
    private PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo;
    private PreferenceScopeFactoryImpl scopeFactory;
    private PreferenceScopeTypes scopeTypes;

    @Before
    public void setup() throws IOException {
        MappingContextSingleton.get();
        fileSystemTestingUtils.setup();
        SessionInfo sessionInfo = this.mockSessionInfo();
        FileSystem fileSystem = this.mockFileSystem();
        IOService ioService = this.mockIoService(fileSystem);
        ObjectStorageImpl objectStorage = new ObjectStorageImpl(ioService);
        this.scopeTypes = new DefaultPreferenceScopeTypes((UsernameProvider)new ServerUsernameProvider(sessionInfo));
        this.scopeFactory = new PreferenceScopeFactoryImpl(this.scopeTypes);
        this.scopeResolutionStrategyInfo = new DefaultPreferenceScopeResolutionStrategy((PreferenceScopeFactory)this.scopeFactory, null).getInfo();
        Event preferenceUpdatedEvent = (Event)Mockito.mock(Event.class);
        this.preferenceStorageServiceBackendImpl = new PreferenceStorageImpl(ioService, sessionInfo, this.scopeTypes, (PreferenceScopeFactory)this.scopeFactory, (ObjectStorage)objectStorage, (SpacesAPI)new SpacesAPIImpl(), preferenceUpdatedEvent);
        this.preferenceStorageServiceBackendImpl.init();
        this.userEntireApplicationScope = this.scopeFactory.createScope(new PreferenceScope[]{userScope, entireApplicationScope});
        this.allUsersEntireApplicationScope = this.scopeFactory.createScope(new PreferenceScope[]{allUsersScope, entireApplicationScope});
    }

    @After
    public void cleanupFileSystem() {
        fileSystemTestingUtils.cleanup();
    }

    @Test
    public void unexistentPreferenceDoesNotExistsInAScopeTest() {
        PreferenceScope scope = this.userEntireApplicationScope;
        String key = "my.preference.key";
        boolean preferenceExists = this.preferenceStorageServiceBackendImpl.exists(scope, "my.preference.key");
        Assert.assertFalse((boolean)preferenceExists);
    }

    @Test
    public void preferenceExistsInAScopeTest() {
        PreferenceScope scope = this.userEntireApplicationScope;
        String key = "my.preference.key";
        long value = 23L;
        this.preferenceStorageServiceBackendImpl.write(scope, "my.preference.key", (Object)23L);
        boolean preferenceExists = this.preferenceStorageServiceBackendImpl.exists(scope, "my.preference.key");
        Assert.assertTrue((boolean)preferenceExists);
    }

    @Test
    public void unexistentPreferenceDoesNotExistUsingScopeResolutionStrategyTest() {
        String key = "my.preference.key";
        boolean preferenceExists = this.preferenceStorageServiceBackendImpl.exists(this.scopeResolutionStrategyInfo, "my.preference.key");
        Assert.assertFalse((boolean)preferenceExists);
    }

    @Test
    public void userPreferenceExistsUsingScopeResolutionStrategyTest() {
        PreferenceScope scope = this.userEntireApplicationScope;
        String key = "my.preference.key";
        long value = 23L;
        this.preferenceStorageServiceBackendImpl.write(scope, "my.preference.key", (Object)23L);
        boolean preferenceExists = this.preferenceStorageServiceBackendImpl.exists(this.scopeResolutionStrategyInfo, "my.preference.key");
        Assert.assertTrue((boolean)preferenceExists);
    }

    @Test
    public void globalPreferenceExistsUsingScopeResolutionStrategyTest() {
        PreferenceScope scope = this.allUsersEntireApplicationScope;
        String key = "my.preference.key";
        long value = 23L;
        this.preferenceStorageServiceBackendImpl.write(scope, "my.preference.key", (Object)23L);
        boolean preferenceExists = this.preferenceStorageServiceBackendImpl.exists(this.scopeResolutionStrategyInfo, "my.preference.key");
        Assert.assertTrue((boolean)preferenceExists);
    }

    @Test
    public void writeReadLongTest() {
        PreferenceScope scope = this.userEntireApplicationScope;
        this.preferenceStorageServiceBackendImpl.write(scope, "my.preference.key", (Object)23L);
        long value = (Long)this.preferenceStorageServiceBackendImpl.read(scope, "my.preference.key");
        Assert.assertEquals((long)23L, (long)value);
    }

    @Test
    public void writeReadStringTest() {
        PreferenceScope scope = this.userEntireApplicationScope;
        this.preferenceStorageServiceBackendImpl.write(scope, "my.preference.key", (Object)"text");
        String value = (String)this.preferenceStorageServiceBackendImpl.read(scope, "my.preference.key");
        Assert.assertEquals((Object)"text", (Object)value);
    }

    @Test
    public void writeReadBooleanTest() {
        PreferenceScope scope = this.userEntireApplicationScope;
        this.preferenceStorageServiceBackendImpl.write(scope, "my.preference.key.true", (Object)true);
        this.preferenceStorageServiceBackendImpl.write(scope, "my.preference.key.false", (Object)false);
        boolean value1 = (Boolean)this.preferenceStorageServiceBackendImpl.read(scope, "my.preference.key.true");
        boolean value2 = (Boolean)this.preferenceStorageServiceBackendImpl.read(scope, "my.preference.key.false");
        Assert.assertEquals((Object)true, (Object)value1);
        Assert.assertEquals((Object)false, (Object)value2);
    }

    @Test
    public void writeReadCustomObjectTest() {
        PreferenceScope scope = this.userEntireApplicationScope;
        CustomObject customObject = new CustomObject(61L, "some text");
        this.preferenceStorageServiceBackendImpl.write(scope, "my.preference.key", (Object)customObject);
        CustomObject value = (CustomObject)this.preferenceStorageServiceBackendImpl.read(scope, "my.preference.key");
        Assert.assertEquals((Object)customObject.id, (Object)value.id);
        Assert.assertEquals((Object)customObject.text, (Object)value.text);
    }

    @Test
    public void readNonexistentPreferenceFromSpecificScopeTest() {
        PreferenceScope scope = this.userEntireApplicationScope;
        String value = (String)this.preferenceStorageServiceBackendImpl.read(scope, "my.nonexistent.preference.key");
        Assert.assertNull((Object)value);
    }

    @Test
    public void readNonexistentPreferenceWithResolutionStrategyTest() {
        String value = (String)this.preferenceStorageServiceBackendImpl.read(this.scopeResolutionStrategyInfo, "my.nonexistent.preference.key");
        Assert.assertNull((Object)value);
    }

    @Test
    public void writeGlobalAndUserReadUserWithResolutionStrategyTest() {
        this.preferenceStorageServiceBackendImpl.write(this.userEntireApplicationScope, "my.preference.key", (Object)"user_value");
        this.preferenceStorageServiceBackendImpl.write(this.allUsersEntireApplicationScope, "my.preference.key", (Object)"global_value");
        String value = (String)this.preferenceStorageServiceBackendImpl.read(this.scopeResolutionStrategyInfo, "my.preference.key");
        Assert.assertEquals((Object)"user_value", (Object)value);
    }

    @Test
    public void writeGlobalReadGlobalWithResolutionStrategyTest() {
        this.preferenceStorageServiceBackendImpl.write(this.allUsersEntireApplicationScope, "my.preference.key", (Object)"global_value");
        String value = (String)this.preferenceStorageServiceBackendImpl.read(this.scopeResolutionStrategyInfo, "my.preference.key");
        Assert.assertEquals((Object)"global_value", (Object)value);
    }

    @Test
    public void writeUserReadUserWithResolutionStrategyTest() {
        this.preferenceStorageServiceBackendImpl.write(this.userEntireApplicationScope, "my.preference.key", (Object)"user_value");
        String value = (String)this.preferenceStorageServiceBackendImpl.read(this.scopeResolutionStrategyInfo, "my.preference.key");
        Assert.assertEquals((Object)"user_value", (Object)value);
    }

    @Test
    public void readFromSpecificScopeTest() {
        this.preferenceStorageServiceBackendImpl.write(this.userEntireApplicationScope, "my.preference.key", (Object)"value");
        String value = (String)this.preferenceStorageServiceBackendImpl.read(this.userEntireApplicationScope, "my.preference.key");
        Assert.assertEquals((Object)"value", (Object)value);
    }

    @Test
    public void readWithResolutionStrategyTest() {
        this.preferenceStorageServiceBackendImpl.write(this.allUsersEntireApplicationScope, "my.preference.key", (Object)"value");
        String value = (String)this.preferenceStorageServiceBackendImpl.read(this.scopeResolutionStrategyInfo, "my.preference.key");
        Assert.assertEquals((Object)"value", (Object)value);
    }

    @Test
    public void writeGlobalAndUserReadWithScopeUserWithResolutionStrategyTest() {
        this.preferenceStorageServiceBackendImpl.write(this.userEntireApplicationScope, "my.preference.key", (Object)"user_value");
        this.preferenceStorageServiceBackendImpl.write(this.allUsersEntireApplicationScope, "my.preference.key", (Object)"global_value");
        PreferenceScopedValue scopedValue = this.preferenceStorageServiceBackendImpl.readWithScope(this.scopeResolutionStrategyInfo, "my.preference.key");
        Assert.assertEquals((Object)"user_value", (Object)scopedValue.getValue());
        Assert.assertEquals((Object)this.userEntireApplicationScope.key(), (Object)scopedValue.getScope().key());
    }

    @Test
    public void writeGlobalReadWithScopeGlobalWithResolutionStrategyTest() {
        this.preferenceStorageServiceBackendImpl.write(this.allUsersEntireApplicationScope, "my.preference.key", (Object)"global_value");
        PreferenceScopedValue scopedValue = this.preferenceStorageServiceBackendImpl.readWithScope(this.scopeResolutionStrategyInfo, "my.preference.key");
        Assert.assertEquals((Object)"global_value", (Object)scopedValue.getValue());
        Assert.assertEquals((Object)this.allUsersEntireApplicationScope.key(), (Object)scopedValue.getScope().key());
    }

    @Test
    public void writeUserReadWithScopeUserUsingResolutionStrategyTest() {
        this.preferenceStorageServiceBackendImpl.write(this.userEntireApplicationScope, "my.preference.key", (Object)"user_value");
        PreferenceScopedValue scopedValue = this.preferenceStorageServiceBackendImpl.readWithScope(this.scopeResolutionStrategyInfo, "my.preference.key");
        Assert.assertEquals((Object)"user_value", (Object)scopedValue.getValue());
        Assert.assertEquals((Object)this.userEntireApplicationScope.key(), (Object)scopedValue.getScope().key());
    }

    @Test
    public void deleteFromUserTest() {
        this.preferenceStorageServiceBackendImpl.write(this.userEntireApplicationScope, "my.preference.key", (Object)"user_value");
        this.preferenceStorageServiceBackendImpl.write(this.allUsersEntireApplicationScope, "my.preference.key", (Object)"global_value");
        String value = (String)this.preferenceStorageServiceBackendImpl.read(this.scopeResolutionStrategyInfo, "my.preference.key");
        Assert.assertEquals((Object)"user_value", (Object)value);
        this.preferenceStorageServiceBackendImpl.delete(this.userEntireApplicationScope, "my.preference.key");
        value = (String)this.preferenceStorageServiceBackendImpl.read(this.scopeResolutionStrategyInfo, "my.preference.key");
        Assert.assertEquals((Object)"global_value", (Object)value);
        this.preferenceStorageServiceBackendImpl.delete(this.allUsersEntireApplicationScope, "my.preference.key");
        value = (String)this.preferenceStorageServiceBackendImpl.read(this.scopeResolutionStrategyInfo, "my.preference.key");
        Assert.assertNull((Object)value);
    }

    @Test
    public void allKeysWithKeysTest() {
        this.preferenceStorageServiceBackendImpl.write(this.allUsersEntireApplicationScope, "my.first.global.preference.key", (Object)"global_value1");
        this.preferenceStorageServiceBackendImpl.write(this.allUsersEntireApplicationScope, "my.second.global.preference.key", (Object)"global_value2");
        this.preferenceStorageServiceBackendImpl.write(this.allUsersEntireApplicationScope, "my.third.global.preference.key", (Object)"global_value3");
        this.preferenceStorageServiceBackendImpl.write(this.userEntireApplicationScope, "my.first.user.preference.key", (Object)"user_value1");
        this.preferenceStorageServiceBackendImpl.write(this.userEntireApplicationScope, "my.second.user.preference.key", (Object)"user_value2");
        Collection globalKeys = this.preferenceStorageServiceBackendImpl.allKeys(this.allUsersEntireApplicationScope);
        Collection userKeys = this.preferenceStorageServiceBackendImpl.allKeys(this.userEntireApplicationScope);
        Assert.assertNotNull((Object)globalKeys);
        Assert.assertEquals((long)3L, (long)globalKeys.size());
        Assert.assertTrue((boolean)globalKeys.contains("my.first.global.preference.key"));
        Assert.assertTrue((boolean)globalKeys.contains("my.second.global.preference.key"));
        Assert.assertTrue((boolean)globalKeys.contains("my.third.global.preference.key"));
        Assert.assertNotNull((Object)userKeys);
        Assert.assertEquals((long)2L, (long)userKeys.size());
        Assert.assertTrue((boolean)userKeys.contains("my.first.user.preference.key"));
        Assert.assertTrue((boolean)userKeys.contains("my.second.user.preference.key"));
    }

    @Test
    public void allKeysWithNoKeysTest() {
        Collection keys = this.preferenceStorageServiceBackendImpl.allKeys(this.allUsersEntireApplicationScope);
        Assert.assertNotNull((Object)keys);
        Assert.assertEquals((String)"There should not exist any keys.", (long)0L, (long)keys.size());
    }

    @Test
    public void buildScopePathForAllUsersEntireApplicationScope() {
        String path = this.preferenceStorageServiceBackendImpl.buildScopePath(this.allUsersEntireApplicationScope);
        Assert.assertEquals((Object)"/config/all-users/all-users/entire-application/entire-application/", (Object)path);
    }

    @Test
    public void buildScopePathForUserScope() {
        String path = this.preferenceStorageServiceBackendImpl.buildScopePath(this.userEntireApplicationScope);
        Assert.assertEquals((Object)"/config/user/my-user/entire-application/entire-application/", (Object)path);
    }

    @Test
    public void buildStoragePathForUserScope() {
        String path = this.preferenceStorageServiceBackendImpl.buildScopedPreferencePath(this.userEntireApplicationScope, "my.preference.key");
        Assert.assertEquals((Object)"/config/user/my-user/entire-application/entire-application/my.preference.key.preferences", (Object)path);
    }

    @Test
    public void buildStoragePathForGlobalScope() {
        String path = this.preferenceStorageServiceBackendImpl.buildScopedPreferencePath(this.allUsersEntireApplicationScope, "my.preference.key");
        Assert.assertEquals((Object)"/config/all-users/all-users/entire-application/entire-application/my.preference.key.preferences", (Object)path);
    }

    private SessionInfo mockSessionInfo() {
        return new SessionInfoMock(userScopeKey);
    }

    private FileSystem mockFileSystem() {
        return fileSystemTestingUtils.getFileSystem();
    }

    private IOService mockIoService(FileSystem fileSystem) {
        IOService ioService = (IOService)Mockito.spy((Object)fileSystemTestingUtils.getIoService());
        ((IOService)Mockito.doNothing().when((Object)ioService)).startBatch((FileSystem)Matchers.any(FileSystem.class));
        ((IOService)Mockito.doNothing().when((Object)ioService)).endBatch();
        ((IOService)Mockito.doReturn((Object)fileSystem).when((Object)ioService)).newFileSystem((URI)Matchers.any(URI.class), Matchers.anyMap());
        return ioService;
    }
}

