/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.preferences.backend;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.event.Event;
import org.jboss.errai.marshalling.server.MappingContextSingleton;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.io.object.ObjectStorage;
import org.uberfire.backend.server.io.object.ObjectStorageImpl;
import org.uberfire.backend.server.spaces.SpacesAPIImpl;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.mocks.FileSystemTestingUtils;
import org.uberfire.mocks.SessionInfoMock;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.preferences.backend.PreferenceStorageImpl;
import org.uberfire.preferences.backend.PreferenceStoreImpl;
import org.uberfire.preferences.backend.ServerUsernameProvider;
import org.uberfire.preferences.shared.PreferenceScope;
import org.uberfire.preferences.shared.PreferenceScopeFactory;
import org.uberfire.preferences.shared.PreferenceScopeResolutionStrategy;
import org.uberfire.preferences.shared.PreferenceScopeTypes;
import org.uberfire.preferences.shared.PreferenceStorage;
import org.uberfire.preferences.shared.UsernameProvider;
import org.uberfire.preferences.shared.impl.DefaultPreferenceScopeResolutionStrategy;
import org.uberfire.preferences.shared.impl.DefaultPreferenceScopeTypes;
import org.uberfire.preferences.shared.impl.DefaultScopes;
import org.uberfire.preferences.shared.impl.PreferenceScopeFactoryImpl;
import org.uberfire.preferences.shared.impl.PreferenceScopeImpl;
import org.uberfire.preferences.shared.impl.PreferenceScopeResolutionStrategyInfo;
import org.uberfire.preferences.shared.impl.PreferenceScopedValue;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.spaces.SpacesAPI;

public class PreferenceStoreImplTest {
    private static final String allUsersScopeType = DefaultScopes.ALL_USERS.type();
    private static final String entireApplicationScopeType = DefaultScopes.ENTIRE_APPLICATION.type();
    private static final String userScopeType = DefaultScopes.USER.type();
    private static final String allUsersScopeKey = allUsersScopeType;
    private static final String entireApplicationScopeKey = entireApplicationScopeType;
    private static final String userScopeKey = "my-user";
    private static final PreferenceScopeImpl allUsersScope = new PreferenceScopeImpl(allUsersScopeType, allUsersScopeKey, null);
    private static final PreferenceScopeImpl entireApplicationScope = new PreferenceScopeImpl(entireApplicationScopeType, entireApplicationScopeKey, null);
    private static final PreferenceScopeImpl userScope = new PreferenceScopeImpl(userScopeType, "my-user", null);
    private static final String USER = "my-user";
    private static final String KEY = "my.preference.key";
    private static final String VALUE = "value";
    private static final String DEFAULT_VALUE = "defaultValue";
    private static final String FIRST_KEY = "my.first.preference.key";
    private static final String FIRST_VALUE = "value1";
    private static final String SECOND_KEY = "my.second.preference.key";
    private static final String SECOND_VALUE = "value2";
    private static final String THIRD_KEY = "my.third.preference.key";
    private static final String THIRD_VALUE = "value3";
    private static FileSystemTestingUtils fileSystemTestingUtils = new FileSystemTestingUtils();
    private PreferenceScope userEntireApplicationScope;
    private PreferenceScope allUsersEntireApplication;
    private ParameterizedCommand<String> callback;
    private PreferenceScopeTypes scopeTypes;
    private PreferenceScopeFactory scopeFactory;
    private PreferenceStorageImpl storage;
    private PreferenceScopeResolutionStrategy preferenceScopeResolutionStrategy;
    private PreferenceScopeResolutionStrategyInfo preferenceScopeResolutionStrategyInfo;
    private PreferenceStoreImpl preferenceStore;

    @Before
    public void setup() throws IOException {
        MappingContextSingleton.get();
        fileSystemTestingUtils.setup();
        this.callback = (ParameterizedCommand)Mockito.mock(ParameterizedCommand.class);
        SessionInfoMock sessionInfo = new SessionInfoMock("my-user");
        FileSystem fileSystem = this.mockFileSystem();
        IOService ioService = this.mockIoService(fileSystem);
        ObjectStorageImpl objectStorage = new ObjectStorageImpl(ioService);
        Event preferenceUpdatedEvent = (Event)Mockito.mock(Event.class);
        this.scopeTypes = new DefaultPreferenceScopeTypes((UsernameProvider)new ServerUsernameProvider((SessionInfo)sessionInfo));
        this.scopeFactory = new PreferenceScopeFactoryImpl(this.scopeTypes);
        this.preferenceScopeResolutionStrategy = new DefaultPreferenceScopeResolutionStrategy(this.scopeFactory, null);
        this.preferenceScopeResolutionStrategyInfo = this.preferenceScopeResolutionStrategy.getInfo();
        this.storage = (PreferenceStorageImpl)Mockito.spy((Object)new PreferenceStorageImpl(ioService, (SessionInfo)sessionInfo, this.scopeTypes, this.scopeFactory, (ObjectStorage)objectStorage, (SpacesAPI)new SpacesAPIImpl(), preferenceUpdatedEvent));
        this.storage.init();
        this.preferenceStore = (PreferenceStoreImpl)Mockito.spy((Object)new PreferenceStoreImpl((PreferenceStorage)this.storage, this.scopeFactory, this.preferenceScopeResolutionStrategy));
        this.userEntireApplicationScope = this.scopeFactory.createScope(new PreferenceScope[]{userScope, entireApplicationScope});
        this.allUsersEntireApplication = this.scopeFactory.createScope(new PreferenceScope[]{allUsersScope, entireApplicationScope});
    }

    @After
    public void cleanupFileSystem() {
        fileSystemTestingUtils.cleanup();
    }

    @Test
    public void putInScopeTest() {
        this.preferenceStore.put(this.allUsersEntireApplication, KEY, (Object)VALUE);
        this.preferenceStore.put(this.allUsersEntireApplication, KEY, (Object)VALUE);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage, (VerificationMode)Mockito.times((int)2))).write(this.allUsersEntireApplication, KEY, (Object)VALUE);
    }

    @Test
    public void putInDefaultScopeOfAScopeResolutionStrategyTest() {
        this.preferenceStore.put(this.preferenceScopeResolutionStrategyInfo, KEY, (Object)VALUE);
        this.preferenceStore.put(this.preferenceScopeResolutionStrategyInfo, KEY, (Object)VALUE);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage, (VerificationMode)Mockito.times((int)2))).write(this.preferenceScopeResolutionStrategyInfo.defaultScope(), KEY, (Object)VALUE);
    }

    @Test
    public void putInDefaultScopeTest() {
        this.preferenceStore.put(KEY, (Object)VALUE);
        this.preferenceStore.put(KEY, (Object)VALUE);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage, (VerificationMode)Mockito.times((int)2))).write(this.preferenceScopeResolutionStrategyInfo.defaultScope(), KEY, (Object)VALUE);
    }

    @Test
    public void putMapInScopeTest() {
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put(FIRST_KEY, FIRST_VALUE);
        preferences.put(SECOND_KEY, SECOND_VALUE);
        this.preferenceStore.put(this.allUsersEntireApplication, preferences);
        this.preferenceStore.put(this.allUsersEntireApplication, preferences);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage, (VerificationMode)Mockito.times((int)2))).write(this.allUsersEntireApplication, FIRST_KEY, (Object)FIRST_VALUE);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage, (VerificationMode)Mockito.times((int)2))).write(this.allUsersEntireApplication, SECOND_KEY, (Object)SECOND_VALUE);
    }

    @Test
    public void putMapInDefaultScopeOfAScopeResolutionStrategyTest() {
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put(FIRST_KEY, FIRST_VALUE);
        preferences.put(SECOND_KEY, SECOND_VALUE);
        this.preferenceStore.put(this.preferenceScopeResolutionStrategyInfo, preferences);
        this.preferenceStore.put(this.preferenceScopeResolutionStrategyInfo, preferences);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage, (VerificationMode)Mockito.times((int)2))).write(this.preferenceScopeResolutionStrategyInfo.defaultScope(), FIRST_KEY, (Object)FIRST_VALUE);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage, (VerificationMode)Mockito.times((int)2))).write(this.preferenceScopeResolutionStrategyInfo.defaultScope(), SECOND_KEY, (Object)SECOND_VALUE);
    }

    @Test
    public void putMapInDefaultScopeTest() {
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put(FIRST_KEY, FIRST_VALUE);
        preferences.put(SECOND_KEY, SECOND_VALUE);
        this.preferenceStore.put(preferences);
        this.preferenceStore.put(preferences);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage, (VerificationMode)Mockito.times((int)2))).write(this.preferenceScopeResolutionStrategyInfo.defaultScope(), FIRST_KEY, (Object)FIRST_VALUE);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage, (VerificationMode)Mockito.times((int)2))).write(this.preferenceScopeResolutionStrategyInfo.defaultScope(), SECOND_KEY, (Object)SECOND_VALUE);
    }

    @Test
    public void putIfAbsentInScopeTest() {
        this.preferenceStore.putIfAbsent(this.allUsersEntireApplication, KEY, (Object)VALUE);
        this.preferenceStore.putIfAbsent(this.allUsersEntireApplication, KEY, (Object)VALUE);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage, (VerificationMode)Mockito.times((int)1))).write(this.allUsersEntireApplication, KEY, (Object)VALUE);
    }

    @Test
    public void putIfAbsentInDefaultScopeOfAScopeResolutionStrategyTest() {
        this.preferenceStore.putIfAbsent(this.preferenceScopeResolutionStrategyInfo, KEY, (Object)VALUE);
        this.preferenceStore.putIfAbsent(this.preferenceScopeResolutionStrategyInfo, KEY, (Object)VALUE);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage, (VerificationMode)Mockito.times((int)1))).write(this.preferenceScopeResolutionStrategyInfo.defaultScope(), KEY, (Object)VALUE);
    }

    @Test
    public void putIfAbsentInDefaultScopeTest() {
        this.preferenceStore.putIfAbsent(KEY, (Object)VALUE);
        this.preferenceStore.putIfAbsent(KEY, (Object)VALUE);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage, (VerificationMode)Mockito.times((int)1))).write(this.preferenceScopeResolutionStrategyInfo.defaultScope(), KEY, (Object)VALUE);
    }

    @Test
    public void putIfAbsentMapInScopeTest() {
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put(FIRST_KEY, FIRST_VALUE);
        preferences.put(SECOND_KEY, SECOND_VALUE);
        this.preferenceStore.putIfAbsent(this.allUsersEntireApplication, preferences);
        this.preferenceStore.putIfAbsent(this.allUsersEntireApplication, preferences);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage, (VerificationMode)Mockito.times((int)1))).write(this.allUsersEntireApplication, FIRST_KEY, (Object)FIRST_VALUE);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage, (VerificationMode)Mockito.times((int)1))).write(this.allUsersEntireApplication, SECOND_KEY, (Object)SECOND_VALUE);
    }

    @Test
    public void putIfAbsentMapInDefaultScopeOfAScopeResolutionStrategyTest() {
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put(FIRST_KEY, FIRST_VALUE);
        preferences.put(SECOND_KEY, SECOND_VALUE);
        this.preferenceStore.putIfAbsent(this.preferenceScopeResolutionStrategyInfo, preferences);
        this.preferenceStore.putIfAbsent(this.preferenceScopeResolutionStrategyInfo, preferences);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage, (VerificationMode)Mockito.times((int)1))).write(this.preferenceScopeResolutionStrategyInfo.defaultScope(), FIRST_KEY, (Object)FIRST_VALUE);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage, (VerificationMode)Mockito.times((int)1))).write(this.preferenceScopeResolutionStrategyInfo.defaultScope(), SECOND_KEY, (Object)SECOND_VALUE);
    }

    @Test
    public void putIfAbsentMapInDefaultScopeTest() {
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put(FIRST_KEY, FIRST_VALUE);
        preferences.put(SECOND_KEY, SECOND_VALUE);
        this.preferenceStore.putIfAbsent(preferences);
        this.preferenceStore.putIfAbsent(preferences);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage, (VerificationMode)Mockito.times((int)1))).write(this.preferenceScopeResolutionStrategyInfo.defaultScope(), FIRST_KEY, (Object)FIRST_VALUE);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage, (VerificationMode)Mockito.times((int)1))).write(this.preferenceScopeResolutionStrategyInfo.defaultScope(), SECOND_KEY, (Object)SECOND_VALUE);
    }

    @Test
    public void getStringValueFromScopeWithoutDefaultValueTest() {
        this.mockStorageRead(VALUE);
        String value = (String)this.preferenceStore.get(this.allUsersEntireApplication, KEY);
        Assert.assertEquals((Object)VALUE, (Object)value);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage)).read(this.allUsersEntireApplication, KEY);
    }

    @Test
    public void getNullValueFromScopeWithoutDefaultValueTest() {
        String value = (String)this.preferenceStore.get(this.allUsersEntireApplication, KEY);
        Assert.assertNull((Object)value);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage)).read(this.allUsersEntireApplication, KEY);
    }

    @Test
    public void getStringValueFromScopeWithDefaultValueTest() {
        this.mockStorageRead(VALUE);
        String value = (String)this.preferenceStore.get(this.allUsersEntireApplication, KEY, (Object)DEFAULT_VALUE);
        Assert.assertEquals((Object)VALUE, (Object)value);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage)).read(this.allUsersEntireApplication, KEY);
    }

    @Test
    public void getNullValueFromScopeWithDefaultValueTest() {
        String value = (String)this.preferenceStore.get(this.allUsersEntireApplication, KEY, (Object)DEFAULT_VALUE);
        Assert.assertEquals((Object)DEFAULT_VALUE, (Object)value);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage)).read(this.allUsersEntireApplication, KEY);
    }

    @Test
    public void getStringValueFromScopeResolutionStrategyWithoutDefaultValueTest() {
        this.mockStorageRead(VALUE);
        String value = (String)this.preferenceStore.get(this.preferenceScopeResolutionStrategyInfo, KEY);
        Assert.assertEquals((Object)VALUE, (Object)value);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage)).read(this.preferenceScopeResolutionStrategyInfo, KEY);
    }

    @Test
    public void getNullValueFromScopeResolutionStrategyWithoutDefaultValueTest() {
        String value = (String)this.preferenceStore.get(this.preferenceScopeResolutionStrategyInfo, KEY);
        Assert.assertNull((Object)value);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage)).read(this.preferenceScopeResolutionStrategyInfo, KEY);
    }

    @Test
    public void getStringValueFromScopeResolutionStrategyWithDefaultValueTest() {
        this.mockStorageRead(VALUE);
        String value = (String)this.preferenceStore.get(this.preferenceScopeResolutionStrategyInfo, KEY, (Object)DEFAULT_VALUE);
        Assert.assertEquals((Object)VALUE, (Object)value);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage)).read(this.preferenceScopeResolutionStrategyInfo, KEY);
    }

    @Test
    public void getNullValueFromScopeResolutionStrategyWithDefaultValueTest() {
        String value = (String)this.preferenceStore.get(this.preferenceScopeResolutionStrategyInfo, KEY, (Object)DEFAULT_VALUE);
        Assert.assertEquals((Object)DEFAULT_VALUE, (Object)value);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage)).read(this.preferenceScopeResolutionStrategyInfo, KEY);
    }

    @Test
    public void getStringValueWithoutDefaultValueTest() {
        this.mockStorageRead(VALUE);
        String value = (String)this.preferenceStore.get(KEY);
        Assert.assertEquals((Object)VALUE, (Object)value);
    }

    @Test
    public void getNullValueWithoutDefaultValueTest() {
        String value = (String)this.preferenceStore.get(KEY);
        Assert.assertNull((Object)value);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage)).read(this.allUsersEntireApplication, KEY);
    }

    @Test
    public void getScopedStringValueFromScopeResolutionStrategyWithoutDefaultValueTest() {
        this.mockStorageRead(VALUE);
        PreferenceScopedValue scopedValue = this.preferenceStore.getScoped(this.preferenceScopeResolutionStrategyInfo, KEY);
        PreferenceScope scope = (PreferenceScope)this.preferenceScopeResolutionStrategyInfo.order().get(0);
        Assert.assertEquals((Object)VALUE, (Object)scopedValue.getValue());
        Assert.assertEquals((Object)scope.key(), (Object)scopedValue.getScope().key());
        Assert.assertEquals((Object)scope.type(), (Object)scopedValue.getScope().type());
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage)).readWithScope(this.preferenceScopeResolutionStrategyInfo, KEY);
    }

    @Test
    public void getScopedNullValueFromScopeResolutionStrategyWithoutDefaultValueTest() {
        PreferenceScopedValue scopedValue = this.preferenceStore.getScoped(this.preferenceScopeResolutionStrategyInfo, KEY);
        Assert.assertNull((Object)scopedValue);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage)).readWithScope(this.preferenceScopeResolutionStrategyInfo, KEY);
    }

    @Test
    public void getScopedStringValueFromScopeResolutionStrategyWithDefaultValueTest() {
        this.mockStorageRead(VALUE);
        PreferenceScopedValue scopedValue = this.preferenceStore.getScoped(this.preferenceScopeResolutionStrategyInfo, KEY, (Object)DEFAULT_VALUE);
        PreferenceScope scope = (PreferenceScope)this.preferenceScopeResolutionStrategyInfo.order().get(0);
        Assert.assertEquals((Object)VALUE, (Object)scopedValue.getValue());
        Assert.assertEquals((Object)scope.key(), (Object)scopedValue.getScope().key());
        Assert.assertEquals((Object)scope.type(), (Object)scopedValue.getScope().type());
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage)).readWithScope(this.preferenceScopeResolutionStrategyInfo, KEY);
    }

    @Test
    public void getScopedNullValueFromScopeResolutionStrategyWithDefaultValueTest() {
        PreferenceScopedValue scopedValue = this.preferenceStore.getScoped(this.preferenceScopeResolutionStrategyInfo, KEY, (Object)DEFAULT_VALUE);
        Assert.assertEquals((Object)DEFAULT_VALUE, (Object)scopedValue.getValue());
        Assert.assertNull((Object)scopedValue.getScope());
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage)).readWithScope(this.preferenceScopeResolutionStrategyInfo, KEY);
    }

    @Test
    public void getScopedStringValueFromDefaultScopeResolutionStrategyWithoutDefaultValueTest() {
        this.mockStorageRead(VALUE);
        PreferenceScopedValue scopedValue = this.preferenceStore.getScoped(KEY);
        PreferenceScope scope = (PreferenceScope)this.preferenceScopeResolutionStrategyInfo.order().get(0);
        Assert.assertEquals((Object)VALUE, (Object)scopedValue.getValue());
        Assert.assertEquals((Object)scope.key(), (Object)scopedValue.getScope().key());
        Assert.assertEquals((Object)scope.type(), (Object)scopedValue.getScope().type());
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage)).readWithScope(this.preferenceScopeResolutionStrategyInfo, KEY);
    }

    @Test
    public void getScopedNullValueFromDefaultScopeResolutionStrategyWithoutDefaultValueTest() {
        PreferenceScopedValue scopedValue = this.preferenceStore.getScoped(KEY);
        Assert.assertNull((Object)scopedValue);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage)).readWithScope(this.preferenceScopeResolutionStrategyInfo, KEY);
    }

    @Test
    public void getScopedStringValueFromDefaultScopeResolutionStrategyWithDefaultValueTest() {
        this.mockStorageRead(VALUE);
        PreferenceScopedValue scopedValue = this.preferenceStore.getScoped(KEY, (Object)DEFAULT_VALUE);
        PreferenceScope scope = (PreferenceScope)this.preferenceScopeResolutionStrategyInfo.order().get(0);
        Assert.assertEquals((Object)VALUE, (Object)scopedValue.getValue());
        Assert.assertEquals((Object)scope.key(), (Object)scopedValue.getScope().key());
        Assert.assertEquals((Object)scope.type(), (Object)scopedValue.getScope().type());
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage)).readWithScope(this.preferenceScopeResolutionStrategyInfo, KEY);
    }

    @Test
    public void getScopedNullValueFromDefaultScopeResolutionStrategyWithDefaultValueTest() {
        PreferenceScopedValue scopedValue = this.preferenceStore.getScoped(KEY, (Object)DEFAULT_VALUE);
        Assert.assertEquals((Object)DEFAULT_VALUE, (Object)scopedValue.getValue());
        Assert.assertNull((Object)scopedValue.getScope());
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage)).readWithScope(this.preferenceScopeResolutionStrategyInfo, KEY);
    }

    @Test
    public void searchOnScopeTest() {
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put(FIRST_KEY, FIRST_VALUE);
        preferences.put(SECOND_KEY, SECOND_VALUE);
        for (Map.Entry preference : preferences.entrySet()) {
            ((PreferenceStorageImpl)Mockito.doReturn(preference.getValue()).when((Object)this.storage)).read(this.allUsersEntireApplication, (String)preference.getKey());
        }
        Map returnedPreferences = this.preferenceStore.search(this.allUsersEntireApplication, preferences.keySet());
        Assert.assertEquals((long)preferences.size(), (long)returnedPreferences.size());
        for (Map.Entry preference : preferences.entrySet()) {
            String key = (String)preference.getKey();
            String value = (String)preference.getValue();
            Assert.assertTrue((boolean)returnedPreferences.containsKey(key));
            Assert.assertEquals((Object)value, returnedPreferences.get(key));
            ((PreferenceStorageImpl)Mockito.verify((Object)this.storage)).read(this.allUsersEntireApplication, key);
        }
    }

    @Test
    public void searchOnScopeResolutionStrategyTest() {
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put(FIRST_KEY, FIRST_VALUE);
        preferences.put(SECOND_KEY, SECOND_VALUE);
        for (Map.Entry preference : preferences.entrySet()) {
            ((PreferenceStorageImpl)Mockito.doReturn(preference.getValue()).when((Object)this.storage)).read(this.preferenceScopeResolutionStrategyInfo, (String)preference.getKey());
        }
        Map returnedPreferences = this.preferenceStore.search(this.preferenceScopeResolutionStrategyInfo, preferences.keySet());
        Assert.assertEquals((long)preferences.size(), (long)returnedPreferences.size());
        for (Map.Entry preference : preferences.entrySet()) {
            String key = (String)preference.getKey();
            String value = (String)preference.getValue();
            Assert.assertTrue((boolean)returnedPreferences.containsKey(key));
            Assert.assertEquals((Object)value, returnedPreferences.get(key));
            ((PreferenceStorageImpl)Mockito.verify((Object)this.storage)).read(this.preferenceScopeResolutionStrategyInfo, key);
        }
    }

    @Test
    public void searchOnDefaultScopeResolutionStrategyTest() {
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put(FIRST_KEY, FIRST_VALUE);
        preferences.put(SECOND_KEY, SECOND_VALUE);
        for (Map.Entry preference : preferences.entrySet()) {
            ((PreferenceStorageImpl)Mockito.doReturn(preference.getValue()).when((Object)this.storage)).read(this.preferenceScopeResolutionStrategyInfo, (String)preference.getKey());
        }
        Map returnedPreferences = this.preferenceStore.search(preferences.keySet());
        Assert.assertEquals((long)preferences.size(), (long)returnedPreferences.size());
        for (Map.Entry preference : preferences.entrySet()) {
            String key = (String)preference.getKey();
            String value = (String)preference.getValue();
            Assert.assertTrue((boolean)returnedPreferences.containsKey(key));
            Assert.assertEquals((Object)value, returnedPreferences.get(key));
            ((PreferenceStorageImpl)Mockito.verify((Object)this.storage)).read(this.preferenceScopeResolutionStrategyInfo, key);
        }
    }

    @Test
    public void searchScopedOnScopeResolutionStrategyTest() {
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put(FIRST_KEY, FIRST_VALUE);
        preferences.put(SECOND_KEY, SECOND_VALUE);
        for (Map.Entry preference : preferences.entrySet()) {
            ((PreferenceStorageImpl)Mockito.doReturn(preference.getValue()).when((Object)this.storage)).read((PreferenceScope)this.preferenceScopeResolutionStrategyInfo.order().get(0), (String)preference.getKey());
        }
        Map returnedPreferences = this.preferenceStore.searchScoped(this.preferenceScopeResolutionStrategyInfo, preferences.keySet());
        Assert.assertEquals((long)preferences.size(), (long)returnedPreferences.size());
        for (Map.Entry preference : preferences.entrySet()) {
            String key = (String)preference.getKey();
            String value = (String)preference.getValue();
            Assert.assertTrue((boolean)returnedPreferences.containsKey(key));
            Assert.assertEquals((Object)value, (Object)((PreferenceScopedValue)returnedPreferences.get(key)).getValue());
            Assert.assertEquals((Object)((PreferenceScope)this.preferenceScopeResolutionStrategyInfo.order().get(0)).type(), (Object)((PreferenceScopedValue)returnedPreferences.get(key)).getScope().type());
            Assert.assertEquals((Object)((PreferenceScope)this.preferenceScopeResolutionStrategyInfo.order().get(0)).key(), (Object)((PreferenceScopedValue)returnedPreferences.get(key)).getScope().key());
            ((PreferenceStorageImpl)Mockito.verify((Object)this.storage)).read((PreferenceScope)this.preferenceScopeResolutionStrategyInfo.order().get(0), key);
        }
    }

    @Test
    public void searchScopedOnDefaultScopeResolutionStrategyTest() {
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put(FIRST_KEY, FIRST_VALUE);
        preferences.put(SECOND_KEY, SECOND_VALUE);
        for (Map.Entry preference : preferences.entrySet()) {
            ((PreferenceStorageImpl)Mockito.doReturn(preference.getValue()).when((Object)this.storage)).read((PreferenceScope)this.preferenceScopeResolutionStrategyInfo.order().get(0), (String)preference.getKey());
        }
        Map returnedPreferences = this.preferenceStore.searchScoped(preferences.keySet());
        Assert.assertEquals((long)preferences.size(), (long)returnedPreferences.size());
        for (Map.Entry preference : preferences.entrySet()) {
            String key = (String)preference.getKey();
            String value = (String)preference.getValue();
            Assert.assertTrue((boolean)returnedPreferences.containsKey(key));
            Assert.assertEquals((Object)value, (Object)((PreferenceScopedValue)returnedPreferences.get(key)).getValue());
            Assert.assertEquals((Object)((PreferenceScope)this.preferenceScopeResolutionStrategyInfo.order().get(0)).type(), (Object)((PreferenceScopedValue)returnedPreferences.get(key)).getScope().type());
            Assert.assertEquals((Object)((PreferenceScope)this.preferenceScopeResolutionStrategyInfo.order().get(0)).key(), (Object)((PreferenceScopedValue)returnedPreferences.get(key)).getScope().key());
            ((PreferenceStorageImpl)Mockito.verify((Object)this.storage)).read((PreferenceScope)this.preferenceScopeResolutionStrategyInfo.order().get(0), key);
        }
    }

    @Test
    public void allPreferencesByScopeTest() {
        PreferenceScope userScope = this.userEntireApplicationScope;
        ((PreferenceStorageImpl)Mockito.doReturn((Object)FIRST_VALUE).when((Object)this.storage)).read(userScope, FIRST_KEY);
        ((PreferenceStorageImpl)Mockito.doReturn((Object)SECOND_VALUE).when((Object)this.storage)).read(userScope, SECOND_KEY);
        ArrayList<String> keys = new ArrayList<String>(2);
        keys.add(FIRST_KEY);
        keys.add(SECOND_KEY);
        ((PreferenceStorageImpl)Mockito.doReturn(keys).when((Object)this.storage)).allKeys(userScope);
        Map valueByKey = this.preferenceStore.all(userScope);
        Assert.assertNotNull((Object)valueByKey);
        Assert.assertEquals((long)2L, (long)valueByKey.size());
        Assert.assertTrue((boolean)valueByKey.containsKey(FIRST_KEY));
        Assert.assertTrue((boolean)valueByKey.containsKey(SECOND_KEY));
        Assert.assertEquals((Object)FIRST_VALUE, valueByKey.get(FIRST_KEY));
        Assert.assertEquals((Object)SECOND_VALUE, valueByKey.get(SECOND_KEY));
    }

    @Test
    public void allPreferencesByScopeResolutionStrategyTest() {
        ((PreferenceStorageImpl)Mockito.doReturn((Object)FIRST_VALUE).when((Object)this.storage)).read(this.preferenceScopeResolutionStrategyInfo, FIRST_KEY);
        ((PreferenceStorageImpl)Mockito.doReturn((Object)SECOND_VALUE).when((Object)this.storage)).read(this.preferenceScopeResolutionStrategyInfo, SECOND_KEY);
        ((PreferenceStorageImpl)Mockito.doReturn((Object)THIRD_VALUE).when((Object)this.storage)).read(this.preferenceScopeResolutionStrategyInfo, THIRD_KEY);
        ArrayList<String> preferenceKeys = new ArrayList<String>(3);
        preferenceKeys.add(FIRST_KEY);
        preferenceKeys.add(SECOND_KEY);
        preferenceKeys.add(THIRD_KEY);
        ((PreferenceStorageImpl)Mockito.doReturn(preferenceKeys).when((Object)this.storage)).allKeys(this.preferenceScopeResolutionStrategyInfo.order());
        Map valueByKey = this.preferenceStore.all(this.preferenceScopeResolutionStrategyInfo);
        Assert.assertNotNull((Object)valueByKey);
        Assert.assertEquals((long)3L, (long)valueByKey.size());
        Assert.assertTrue((boolean)valueByKey.containsKey(FIRST_KEY));
        Assert.assertTrue((boolean)valueByKey.containsKey(SECOND_KEY));
        Assert.assertTrue((boolean)valueByKey.containsKey(THIRD_KEY));
        Assert.assertEquals((Object)FIRST_VALUE, valueByKey.get(FIRST_KEY));
        Assert.assertEquals((Object)SECOND_VALUE, valueByKey.get(SECOND_KEY));
        Assert.assertEquals((Object)THIRD_VALUE, valueByKey.get(THIRD_KEY));
    }

    @Test
    public void allPreferencesTest() {
        ((PreferenceStorageImpl)Mockito.doReturn((Object)FIRST_VALUE).when((Object)this.storage)).read(this.preferenceScopeResolutionStrategyInfo, FIRST_KEY);
        ((PreferenceStorageImpl)Mockito.doReturn((Object)SECOND_VALUE).when((Object)this.storage)).read(this.preferenceScopeResolutionStrategyInfo, SECOND_KEY);
        ((PreferenceStorageImpl)Mockito.doReturn((Object)THIRD_VALUE).when((Object)this.storage)).read(this.preferenceScopeResolutionStrategyInfo, THIRD_KEY);
        ArrayList<String> preferenceKeys = new ArrayList<String>(3);
        preferenceKeys.add(FIRST_KEY);
        preferenceKeys.add(SECOND_KEY);
        preferenceKeys.add(THIRD_KEY);
        ((PreferenceStorageImpl)Mockito.doReturn(preferenceKeys).when((Object)this.storage)).allKeys(this.preferenceScopeResolutionStrategyInfo.order());
        Map valueByKey = this.preferenceStore.all();
        Assert.assertNotNull((Object)valueByKey);
        Assert.assertEquals((long)3L, (long)valueByKey.size());
        Assert.assertTrue((boolean)valueByKey.containsKey(FIRST_KEY));
        Assert.assertTrue((boolean)valueByKey.containsKey(SECOND_KEY));
        Assert.assertTrue((boolean)valueByKey.containsKey(THIRD_KEY));
        Assert.assertEquals((Object)FIRST_VALUE, valueByKey.get(FIRST_KEY));
        Assert.assertEquals((Object)SECOND_VALUE, valueByKey.get(SECOND_KEY));
        Assert.assertEquals((Object)THIRD_VALUE, valueByKey.get(THIRD_KEY));
    }

    @Test
    public void allScopedPreferencesByScopeResolutionStrategyTest() {
        ((PreferenceStorageImpl)Mockito.doReturn((Object)new PreferenceScopedValue((Object)FIRST_VALUE, this.allUsersEntireApplication)).when((Object)this.storage)).readWithScope(this.preferenceScopeResolutionStrategyInfo, FIRST_KEY);
        ((PreferenceStorageImpl)Mockito.doReturn((Object)new PreferenceScopedValue((Object)SECOND_VALUE, this.allUsersEntireApplication)).when((Object)this.storage)).readWithScope(this.preferenceScopeResolutionStrategyInfo, SECOND_KEY);
        ((PreferenceStorageImpl)Mockito.doReturn((Object)new PreferenceScopedValue((Object)THIRD_VALUE, this.userEntireApplicationScope)).when((Object)this.storage)).readWithScope(this.preferenceScopeResolutionStrategyInfo, THIRD_KEY);
        ArrayList<String> preferenceKeys = new ArrayList<String>(3);
        preferenceKeys.add(FIRST_KEY);
        preferenceKeys.add(SECOND_KEY);
        preferenceKeys.add(THIRD_KEY);
        ((PreferenceStorageImpl)Mockito.doReturn(preferenceKeys).when((Object)this.storage)).allKeys(this.preferenceScopeResolutionStrategyInfo.order());
        Map valueByKey = this.preferenceStore.allScoped(this.preferenceScopeResolutionStrategyInfo);
        Assert.assertNotNull((Object)valueByKey);
        Assert.assertEquals((long)3L, (long)valueByKey.size());
        Assert.assertTrue((boolean)valueByKey.containsKey(FIRST_KEY));
        Assert.assertTrue((boolean)valueByKey.containsKey(SECOND_KEY));
        Assert.assertTrue((boolean)valueByKey.containsKey(THIRD_KEY));
        Assert.assertEquals((Object)FIRST_VALUE, (Object)((PreferenceScopedValue)valueByKey.get(FIRST_KEY)).getValue());
        Assert.assertEquals((Object)this.allUsersEntireApplication, (Object)((PreferenceScopedValue)valueByKey.get(FIRST_KEY)).getScope());
        Assert.assertEquals((Object)SECOND_VALUE, (Object)((PreferenceScopedValue)valueByKey.get(SECOND_KEY)).getValue());
        Assert.assertEquals((Object)this.allUsersEntireApplication, (Object)((PreferenceScopedValue)valueByKey.get(SECOND_KEY)).getScope());
        Assert.assertEquals((Object)THIRD_VALUE, (Object)((PreferenceScopedValue)valueByKey.get(THIRD_KEY)).getValue());
        Assert.assertEquals((Object)this.userEntireApplicationScope, (Object)((PreferenceScopedValue)valueByKey.get(THIRD_KEY)).getScope());
    }

    @Test
    public void allScopedPreferencesByDefaultScopeResolutionStrategyTest() {
        ((PreferenceStorageImpl)Mockito.doReturn((Object)new PreferenceScopedValue((Object)FIRST_VALUE, this.allUsersEntireApplication)).when((Object)this.storage)).readWithScope(this.preferenceScopeResolutionStrategyInfo, FIRST_KEY);
        ((PreferenceStorageImpl)Mockito.doReturn((Object)new PreferenceScopedValue((Object)SECOND_VALUE, this.allUsersEntireApplication)).when((Object)this.storage)).readWithScope(this.preferenceScopeResolutionStrategyInfo, SECOND_KEY);
        ((PreferenceStorageImpl)Mockito.doReturn((Object)new PreferenceScopedValue((Object)THIRD_VALUE, this.userEntireApplicationScope)).when((Object)this.storage)).readWithScope(this.preferenceScopeResolutionStrategyInfo, THIRD_KEY);
        ArrayList<String> preferenceKeys = new ArrayList<String>(3);
        preferenceKeys.add(FIRST_KEY);
        preferenceKeys.add(SECOND_KEY);
        preferenceKeys.add(THIRD_KEY);
        ((PreferenceStorageImpl)Mockito.doReturn(preferenceKeys).when((Object)this.storage)).allKeys(this.preferenceScopeResolutionStrategyInfo.order());
        Map valueByKey = this.preferenceStore.allScoped();
        Assert.assertNotNull((Object)valueByKey);
        Assert.assertEquals((long)3L, (long)valueByKey.size());
        Assert.assertTrue((boolean)valueByKey.containsKey(FIRST_KEY));
        Assert.assertTrue((boolean)valueByKey.containsKey(SECOND_KEY));
        Assert.assertTrue((boolean)valueByKey.containsKey(THIRD_KEY));
        Assert.assertEquals((Object)FIRST_VALUE, (Object)((PreferenceScopedValue)valueByKey.get(FIRST_KEY)).getValue());
        Assert.assertEquals((Object)this.allUsersEntireApplication, (Object)((PreferenceScopedValue)valueByKey.get(FIRST_KEY)).getScope());
        Assert.assertEquals((Object)SECOND_VALUE, (Object)((PreferenceScopedValue)valueByKey.get(SECOND_KEY)).getValue());
        Assert.assertEquals((Object)this.allUsersEntireApplication, (Object)((PreferenceScopedValue)valueByKey.get(SECOND_KEY)).getScope());
        Assert.assertEquals((Object)THIRD_VALUE, (Object)((PreferenceScopedValue)valueByKey.get(THIRD_KEY)).getValue());
        Assert.assertEquals((Object)this.userEntireApplicationScope, (Object)((PreferenceScopedValue)valueByKey.get(THIRD_KEY)).getScope());
    }

    @Test
    public void removeByScopeTest() {
        this.preferenceStore.remove(this.allUsersEntireApplication, KEY);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage)).delete(this.allUsersEntireApplication, KEY);
    }

    @Test
    public void removeByScopesTest() {
        this.preferenceStore.remove(this.preferenceScopeResolutionStrategyInfo.order(), KEY);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage)).delete((PreferenceScope)this.preferenceScopeResolutionStrategyInfo.order().get(0), KEY);
        ((PreferenceStorageImpl)Mockito.verify((Object)this.storage)).delete((PreferenceScope)this.preferenceScopeResolutionStrategyInfo.order().get(1), KEY);
    }

    private void mockStorageRead(String value) {
        ((PreferenceStorageImpl)Mockito.doReturn((Object)value).when((Object)this.storage)).read((PreferenceScope)Matchers.any(PreferenceScope.class), Matchers.anyString());
        ((PreferenceStorageImpl)Mockito.doReturn((Object)value).when((Object)this.storage)).read((PreferenceScopeResolutionStrategyInfo)Matchers.any(PreferenceScopeResolutionStrategyInfo.class), Matchers.anyString());
    }

    private FileSystem mockFileSystem() {
        return fileSystemTestingUtils.getFileSystem();
    }

    private IOService mockIoService(FileSystem fileSystem) {
        IOService ioService = (IOService)Mockito.spy((Object)fileSystemTestingUtils.getIoService());
        ((IOService)Mockito.doNothing().when((Object)ioService)).startBatch((FileSystem)Matchers.any(FileSystem.class));
        ((IOService)Mockito.doNothing().when((Object)ioService)).endBatch();
        ((IOService)Mockito.doReturn((Object)fileSystem).when((Object)ioService)).newFileSystem((URI)Matchers.any(URI.class), Matchers.anyMap());
        return ioService;
    }
}

