/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.preferences.backend;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.preferences.backend.MyInnerPreference;
import org.uberfire.preferences.backend.MyInnerPreference2;
import org.uberfire.preferences.backend.MyInnerPreference2PortableGeneratedImpl;
import org.uberfire.preferences.backend.MyInnerPreferencePortableGeneratedImpl;
import org.uberfire.preferences.backend.MyPreference;
import org.uberfire.preferences.backend.MyPreferencePortableGeneratedImpl;
import org.uberfire.preferences.backend.MySharedPreference;
import org.uberfire.preferences.backend.MySharedPreference2;
import org.uberfire.preferences.backend.MySharedPreference2PortableGeneratedImpl;
import org.uberfire.preferences.backend.MySharedPreferencePortableGeneratedImpl;
import org.uberfire.preferences.backend.PreferenceBeanStoreImpl;
import org.uberfire.preferences.shared.PreferenceScope;
import org.uberfire.preferences.shared.PreferenceScopeResolutionStrategy;
import org.uberfire.preferences.shared.PreferenceStore;
import org.uberfire.preferences.shared.PropertyFormOptions;
import org.uberfire.preferences.shared.bean.BasePreference;
import org.uberfire.preferences.shared.bean.BasePreferencePortable;
import org.uberfire.preferences.shared.bean.PreferenceHierarchyElement;
import org.uberfire.preferences.shared.impl.PreferenceScopeResolutionStrategyInfo;

public class PreferenceBeanStoreImplTest {
    private PreferenceStore preferenceStore;
    private PreferenceBeanStoreImpl preferenceBeanStoreImpl;
    private PreferenceScopeResolutionStrategy preferenceScopeResolutionStrategy;
    private PreferenceScopeResolutionStrategyInfo scopeInfo;
    private PreferenceScope lastScope;

    @Before
    public void setup() {
        this.preferenceScopeResolutionStrategy = (PreferenceScopeResolutionStrategy)Mockito.mock(PreferenceScopeResolutionStrategy.class);
        this.preferenceStore = (PreferenceStore)Mockito.mock(PreferenceStore.class);
        this.preferenceBeanStoreImpl = (PreferenceBeanStoreImpl)Mockito.spy((Object)new PreferenceBeanStoreImpl(this.preferenceStore, this.preferenceScopeResolutionStrategy, null));
        this.lastScope = (PreferenceScope)Mockito.mock(PreferenceScope.class);
        this.scopeInfo = new PreferenceScopeResolutionStrategyInfo(Arrays.asList(this.lastScope), (PreferenceScope)Mockito.mock(PreferenceScope.class));
        ((PreferenceScopeResolutionStrategy)Mockito.doReturn((Object)this.scopeInfo).when((Object)this.preferenceScopeResolutionStrategy)).getInfo();
        ((PreferenceBeanStoreImpl)Mockito.doAnswer(invocationOnMock -> {
            Object[] args = invocationOnMock.getArguments();
            Class clazz = (Class)args[0];
            return this.getPortablePreferenceByClass(clazz);
        }).when((Object)this.preferenceBeanStoreImpl)).lookupPortablePreference((Class)Mockito.any(Class.class));
    }

    @Test
    public void loadTest() {
        MyPreferencePortableGeneratedImpl myPreference = new MyPreferencePortableGeneratedImpl();
        MySharedPreferencePortableGeneratedImpl mySharedPreference = new MySharedPreferencePortableGeneratedImpl();
        MySharedPreference2PortableGeneratedImpl mySharedPreference2 = new MySharedPreference2PortableGeneratedImpl();
        ((PreferenceStore)Mockito.doReturn((Object)myPreference).when((Object)this.preferenceStore)).get((PreferenceScopeResolutionStrategyInfo)Mockito.any(PreferenceScopeResolutionStrategyInfo.class), (String)Mockito.eq((Object)MyPreference.class.getSimpleName()));
        ((PreferenceStore)Mockito.doReturn((Object)mySharedPreference).when((Object)this.preferenceStore)).get((PreferenceScopeResolutionStrategyInfo)Mockito.any(PreferenceScopeResolutionStrategyInfo.class), (String)Mockito.eq((Object)MySharedPreference.class.getSimpleName()));
        ((PreferenceStore)Mockito.doReturn((Object)mySharedPreference2).when((Object)this.preferenceStore)).get((PreferenceScopeResolutionStrategyInfo)Mockito.any(PreferenceScopeResolutionStrategyInfo.class), (String)Mockito.eq((Object)MySharedPreference2.class.getSimpleName()));
        MyPreferencePortableGeneratedImpl loadedMyPreference = (MyPreferencePortableGeneratedImpl)this.preferenceBeanStoreImpl.load((BasePreferencePortable)new MyPreferencePortableGeneratedImpl());
        MySharedPreference2PortableGeneratedImpl loadedMySharedPreference2 = (MySharedPreference2PortableGeneratedImpl)this.preferenceBeanStoreImpl.load((BasePreferencePortable)new MySharedPreference2PortableGeneratedImpl());
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore, (VerificationMode)Mockito.times((int)3))).get((PreferenceScopeResolutionStrategyInfo)Mockito.eq((Object)this.scopeInfo), Mockito.anyString());
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore)).get(this.scopeInfo, MyPreference.class.getSimpleName());
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore)).get(this.scopeInfo, MySharedPreference.class.getSimpleName());
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore)).get(this.scopeInfo, MySharedPreference2.class.getSimpleName());
        Assert.assertEquals((Object)myPreference, (Object)loadedMyPreference);
        Assert.assertEquals((Object)mySharedPreference, (Object)loadedMyPreference.mySharedPreference);
        Assert.assertEquals((Object)mySharedPreference2, (Object)loadedMySharedPreference2);
    }

    @Test
    public void loadDefaultValueTest() {
        MyPreference myPreference = new MyPreferencePortableGeneratedImpl();
        myPreference = myPreference.defaultValue(myPreference);
        MySharedPreferencePortableGeneratedImpl mySharedPreference = new MySharedPreferencePortableGeneratedImpl();
        MySharedPreference2PortableGeneratedImpl mySharedPreference2 = new MySharedPreference2PortableGeneratedImpl();
        MyPreferencePortableGeneratedImpl loadedMyPreference = (MyPreferencePortableGeneratedImpl)this.preferenceBeanStoreImpl.load((BasePreferencePortable)new MyPreferencePortableGeneratedImpl());
        MySharedPreference2PortableGeneratedImpl loadedMySharedPreference2 = (MySharedPreference2PortableGeneratedImpl)this.preferenceBeanStoreImpl.load((BasePreferencePortable)new MySharedPreference2PortableGeneratedImpl());
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore, (VerificationMode)Mockito.times((int)3))).get((PreferenceScopeResolutionStrategyInfo)Mockito.eq((Object)this.scopeInfo), Mockito.anyString());
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore)).get(this.scopeInfo, MyPreference.class.getSimpleName());
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore)).get(this.scopeInfo, MySharedPreference.class.getSimpleName());
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore)).get(this.scopeInfo, MySharedPreference2.class.getSimpleName());
        Assert.assertEquals((Object)myPreference, (Object)loadedMyPreference);
        Assert.assertEquals((Object)mySharedPreference, (Object)loadedMyPreference.mySharedPreference);
        Assert.assertEquals((Object)mySharedPreference2, (Object)loadedMySharedPreference2);
    }

    @Test
    public void loadWithCustomResolutionStrategyScopeTest() {
        MyPreferencePortableGeneratedImpl myPreference = new MyPreferencePortableGeneratedImpl();
        MySharedPreferencePortableGeneratedImpl mySharedPreference = new MySharedPreferencePortableGeneratedImpl();
        MySharedPreference2PortableGeneratedImpl mySharedPreference2 = new MySharedPreference2PortableGeneratedImpl();
        ((PreferenceStore)Mockito.doReturn((Object)myPreference).when((Object)this.preferenceStore)).get((PreferenceScopeResolutionStrategyInfo)Mockito.any(PreferenceScopeResolutionStrategyInfo.class), (String)Mockito.eq((Object)MyPreference.class.getSimpleName()));
        ((PreferenceStore)Mockito.doReturn((Object)mySharedPreference).when((Object)this.preferenceStore)).get((PreferenceScopeResolutionStrategyInfo)Mockito.any(PreferenceScopeResolutionStrategyInfo.class), (String)Mockito.eq((Object)MySharedPreference.class.getSimpleName()));
        ((PreferenceStore)Mockito.doReturn((Object)mySharedPreference2).when((Object)this.preferenceStore)).get((PreferenceScopeResolutionStrategyInfo)Mockito.any(PreferenceScopeResolutionStrategyInfo.class), (String)Mockito.eq((Object)MySharedPreference2.class.getSimpleName()));
        PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo = new PreferenceScopeResolutionStrategyInfo(new ArrayList(), (PreferenceScope)Mockito.mock(PreferenceScope.class));
        MyPreferencePortableGeneratedImpl loadedMyPreference = (MyPreferencePortableGeneratedImpl)this.preferenceBeanStoreImpl.load((BasePreferencePortable)new MyPreferencePortableGeneratedImpl(), scopeResolutionStrategyInfo);
        MySharedPreference2PortableGeneratedImpl loadedMySharedPreference2 = (MySharedPreference2PortableGeneratedImpl)this.preferenceBeanStoreImpl.load((BasePreferencePortable)new MySharedPreference2PortableGeneratedImpl(), scopeResolutionStrategyInfo);
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore, (VerificationMode)Mockito.times((int)3))).get((PreferenceScopeResolutionStrategyInfo)Mockito.eq((Object)scopeResolutionStrategyInfo), Mockito.anyString());
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore)).get(scopeResolutionStrategyInfo, MyPreference.class.getSimpleName());
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore)).get(scopeResolutionStrategyInfo, MySharedPreference.class.getSimpleName());
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore)).get(scopeResolutionStrategyInfo, MySharedPreference2.class.getSimpleName());
        Assert.assertEquals((Object)myPreference, (Object)loadedMyPreference);
        Assert.assertEquals((Object)mySharedPreference, (Object)loadedMyPreference.mySharedPreference);
        Assert.assertEquals((Object)mySharedPreference2, (Object)loadedMySharedPreference2);
    }

    @Test
    public void saveTest() {
        MyPreferencePortableGeneratedImpl myPreference = (MyPreferencePortableGeneratedImpl)this.preferenceBeanStoreImpl.load((BasePreferencePortable)new MyPreferencePortableGeneratedImpl());
        this.preferenceBeanStoreImpl.save((BasePreferencePortable)myPreference);
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore, (VerificationMode)Mockito.times((int)2))).put((PreferenceScope)Mockito.any(PreferenceScope.class), Mockito.anyString(), Mockito.any(Object.class));
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore)).put((PreferenceScope)Mockito.eq((Object)this.scopeInfo.defaultScope()), (String)Mockito.eq((Object)MyPreference.class.getSimpleName()), (Object)((MyPreferencePortableGeneratedImpl)Mockito.eq((Object)myPreference)));
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore)).put((PreferenceScope)Mockito.eq((Object)this.scopeInfo.defaultScope()), (String)Mockito.eq((Object)MySharedPreference.class.getSimpleName()), (Object)((MySharedPreference)Mockito.eq((Object)myPreference.mySharedPreference)));
    }

    @Test
    public void saveWithCustomResolutionStrategyScopeTest() {
        PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo = new PreferenceScopeResolutionStrategyInfo(new ArrayList(), (PreferenceScope)Mockito.mock(PreferenceScope.class));
        MyPreferencePortableGeneratedImpl myPreference = (MyPreferencePortableGeneratedImpl)this.preferenceBeanStoreImpl.load((BasePreferencePortable)new MyPreferencePortableGeneratedImpl(), scopeResolutionStrategyInfo);
        this.preferenceBeanStoreImpl.save((BasePreferencePortable)myPreference, scopeResolutionStrategyInfo);
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore, (VerificationMode)Mockito.times((int)2))).put((PreferenceScope)Mockito.same((Object)scopeResolutionStrategyInfo.defaultScope()), Mockito.anyString(), Mockito.any(Object.class));
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore)).put((PreferenceScope)Mockito.same((Object)scopeResolutionStrategyInfo.defaultScope()), (String)Mockito.eq((Object)MyPreference.class.getSimpleName()), (Object)((MyPreferencePortableGeneratedImpl)Mockito.eq((Object)myPreference)));
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore)).put((PreferenceScope)Mockito.same((Object)scopeResolutionStrategyInfo.defaultScope()), (String)Mockito.eq((Object)MySharedPreference.class.getSimpleName()), (Object)((MySharedPreference)Mockito.eq((Object)myPreference.mySharedPreference)));
    }

    @Test
    public void saveWithCustomScopeTest() {
        PreferenceScope scope = (PreferenceScope)Mockito.mock(PreferenceScope.class);
        PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo = new PreferenceScopeResolutionStrategyInfo(new ArrayList(), (PreferenceScope)Mockito.mock(PreferenceScope.class));
        MyPreferencePortableGeneratedImpl myPreference = (MyPreferencePortableGeneratedImpl)this.preferenceBeanStoreImpl.load((BasePreferencePortable)new MyPreferencePortableGeneratedImpl(), scopeResolutionStrategyInfo);
        this.preferenceBeanStoreImpl.save((BasePreferencePortable)myPreference, scope);
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore, (VerificationMode)Mockito.times((int)2))).put((PreferenceScope)Mockito.same((Object)scope), Mockito.anyString(), Mockito.any(Object.class));
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore)).put((PreferenceScope)Mockito.same((Object)scope), (String)Mockito.eq((Object)MyPreference.class.getSimpleName()), (Object)((MyPreferencePortableGeneratedImpl)Mockito.eq((Object)myPreference)));
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore)).put((PreferenceScope)Mockito.same((Object)scope), (String)Mockito.eq((Object)MySharedPreference.class.getSimpleName()), (Object)((MySharedPreference)Mockito.eq((Object)myPreference.mySharedPreference)));
    }

    @Test
    public void saveCollectionTest() {
        List<BasePreferencePortable<BasePreference<?>>> preferencesToSave = this.getRootPortablePreferences();
        MyPreference myPreference = (MyPreference)preferencesToSave.get(0);
        MySharedPreference2 mySharedPreference2 = (MySharedPreference2)preferencesToSave.get(1);
        this.preferenceBeanStoreImpl.save(preferencesToSave);
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore, (VerificationMode)Mockito.times((int)2))).put((PreferenceScope)Mockito.eq((Object)this.scopeInfo.defaultScope()), Mockito.anyString(), Mockito.any(Object.class));
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore)).put(this.scopeInfo.defaultScope(), MyPreference.class.getSimpleName(), (Object)myPreference);
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore)).put(this.scopeInfo.defaultScope(), MySharedPreference.class.getSimpleName(), (Object)myPreference.mySharedPreference);
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore, (VerificationMode)Mockito.never())).put((PreferenceScope)Mockito.eq((Object)this.scopeInfo.defaultScope()), (String)Mockito.eq((Object)MySharedPreference2.class.getSimpleName()), (Object)((MySharedPreference2)Mockito.same((Object)mySharedPreference2)));
    }

    @Test
    public void saveCollectionWithCustomResolutionStrategyScopeTest() {
        PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo = new PreferenceScopeResolutionStrategyInfo(new ArrayList(), (PreferenceScope)Mockito.mock(PreferenceScope.class));
        List<BasePreferencePortable<BasePreference<?>>> preferencesToSave = this.getRootPortablePreferences();
        MyPreference myPreference = (MyPreference)preferencesToSave.get(0);
        MySharedPreference2 mySharedPreference2 = (MySharedPreference2)preferencesToSave.get(1);
        this.preferenceBeanStoreImpl.save(preferencesToSave, scopeResolutionStrategyInfo);
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore, (VerificationMode)Mockito.times((int)2))).put((PreferenceScope)Mockito.eq((Object)scopeResolutionStrategyInfo.defaultScope()), Mockito.anyString(), Mockito.any(Object.class));
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore)).put(scopeResolutionStrategyInfo.defaultScope(), MyPreference.class.getSimpleName(), (Object)myPreference);
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore)).put(scopeResolutionStrategyInfo.defaultScope(), MySharedPreference.class.getSimpleName(), (Object)myPreference.mySharedPreference);
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore, (VerificationMode)Mockito.never())).put((PreferenceScope)Mockito.eq((Object)scopeResolutionStrategyInfo.defaultScope()), (String)Mockito.eq((Object)MySharedPreference2.class.getSimpleName()), (Object)((MySharedPreference2)Mockito.same((Object)mySharedPreference2)));
    }

    @Test
    public void saveCollectionWithCustomScopeTest() {
        PreferenceScope scope = (PreferenceScope)Mockito.mock(PreferenceScope.class);
        PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo = new PreferenceScopeResolutionStrategyInfo(new ArrayList(), (PreferenceScope)Mockito.mock(PreferenceScope.class));
        List<BasePreferencePortable<BasePreference<?>>> preferencesToSave = this.getRootPortablePreferences();
        MyPreference myPreference = (MyPreference)preferencesToSave.get(0);
        MySharedPreference2 mySharedPreference2 = (MySharedPreference2)preferencesToSave.get(1);
        this.preferenceBeanStoreImpl.save(preferencesToSave, scope);
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore, (VerificationMode)Mockito.times((int)2))).put((PreferenceScope)Mockito.same((Object)scope), Mockito.anyString(), Mockito.any(Object.class));
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore)).put((PreferenceScope)Mockito.same((Object)scope), (String)Mockito.eq((Object)MyPreference.class.getSimpleName()), (Object)((MyPreference)Mockito.eq((Object)myPreference)));
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore)).put((PreferenceScope)Mockito.same((Object)scope), (String)Mockito.eq((Object)MySharedPreference.class.getSimpleName()), (Object)((MySharedPreference)Mockito.eq((Object)myPreference.mySharedPreference)));
        ((PreferenceStore)Mockito.verify((Object)this.preferenceStore, (VerificationMode)Mockito.never())).put((PreferenceScope)Mockito.same((Object)scope), (String)Mockito.eq((Object)MySharedPreference2.class.getSimpleName()), (Object)((MySharedPreference2)Mockito.same((Object)mySharedPreference2)));
    }

    @Test
    public void buildHierarchyStructureTest() {
        PreferenceHierarchyElement preferenceHierarchyElement;
        List<BasePreferencePortable<BasePreference<?>>> rootPreferences = this.getRootPortablePreferences();
        MyPreferencePortableGeneratedImpl myPreference = (MyPreferencePortableGeneratedImpl)rootPreferences.get(0);
        ((PreferenceBeanStoreImpl)Mockito.doReturn(this.getPortablePreferences()).when((Object)this.preferenceBeanStoreImpl)).getPortablePreferences();
        PreferenceHierarchyElement firstElement = preferenceHierarchyElement = this.preferenceBeanStoreImpl.buildHierarchyStructureForPreference(myPreference.identifier());
        Assert.assertEquals((Object)myPreference.identifier(), (Object)firstElement.getPortablePreference().identifier());
        Assert.assertTrue((boolean)firstElement.isRoot());
        Assert.assertFalse((boolean)firstElement.isShared());
        Assert.assertEquals((Object)"MyPreference.Text.Help", firstElement.getHelpBundleKeyByProperty().get("text"));
        Assert.assertEquals((long)1L, (long)((PropertyFormOptions[])firstElement.getFormOptionsByProperty().get("text")).length);
        Assert.assertEquals((Object)PropertyFormOptions.DISABLED, (Object)((PropertyFormOptions[])firstElement.getFormOptionsByProperty().get("text"))[0]);
        Assert.assertEquals((long)2L, (long)firstElement.getChildren().size());
        PreferenceHierarchyElement firstElementFirstChild = (PreferenceHierarchyElement)firstElement.getChildren().get(0);
        Assert.assertEquals((Object)((MyInnerPreferencePortableGeneratedImpl)myPreference.myInnerPreference).identifier(), (Object)firstElementFirstChild.getPortablePreference().identifier());
        Assert.assertFalse((boolean)firstElementFirstChild.isRoot());
        Assert.assertFalse((boolean)firstElementFirstChild.isShared());
        Assert.assertEquals((long)0L, (long)firstElementFirstChild.getChildren().size());
        PreferenceHierarchyElement firstElementSecondChild = (PreferenceHierarchyElement)firstElement.getChildren().get(1);
        Assert.assertEquals((Object)((MySharedPreferencePortableGeneratedImpl)myPreference.mySharedPreference).identifier(), (Object)firstElementSecondChild.getPortablePreference().identifier());
        Assert.assertFalse((boolean)firstElementSecondChild.isRoot());
        Assert.assertTrue((boolean)firstElementSecondChild.isShared());
        Assert.assertEquals((long)1L, (long)firstElementSecondChild.getChildren().size());
        PreferenceHierarchyElement firstElementSecondChildFirstChild = (PreferenceHierarchyElement)firstElementSecondChild.getChildren().get(0);
        Assert.assertEquals((Object)((MyInnerPreference2PortableGeneratedImpl)myPreference.mySharedPreference.myInnerPreference2).identifier(), (Object)firstElementSecondChildFirstChild.getPortablePreference().identifier());
        Assert.assertFalse((boolean)firstElementSecondChildFirstChild.isRoot());
        Assert.assertFalse((boolean)firstElementSecondChildFirstChild.isShared());
        Assert.assertEquals((long)1L, (long)firstElementSecondChildFirstChild.getChildren().size());
        PreferenceHierarchyElement firstElementSecondChildFirstChildFirstChild = (PreferenceHierarchyElement)firstElementSecondChildFirstChild.getChildren().get(0);
        Assert.assertEquals((Object)"MySharedPreference2", (Object)firstElementSecondChildFirstChildFirstChild.getPortablePreference().identifier());
        Assert.assertTrue((boolean)firstElementSecondChildFirstChildFirstChild.isRoot());
        Assert.assertFalse((boolean)firstElementSecondChildFirstChildFirstChild.isShared());
        Assert.assertEquals((long)0L, (long)firstElementSecondChildFirstChildFirstChild.getChildren().size());
    }

    private List<BasePreferencePortable<? extends BasePreference<?>>> getRootPortablePreferences() {
        MyPreferencePortableGeneratedImpl myPreference = (MyPreferencePortableGeneratedImpl)this.preferenceBeanStoreImpl.load((BasePreferencePortable)new MyPreferencePortableGeneratedImpl());
        MySharedPreference2PortableGeneratedImpl mySharedPreference2 = (MySharedPreference2PortableGeneratedImpl)this.preferenceBeanStoreImpl.load((BasePreferencePortable)new MySharedPreference2PortableGeneratedImpl());
        ArrayList rootPreferences = new ArrayList();
        rootPreferences.add(myPreference);
        rootPreferences.add(mySharedPreference2);
        return rootPreferences;
    }

    private List<BasePreferencePortable<?>> getPortablePreferences() {
        ArrayList portablePreferences = new ArrayList();
        portablePreferences.add(this.getPortablePreferenceByClass(MyPreference.class));
        portablePreferences.add(this.getPortablePreferenceByClass(MyInnerPreference.class));
        portablePreferences.add(this.getPortablePreferenceByClass(MyInnerPreference2.class));
        portablePreferences.add(this.getPortablePreferenceByClass(MySharedPreference.class));
        portablePreferences.add(this.getPortablePreferenceByClass(MySharedPreference2.class));
        return portablePreferences;
    }

    private BasePreferencePortable<?> getPortablePreferenceByClass(Class<?> clazz) {
        if (MyPreference.class.equals(clazz)) {
            return new MyPreferencePortableGeneratedImpl();
        }
        if (MyInnerPreference.class.equals(clazz)) {
            return new MyInnerPreferencePortableGeneratedImpl();
        }
        if (MyInnerPreference2.class.equals(clazz)) {
            return new MyInnerPreference2PortableGeneratedImpl();
        }
        if (MySharedPreference.class.equals(clazz)) {
            return new MySharedPreferencePortableGeneratedImpl();
        }
        if (MySharedPreference2.class.equals(clazz)) {
            return new MySharedPreference2PortableGeneratedImpl();
        }
        return null;
    }
}

