/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.client.store;

import java.util.ArrayList;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.ext.preferences.client.store.PreferenceBeanStoreImpl;
import org.uberfire.ext.preferences.shared.PropertyFormType;
import org.uberfire.ext.preferences.shared.bean.BasePreference;
import org.uberfire.ext.preferences.shared.bean.BasePreferencePortable;
import org.uberfire.ext.preferences.shared.bean.PreferenceBeanServerStore;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

public class PreferenceBeanStoreImplTest {
    private PreferenceBeanServerStore store;
    private CallerMock<PreferenceBeanServerStore> storeCaller;
    private PreferenceBeanStoreImpl preferenceBeanStoreImpl;
    private final Command successCommand = (Command)Mockito.spy((Object)new Command(){

        public void execute() {
        }
    });
    private final ParameterizedCommand<MyPreferencePortable> successParameterizedCommand = (ParameterizedCommand)Mockito.spy((Object)new ParameterizedCommand<MyPreferencePortable>(){

        public void execute(MyPreferencePortable parameter) {
        }
    });
    private final ParameterizedCommand<Throwable> errorParameterizedCommand = (ParameterizedCommand)Mockito.spy((Object)new ParameterizedCommand<Throwable>(){

        public void execute(Throwable parameter) {
        }
    });

    @Before
    public void setup() {
        this.store = (PreferenceBeanServerStore)Mockito.mock(PreferenceBeanServerStore.class);
        this.storeCaller = new CallerMock((Object)this.store);
        this.preferenceBeanStoreImpl = new PreferenceBeanStoreImpl(this.storeCaller);
    }

    @Test
    public void loadSuccessfullyTest() {
        this.preferenceBeanStoreImpl.load((BasePreferencePortable)new MyPreferencePortable(), this.successParameterizedCommand, this.errorParameterizedCommand);
        ((PreferenceBeanServerStore)Mockito.verify((Object)this.store)).load((BasePreferencePortable)Mockito.any(MyPreferencePortable.class));
        ((ParameterizedCommand)Mockito.verify(this.successParameterizedCommand)).execute(Mockito.any(MyPreferencePortable.class));
    }

    @Test
    public void loadWithErrorTest() {
        ((PreferenceBeanServerStore)Mockito.doThrow((Throwable)new RuntimeException("error")).when((Object)this.store)).load((BasePreferencePortable)Mockito.any(BasePreferencePortable.class));
        this.preferenceBeanStoreImpl.load((BasePreferencePortable)new MyPreferencePortable(), this.successParameterizedCommand, this.errorParameterizedCommand);
        ((PreferenceBeanServerStore)Mockito.verify((Object)this.store)).load((BasePreferencePortable)Mockito.any(MyPreferencePortable.class));
        ((ParameterizedCommand)Mockito.verify(this.errorParameterizedCommand)).execute(Mockito.any(Throwable.class));
    }

    @Test
    public void saveSuccessfullyTest() {
        this.preferenceBeanStoreImpl.save((BasePreferencePortable)new MyPreferencePortable(), this.successCommand, this.errorParameterizedCommand);
        ((PreferenceBeanServerStore)Mockito.verify((Object)this.store)).save((BasePreferencePortable)Mockito.any(MyPreferencePortable.class));
        ((Command)Mockito.verify((Object)this.successCommand)).execute();
    }

    @Test
    public void saveWithErrorTest() {
        ((PreferenceBeanServerStore)Mockito.doThrow((Throwable)new RuntimeException("error")).when((Object)this.store)).save((BasePreferencePortable)Mockito.any(BasePreferencePortable.class));
        this.preferenceBeanStoreImpl.save((BasePreferencePortable)new MyPreferencePortable(), this.successCommand, this.errorParameterizedCommand);
        ((PreferenceBeanServerStore)Mockito.verify((Object)this.store)).save((BasePreferencePortable)Mockito.any(MyPreferencePortable.class));
        ((ParameterizedCommand)Mockito.verify(this.errorParameterizedCommand)).execute(Mockito.any(Throwable.class));
    }

    @Test
    public void saveCollectionSuccessfullyTest() {
        ArrayList<MyPreferencePortable> preferences = new ArrayList<MyPreferencePortable>();
        preferences.add(new MyPreferencePortable());
        this.preferenceBeanStoreImpl.save(preferences, this.successCommand, this.errorParameterizedCommand);
        ((PreferenceBeanServerStore)Mockito.verify((Object)this.store)).save(preferences);
        ((Command)Mockito.verify((Object)this.successCommand)).execute();
    }

    @Test
    public void saveCollectionWithErrorTest() {
        ((PreferenceBeanServerStore)Mockito.doThrow((Throwable)new RuntimeException("error")).when((Object)this.store)).save(Mockito.anyCollection());
        ArrayList<MyPreferencePortable> preferences = new ArrayList<MyPreferencePortable>();
        preferences.add(new MyPreferencePortable());
        this.preferenceBeanStoreImpl.save(preferences, this.successCommand, this.errorParameterizedCommand);
        ((PreferenceBeanServerStore)Mockito.verify((Object)this.store)).save(preferences);
        ((ParameterizedCommand)Mockito.verify(this.errorParameterizedCommand)).execute(Mockito.any(Throwable.class));
    }

    class MyPreferencePortable
    extends MyPreference
    implements BasePreferencePortable<MyPreference> {
        MyPreferencePortable() {
        }

        public Class<MyPreference> getPojoClass() {
            return MyPreference.class;
        }

        public String bundleKey() {
            return null;
        }

        public String key() {
            return null;
        }

        public void set(String property, Object value) {
        }

        public Object get(String property) {
            return null;
        }

        public Map<String, PropertyFormType> getPropertiesTypes() {
            return null;
        }
    }

    class MyPreference
    implements BasePreference<MyPreference> {
        MyPreference() {
        }
    }
}

