/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.client.utils;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Named;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.client.mvp.ActivityBeansInfo;
import org.uberfire.client.mvp.WorkbenchScreenActivity;
import org.uberfire.ext.preferences.client.annotations.PreferenceForm;
import org.uberfire.ext.preferences.client.utils.PreferenceFormBeansInfo;
import org.uberfire.ext.preferences.shared.bean.BasePreference;

public class PreferenceFormBeansInfoTest {
    private SyncBeanManager syncBeanManager;
    private ActivityBeansInfo activityBeansInfo;
    private PreferenceFormBeansInfo preferenceFormBeansInfo;

    @Before
    public void setup() {
        this.syncBeanManager = (SyncBeanManager)Mockito.mock(SyncBeanManager.class);
        this.activityBeansInfo = new ActivityBeansInfo(){

            public SyncBeanManager getBeanManager() {
                return PreferenceFormBeansInfoTest.this.syncBeanManager;
            }
        };
        this.preferenceFormBeansInfo = new PreferenceFormBeansInfo(this.activityBeansInfo);
        Mockito.when((Object)this.syncBeanManager.lookupBeans(WorkbenchScreenActivity.class)).thenReturn(this.generateBeansList());
    }

    @Test
    public void getPreferenceFormForTest() {
        Assert.assertEquals((Object)"MyPreference1", (Object)this.preferenceFormBeansInfo.getPreferenceFormFor(MyPreference1.class));
        Assert.assertEquals((Object)"MyPreference2", (Object)this.preferenceFormBeansInfo.getPreferenceFormFor(MyPreference2.class));
        Assert.assertEquals((Object)"MyPreference3", (Object)this.preferenceFormBeansInfo.getPreferenceFormFor(MyPreference3.class));
    }

    private Collection<SyncBeanDef<WorkbenchScreenActivity>> generateBeansList() {
        ArrayList<SyncBeanDef<WorkbenchScreenActivity>> beans = new ArrayList<SyncBeanDef<WorkbenchScreenActivity>>();
        beans.add(this.generateBeanDef(null));
        beans.add(this.generateBeanDef(MyPreference1.class));
        beans.add(this.generateBeanDef(MyPreference2.class));
        beans.add(this.generateBeanDef(MyPreference3.class));
        return beans;
    }

    private SyncBeanDef<WorkbenchScreenActivity> generateBeanDef(final Class<? extends BasePreference> preferenceBeanClass) {
        return new SyncBeanDef<WorkbenchScreenActivity>(){

            public Class<WorkbenchScreenActivity> getType() {
                return null;
            }

            public Class<?> getBeanClass() {
                return null;
            }

            public Class<? extends Annotation> getScope() {
                return null;
            }

            public WorkbenchScreenActivity getInstance() {
                return null;
            }

            public WorkbenchScreenActivity newInstance() {
                return null;
            }

            public Set<Annotation> getQualifiers() {
                HashSet<Annotation> annotations = new HashSet<Annotation>();
                if (preferenceBeanClass != null) {
                    annotations.add((Annotation)new PreferenceForm(){

                        public Class<? extends Annotation> annotationType() {
                            return null;
                        }

                        public Class<? extends BasePreference> value() {
                            return preferenceBeanClass;
                        }
                    });
                    annotations.add((Annotation)new Named(){

                        public Class<? extends Annotation> annotationType() {
                            return null;
                        }

                        public String value() {
                            return preferenceBeanClass.getSimpleName();
                        }
                    });
                }
                return annotations;
            }

            public boolean matches(Set<Annotation> annotations) {
                return false;
            }

            public String getName() {
                if (preferenceBeanClass != null) {
                    return preferenceBeanClass.getSimpleName();
                }
                return null;
            }

            public boolean isActivated() {
                return false;
            }

            public boolean isAssignableTo(Class<?> type) {
                return WorkbenchScreenActivity.class.equals(type);
            }
        };
    }

    class MyPreference3
    implements BasePreference<MyPreference3> {
        MyPreference3() {
        }
    }

    class MyPreference2
    implements BasePreference<MyPreference2> {
        MyPreference2() {
        }
    }

    class MyPreference1
    implements BasePreference<MyPreference1> {
        MyPreference1() {
        }
    }
}

