/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.client.admin.page;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.enterprise.event.Event;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.preferences.client.admin.page.AdminPageImpl;
import org.uberfire.ext.preferences.client.admin.page.AdminTool;
import org.uberfire.ext.preferences.client.event.PreferencesCentralInitializationEvent;
import org.uberfire.ext.preferences.shared.impl.PreferenceScopeResolutionStrategyInfo;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@RunWith(value=MockitoJUnitRunner.class)
public class AdminPageImplTest {
    @Mock
    private PlaceManager placeManager;
    @Mock
    private Event<PreferencesCentralInitializationEvent> preferencesCentralInitializationEvent;
    private AdminPageImpl adminPage;

    @Before
    public void setup() {
        this.adminPage = new AdminPageImpl(this.placeManager, this.preferencesCentralInitializationEvent);
    }

    @Test
    public void addValidScreen() {
        this.adminPage.addScreen("screen", "title");
        Assert.assertEquals((Object)"title", (Object)this.adminPage.getScreenTitle("screen"));
    }

    @Test(expected=RuntimeException.class)
    public void addScreenWithNullIdentifierTest() {
        this.adminPage.addScreen(null, "title");
    }

    @Test
    public void addToolTest() {
        this.adminPage.addScreen("screen1", "Screen 1");
        this.adminPage.addScreen("screen2", "Screen 2");
        this.adminPage.addTool("screen1", "title1", "iconCss1", "category1", () -> {});
        this.adminPage.addTool("screen1", "title2", "iconCss2", "category1", () -> {});
        this.adminPage.addTool("screen1", "title3", "iconCss3", "category2", () -> {});
        this.adminPage.addTool("screen2", "title4", "iconCss4", "category3", () -> {});
        Map toolsByCategory1 = this.adminPage.getToolsByCategory("screen1");
        Assert.assertNotNull((Object)toolsByCategory1);
        Assert.assertEquals((long)2L, (long)toolsByCategory1.size());
        List category1Tools = (List)toolsByCategory1.get("category1");
        Assert.assertEquals((long)2L, (long)category1Tools.size());
        Assert.assertEquals((Object)"title1", (Object)((AdminTool)category1Tools.get(0)).getTitle());
        Assert.assertEquals((Object)"iconCss1", (Object)((AdminTool)category1Tools.get(0)).getIconCss());
        Assert.assertEquals((Object)"title2", (Object)((AdminTool)category1Tools.get(1)).getTitle());
        Assert.assertEquals((Object)"iconCss2", (Object)((AdminTool)category1Tools.get(1)).getIconCss());
        List category2Tools = (List)toolsByCategory1.get("category2");
        Assert.assertEquals((long)1L, (long)category2Tools.size());
        Assert.assertEquals((Object)"title3", (Object)((AdminTool)category2Tools.get(0)).getTitle());
        Assert.assertEquals((Object)"iconCss3", (Object)((AdminTool)category2Tools.get(0)).getIconCss());
        Map toolsByCategory2 = this.adminPage.getToolsByCategory("screen2");
        Assert.assertNotNull((Object)toolsByCategory2);
        Assert.assertEquals((long)1L, (long)toolsByCategory2.size());
        List category3Tools = (List)toolsByCategory2.get("category3");
        Assert.assertEquals((long)1L, (long)category3Tools.size());
        Assert.assertEquals((Object)"title4", (Object)((AdminTool)category3Tools.get(0)).getTitle());
        Assert.assertEquals((Object)"iconCss4", (Object)((AdminTool)category3Tools.get(0)).getIconCss());
    }

    @Test(expected=RuntimeException.class)
    public void addToolWithNullScreenTest() {
        this.adminPage.addTool(null, "title", "iconCss", null, () -> {});
    }

    @Test(expected=RuntimeException.class)
    public void addToolWithNullCategoryTest() {
        this.adminPage.addTool("screen", "title", "iconCss", null, () -> {});
    }

    @Test
    public void addPreferenceTest() {
        this.adminPage.addScreen("screen1", "Screen 1");
        this.adminPage.addPreference("screen1", "MyPreference", "My Preference", "fa-map", "category1", null);
        Map toolsByCategory1 = this.adminPage.getToolsByCategory("screen1");
        Assert.assertNotNull((Object)toolsByCategory1);
        Assert.assertEquals((long)1L, (long)toolsByCategory1.size());
        List category1Tools = (List)toolsByCategory1.get("category1");
        Assert.assertEquals((long)1L, (long)category1Tools.size());
        Assert.assertEquals((Object)"My Preference", (Object)((AdminTool)category1Tools.get(0)).getTitle());
        Assert.assertEquals((Object)"fa-map", (Object)((AdminTool)category1Tools.get(0)).getIconCss());
        ((AdminTool)category1Tools.get(0)).getOnClickCommand().execute();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)Matchers.eq((Object)new DefaultPlaceRequest("PreferencesCentralPerspective")));
        ((Event)Mockito.verify(this.preferencesCentralInitializationEvent)).fire(Matchers.eq((Object)new PreferencesCentralInitializationEvent("MyPreference", null)));
    }

    @Test
    public void addPreferenceWithCustomScopeResolutionStrategyParameterTest() {
        Supplier<PreferenceScopeResolutionStrategyInfo> scopeResolutionStrategyInfoSupplier = new Supplier<PreferenceScopeResolutionStrategyInfo>(){
            PreferenceScopeResolutionStrategyInfo scopeResolutionStrategyInfo = null;

            @Override
            public PreferenceScopeResolutionStrategyInfo get() {
                if (this.scopeResolutionStrategyInfo == null) {
                    this.scopeResolutionStrategyInfo = (PreferenceScopeResolutionStrategyInfo)Mockito.mock(PreferenceScopeResolutionStrategyInfo.class);
                }
                return this.scopeResolutionStrategyInfo;
            }
        };
        this.adminPage.addScreen("screen1", "Screen 1");
        this.adminPage.addPreference("screen1", "MyPreference", "My Preference", "fa-map", "category1", (Supplier)scopeResolutionStrategyInfoSupplier);
        Map toolsByCategory1 = this.adminPage.getToolsByCategory("screen1");
        Assert.assertNotNull((Object)toolsByCategory1);
        Assert.assertEquals((long)1L, (long)toolsByCategory1.size());
        List category1Tools = (List)toolsByCategory1.get("category1");
        Assert.assertEquals((long)1L, (long)category1Tools.size());
        Assert.assertEquals((Object)"My Preference", (Object)((AdminTool)category1Tools.get(0)).getTitle());
        Assert.assertEquals((Object)"fa-map", (Object)((AdminTool)category1Tools.get(0)).getIconCss());
        ((AdminTool)category1Tools.get(0)).getOnClickCommand().execute();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)Matchers.eq((Object)new DefaultPlaceRequest("PreferencesCentralPerspective")));
        ((Event)Mockito.verify(this.preferencesCentralInitializationEvent)).fire(Matchers.eq((Object)new PreferencesCentralInitializationEvent("MyPreference", (PreferenceScopeResolutionStrategyInfo)scopeResolutionStrategyInfoSupplier.get())));
    }

    @Test
    public void setDefaultScreen() {
        this.adminPage.setDefaultScreen("screen1");
        Assert.assertEquals((Object)"screen1", (Object)this.adminPage.getDefaultScreen());
        this.adminPage.setDefaultScreen("screen2");
        Assert.assertEquals((Object)"screen2", (Object)this.adminPage.getDefaultScreen());
    }
}

