/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.client.central.actions;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.event.Event;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.preferences.client.central.actions.PreferencesCentralActionsScreen;
import org.uberfire.ext.preferences.client.event.PreferencesCentralActionsConfigurationEvent;
import org.uberfire.ext.preferences.client.event.PreferencesCentralPreSaveEvent;
import org.uberfire.ext.preferences.client.event.PreferencesCentralSaveEvent;
import org.uberfire.ext.preferences.client.event.PreferencesCentralUndoChangesEvent;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;

public class PreferencesCentralActionsScreenTest {
    @Mock
    private PreferencesCentralActionsScreen.View view;
    @Mock
    private PlaceManager placeManager;
    @Mock
    private Event<PreferencesCentralPreSaveEvent> preSaveEvent;
    @Mock
    private Event<PreferencesCentralSaveEvent> saveEvent;
    @Mock
    private Event<PreferencesCentralUndoChangesEvent> undoChangesEvent;
    @Mock
    private Event<NotificationEvent> notification;
    private PreferencesCentralActionsScreen actionsScreen;
    private Map<String, String> params;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.actionsScreen = new PreferencesCentralActionsScreen(this.view, this.placeManager, this.preSaveEvent, this.saveEvent, this.undoChangesEvent, this.notification);
        this.params = new HashMap<String, String>();
        this.params.put("screen", "screen");
        this.actionsScreen.initEvent(new PreferencesCentralActionsConfigurationEvent("screen", null));
    }

    @Test
    public void fireSaveEventTest() {
        this.actionsScreen.fireSaveEvent();
        ((Event)Mockito.verify(this.preSaveEvent)).fire(Mockito.any(PreferencesCentralPreSaveEvent.class));
        ((Event)Mockito.verify(this.saveEvent)).fire(Mockito.any(PreferencesCentralSaveEvent.class));
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)Mockito.eq((Object)new DefaultPlaceRequest("AdminPagePerspective", this.params)));
    }

    @Test
    public void fireUndoEventTest() {
        this.actionsScreen.fireCancelEvent();
        ((Event)Mockito.verify(this.undoChangesEvent)).fire(Mockito.any(PreferencesCentralUndoChangesEvent.class));
        ((Event)Mockito.verify(this.notification)).fire(Mockito.any(NotificationEvent.class));
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)Mockito.eq((Object)new DefaultPlaceRequest("AdminPagePerspective", this.params)));
    }

    @Test
    public void goBackToAdminPageWithPerspectiveIdentifierToGoBackToTest() {
        this.actionsScreen.initEvent(new PreferencesCentralActionsConfigurationEvent("adminPage", "perspective"));
        this.actionsScreen.goBackToAdminPage();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("screen", "adminPage");
        params.put("perspectiveIdentifierToGoBackTo", "perspective");
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)new DefaultPlaceRequest("AdminPagePerspective", params));
    }

    @Test
    public void goBackToAdminPageWithoutPerspectiveIdentifierToGoBackToTest() {
        this.actionsScreen.initEvent(new PreferencesCentralActionsConfigurationEvent("adminPage", null));
        this.actionsScreen.goBackToAdminPage();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("screen", "adminPage");
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)new DefaultPlaceRequest("AdminPagePerspective", params));
    }
}

