/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.client.central.tree;

import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.preferences.client.central.hierarchy.HierarchyItemView;
import org.uberfire.ext.preferences.client.central.hierarchy.HierarchyLeafItemPresenter;
import org.uberfire.ext.preferences.client.event.HierarchyItemSelectedEvent;
import org.uberfire.ext.preferences.shared.bean.PreferenceHierarchyElement;

public class TreeHierarchyLeafItemPresenter
implements HierarchyLeafItemPresenter {
    private final View view;
    private final Event<HierarchyItemSelectedEvent> hierarchyItemSelectedEvent;
    private PreferenceHierarchyElement<?> hierarchyElement;
    private int level;

    @Inject
    public TreeHierarchyLeafItemPresenter(View view, Event<HierarchyItemSelectedEvent> hierarchyItemSelectedEvent) {
        this.view = view;
        this.hierarchyItemSelectedEvent = hierarchyItemSelectedEvent;
    }

    @Override
    public <T> void init(PreferenceHierarchyElement<T> preference, int level, boolean tryToSelectChild) {
        this.hierarchyElement = preference;
        this.level = level;
        this.view.init(this);
    }

    @Override
    public void fireSelect() {
        this.view.select();
    }

    public void select() {
        if (this.hierarchyElement.isSelectable()) {
            HierarchyItemSelectedEvent event = new HierarchyItemSelectedEvent(this.hierarchyElement);
            this.hierarchyItemSelectedEvent.fire((Object)event);
            this.view.selectElement();
        }
    }

    public void itemSelectedEvent(@Observes HierarchyItemSelectedEvent event) {
        if (!this.hierarchyElement.getId().equals(event.getItemId())) {
            this.view.deselect();
        }
    }

    @Override
    public View getView() {
        return this.view;
    }

    public PreferenceHierarchyElement<?> getHierarchyElement() {
        return this.hierarchyElement;
    }

    public int getLevel() {
        return this.level;
    }

    public static interface View
    extends HierarchyItemView,
    UberElement<TreeHierarchyLeafItemPresenter> {
        public void select();

        public void selectElement();
    }
}

