/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.client.admin;

import java.util.HashMap;
import javax.enterprise.event.Event;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.preferences.client.admin.AdminPagePresenter;
import org.uberfire.ext.preferences.client.admin.category.AdminPageCategoryPresenter;
import org.uberfire.ext.preferences.client.admin.page.AdminPage;
import org.uberfire.ext.preferences.client.admin.page.AdminPageImpl;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;

public class AdminPagePresenterTest {
    private AdminPagePresenter.View view;
    private AdminPage adminPage;
    private ManagedInstance<AdminPageCategoryPresenter> categoryPresenterProvider;
    private Event<NotificationEvent> notification;
    private AdminPagePresenter presenter;

    @Before
    public void setup() {
        this.view = (AdminPagePresenter.View)Mockito.mock(AdminPagePresenter.View.class);
        this.adminPage = new AdminPageImpl();
        this.categoryPresenterProvider = (ManagedInstance)Mockito.mock(ManagedInstance.class);
        this.notification = (Event)Mockito.mock(EventSourceMock.class);
        this.presenter = (AdminPagePresenter)Mockito.spy((Object)new AdminPagePresenter(this.view, this.adminPage, this.categoryPresenterProvider, this.notification));
    }

    @Test
    public void onStartupWithScreenTest() {
        ((AdminPagePresenter)Mockito.doNothing().when((Object)this.presenter)).init(Mockito.anyString());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("screen", "my-screen");
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest("AdminPagePresenter", params);
        this.presenter.onStartup((PlaceRequest)placeRequest);
        ((AdminPagePresenter.View)Mockito.verify((Object)this.view)).init((Object)this.presenter);
        ((Event)Mockito.verify(this.notification, (VerificationMode)Mockito.never())).fire(Mockito.any(NotificationEvent.class));
        ((AdminPagePresenter)Mockito.verify((Object)this.presenter)).init("my-screen");
    }

    @Test
    public void onStartupWithoutScreenTest() {
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest("AdminPagePresenter");
        this.presenter.onStartup((PlaceRequest)placeRequest);
        ((AdminPagePresenter.View)Mockito.verify((Object)this.view)).init((Object)this.presenter);
        ((Event)Mockito.verify(this.notification)).fire(Mockito.any(NotificationEvent.class));
        ((AdminPagePresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).init(Mockito.anyString());
    }

    @Test
    public void initWithNotAddedScreenTest() {
        this.presenter.init("not-added-screen");
        ((Event)Mockito.verify(this.notification)).fire(Mockito.any(NotificationEvent.class));
    }

    @Test
    public void initWithAddedScreenTest() {
        this.adminPage.addScreen("added-screen", "Screen title");
        this.presenter.init("added-screen");
        ((Event)Mockito.verify(this.notification, (VerificationMode)Mockito.never())).fire(Mockito.any(NotificationEvent.class));
    }
}

