/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.client.base;

import java.util.HashMap;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.preferences.client.base.BasePreferenceForm;
import org.uberfire.ext.preferences.client.event.HierarchyItemFormInitializationEvent;
import org.uberfire.ext.preferences.client.event.PreferencesCentralPreSaveEvent;
import org.uberfire.ext.preferences.client.event.PreferencesCentralUndoChangesEvent;
import org.uberfire.ext.preferences.shared.bean.BasePreferencePortable;
import org.uberfire.ext.preferences.shared.bean.PreferenceHierarchyElement;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

public class BasePreferenceFormTest {
    private BasePreferenceForm<Object> basePreferenceForm;

    @Before
    public void setup() {
        this.basePreferenceForm = (BasePreferenceForm)Mockito.spy(this.getBasePreferenceForm());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", "preference-id");
        this.basePreferenceForm.onStartup((PlaceRequest)new DefaultPlaceRequest("preferenceForm", params));
    }

    @Test
    public void initIsCalledWhenFormIdIsRequested() {
        BasePreferencePortable preference = (BasePreferencePortable)Mockito.mock(BasePreferencePortable.class);
        PreferenceHierarchyElement hierarchyElement = new PreferenceHierarchyElement();
        hierarchyElement.setId("preference-id");
        hierarchyElement.setPortablePreference(preference);
        HierarchyItemFormInitializationEvent event = new HierarchyItemFormInitializationEvent(hierarchyElement);
        this.basePreferenceForm.hierarchyItemFormInitializationEvent(event);
        ((BasePreferenceForm)Mockito.verify(this.basePreferenceForm)).init((Object)preference);
    }

    @Test
    public void initIsNotCalledWhenDifferentFormIdIsRequested() {
        BasePreferencePortable preference = (BasePreferencePortable)Mockito.mock(BasePreferencePortable.class);
        PreferenceHierarchyElement hierarchyElement = new PreferenceHierarchyElement();
        hierarchyElement.setId("another-preference-id");
        hierarchyElement.setPortablePreference(preference);
        HierarchyItemFormInitializationEvent event = new HierarchyItemFormInitializationEvent(hierarchyElement);
        this.basePreferenceForm.hierarchyItemFormInitializationEvent(event);
        ((BasePreferenceForm)Mockito.verify(this.basePreferenceForm, (VerificationMode)Mockito.never())).init(Mockito.any(BasePreferencePortable.class));
    }

    @Test
    public void beforeSaveIsCalledWhenPreSaveEventIsObserved() {
        PreferencesCentralPreSaveEvent event = new PreferencesCentralPreSaveEvent();
        this.basePreferenceForm.preSaveEvent(event);
        ((BasePreferenceForm)Mockito.verify(this.basePreferenceForm)).beforeSave();
    }

    @Test
    public void onUndoIsCalledWhenUndoEventIsObserved() {
        PreferencesCentralUndoChangesEvent event = new PreferencesCentralUndoChangesEvent();
        this.basePreferenceForm.undoChangesEvent(event);
        ((BasePreferenceForm)Mockito.verify(this.basePreferenceForm)).onUndo();
    }

    private BasePreferenceForm<Object> getBasePreferenceForm() {
        return new BasePreferenceForm<Object>(){

            public void init(Object preference) {
            }

            public void beforeSave() {
            }

            public void onUndo() {
            }
        };
    }
}

