/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.client.central.form;

import java.util.HashMap;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.preferences.client.central.form.DefaultPreferenceForm;
import org.uberfire.ext.preferences.client.event.HierarchyItemFormInitializationEvent;
import org.uberfire.ext.preferences.shared.bean.BasePreferencePortable;
import org.uberfire.ext.preferences.shared.bean.PreferenceHierarchyElement;
import org.uberfire.ext.preferences.shared.bean.mock.PortablePreferenceMock;
import org.uberfire.ext.preferences.shared.bean.mock.PortablePreferenceMockPortableGeneratedImpl;
import org.uberfire.ext.properties.editor.model.PropertyEditorChangeEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

public class DefaultPreferenceFormTest {
    private BasePreferencePortable<PortablePreferenceMock> preference;
    private DefaultPreferenceForm.View formView;
    private DefaultPreferenceForm formPresenter;

    @Before
    public void setup() {
        TranslationService translationService = (TranslationService)Mockito.mock(TranslationService.class);
        this.preference = (BasePreferencePortable)Mockito.spy((Object)new PortablePreferenceMockPortableGeneratedImpl());
        this.formView = (DefaultPreferenceForm.View)Mockito.mock(DefaultPreferenceForm.View.class);
        this.formPresenter = new DefaultPreferenceForm(this.formView, translationService);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", "preference-id");
        this.formPresenter.onStartup((PlaceRequest)new DefaultPlaceRequest("preferenceForm", params));
    }

    @Test
    public void testFormShouldBeInitializedWhenEventWithSameIdIsObserved() {
        this.fireInitializationEvent("preference-id");
        ((DefaultPreferenceForm.View)Mockito.verify((Object)this.formView)).init((Object)this.formPresenter);
    }

    @Test
    public void testFormShouldNotBeInitializedWhenEventWithDifferentIdIsObserved() {
        this.fireInitializationEvent("another-preference-id");
        ((DefaultPreferenceForm.View)Mockito.verify((Object)this.formView, (VerificationMode)Mockito.never())).init((Object)this.formPresenter);
    }

    @Test
    public void testPropertyChangedInThisFormShouldSetThePreferenceProperty() {
        this.fireInitializationEvent("preference-id");
        this.firePropertyChangedEvent("preference-id");
        ((BasePreferencePortable)Mockito.verify(this.preference)).set("property", (Object)"newValue");
    }

    @Test
    public void testPropertyChangedInAnotherFormShouldNotSetThePreferenceProperty() {
        this.fireInitializationEvent("preference-id");
        this.firePropertyChangedEvent("another-preference-id");
        ((BasePreferencePortable)Mockito.verify(this.preference, (VerificationMode)Mockito.never())).set("property", (Object)"newValue");
    }

    private void firePropertyChangedEvent(String eventId) {
        PropertyEditorFieldInfo propertyInfo = (PropertyEditorFieldInfo)Mockito.mock(PropertyEditorFieldInfo.class);
        ((PropertyEditorFieldInfo)Mockito.doReturn((Object)eventId).when((Object)propertyInfo)).getEventId();
        ((PropertyEditorFieldInfo)Mockito.doReturn((Object)"property").when((Object)propertyInfo)).getKey();
        this.formPresenter.propertyChanged(new PropertyEditorChangeEvent(propertyInfo, "newValue"));
    }

    private void fireInitializationEvent(String eventId) {
        PreferenceHierarchyElement preferenceHierarchyElement = new PreferenceHierarchyElement();
        preferenceHierarchyElement.setId(eventId);
        preferenceHierarchyElement.setPortablePreference(this.preference);
        HierarchyItemFormInitializationEvent event = new HierarchyItemFormInitializationEvent(preferenceHierarchyElement);
        this.formPresenter.hierarchyItemFormInitializationEvent(event);
    }
}

