/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.client.central;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.client.annotations.Perspective;
import org.uberfire.client.annotations.WorkbenchPerspective;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.docks.UberfireDockReadyEvent;
import org.uberfire.client.workbench.docks.UberfireDocks;
import org.uberfire.client.workbench.panels.impl.MultiListWorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.impl.StaticWorkbenchPanelPresenter;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.PerspectiveDefinition;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.impl.PanelDefinitionImpl;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;
import org.uberfire.workbench.model.impl.PerspectiveDefinitionImpl;

@ApplicationScoped
@WorkbenchPerspective(identifier="PreferencesCentralPerspective")
public class PreferencesCentralPerspective {
    public static final String IDENTIFIER = "PreferencesCentralPerspective";
    @Inject
    private TranslationService translationService;
    @Inject
    private UberfireDocks uberfireDocks;
    private UberfireDock dock;
    private PerspectiveDefinition perspective;

    public void perspectiveChangeEvent(@Observes UberfireDockReadyEvent dockReadyEvent) {
        if (dockReadyEvent.getCurrentPerspective().equals(IDENTIFIER)) {
            this.uberfireDocks.expand(this.dock);
        }
    }

    @Perspective
    public PerspectiveDefinition getPerspective() {
        return this.buildPerspective();
    }

    PerspectiveDefinition buildPerspective() {
        PerspectiveDefinitionImpl perspective = new PerspectiveDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        perspective.setName("Preferences");
        PanelDefinitionImpl actionsBar = new PanelDefinitionImpl(StaticWorkbenchPanelPresenter.class.getName());
        actionsBar.setHeight(80);
        actionsBar.addPart((PartDefinition)new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("PreferencesCentralActionsScreen")));
        perspective.getRoot().insertChild((Position)CompassPosition.SOUTH, (PanelDefinition)actionsBar);
        return perspective;
    }

    @PostConstruct
    public void setupNavBarDock() {
        this.dock = new UberfireDock(UberfireDockPosition.WEST, "ADJUST", (PlaceRequest)new DefaultPlaceRequest("PreferencesCentralNavBarScreen"), IDENTIFIER).withLabel(this.translationService.format("PreferencesCentralPerspective.Preferences", new Object[0])).withSize(420.0);
        this.uberfireDocks.add(new UberfireDock[]{this.dock});
    }
}

