/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.client.central.tree;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.user.client.DOM;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.ext.preferences.client.central.tree.TreeHierarchyInternalItemPresenter;

@Dependent
@Templated
public class TreeHierarchyInternalItemView
implements IsElement,
TreeHierarchyInternalItemPresenter.View {
    private TreeHierarchyInternalItemPresenter presenter;
    @Inject
    private TranslationService translationService;
    @DataField(value="preference-tree-internal-item-label")
    Element label = DOM.createLabel();
    @Inject
    @DataField(value="preference-tree-internal-item-node")
    Div treeNode;
    @Inject
    @DataField(value="preference-tree-internal-item-children")
    Div children;
    @DataField(value="preference-tree-internal-item-expand-icon")
    Element expandIcon = DOM.createElement((String)"i");
    @DataField(value="preference-tree-internal-item-contract-icon")
    Element contractIcon = DOM.createElement((String)"i");

    public void init(TreeHierarchyInternalItemPresenter presenter) {
        this.presenter = presenter;
        String preferenceLabel = this.getPreferenceLabel(presenter.getHierarchyElement().getBundleKey());
        this.label.setInnerHTML(preferenceLabel);
        this.treeNode.getStyle().setProperty("padding-left", presenter.getLevel() * 27 + 8 + "px");
        presenter.getHierarchyItems().forEach(hierarchyItem -> this.children.appendChild((Node)((IsElement)hierarchyItem.getView()).getElement()));
    }

    @Override
    public void deselect() {
        this.treeNode.getClassList().remove("selected");
    }

    @EventHandler(value={"preference-tree-internal-item-expand-icon"})
    public void expand(ClickEvent event) {
        this.expand();
    }

    @EventHandler(value={"preference-tree-internal-item-contract-icon"})
    public void contract(ClickEvent event) {
        this.contract();
    }

    @EventHandler(value={"preference-tree-internal-item-label"})
    public void select(ClickEvent event) {
        this.select();
    }

    @EventHandler(value={"preference-tree-internal-item-label"})
    public void contractExpand(DoubleClickEvent event) {
        if (!this.children.getHidden()) {
            this.contract();
        } else {
            this.expand();
        }
    }

    private void expand() {
        this.expandIcon.addClassName("hidden");
        this.contractIcon.removeClassName("hidden");
        this.children.setHidden(false);
    }

    private void contract() {
        this.expandIcon.removeClassName("hidden");
        this.contractIcon.addClassName("hidden");
        this.children.setHidden(true);
    }

    @Override
    public void select() {
        if (!this.label.hasClassName("selected")) {
            this.presenter.select();
        }
    }

    @Override
    public void selectElement() {
        this.treeNode.getClassList().add("selected");
    }

    private String getPreferenceLabel(String bundleKey) {
        return this.translationService.format(bundleKey, new Object[0]);
    }
}

