/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.processors;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.uberfire.annotations.processors.GeneratorUtils;
import org.uberfire.annotations.processors.exceptions.GenerationException;
import org.uberfire.ext.preferences.processors.AbstractGenerator;
import org.uberfire.ext.preferences.processors.GeneratorContext;
import org.uberfire.ext.preferences.processors.PropertyData;
import org.uberfire.ext.preferences.relocated.freemarker.template.Template;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateException;
import org.uberfire.ext.preferences.shared.annotations.Property;
import org.uberfire.ext.preferences.shared.annotations.WorkbenchPreference;

public class WorkbenchPreferenceGeneratedImplGenerator
extends AbstractGenerator {
    private GeneratorContext generatorContext;
    private String targetClassName = null;

    public WorkbenchPreferenceGeneratedImplGenerator(GeneratorContext generatorContext) {
        this.generatorContext = generatorContext;
    }

    @Override
    public StringBuffer generate(String packageName, PackageElement packageElement, String className, Element element, ProcessingEnvironment processingEnvironment) throws GenerationException {
        Messager messager = processingEnvironment.getMessager();
        messager.printMessage(Diagnostic.Kind.NOTE, "Starting code generation for [" + className + "]");
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeElement classElement = (TypeElement)element;
        WorkbenchPreference annotation = element.getAnnotation(WorkbenchPreference.class);
        boolean rootPreference = annotation.root();
        String preferenceBundleKey = annotation.bundleKey();
        String sourcePackage = packageName;
        String sourceClassName = className;
        String preferenceKey = packageName + "." + className;
        String targetPackage = packageName;
        if (GeneratorContext.BEAN.equals((Object)this.generatorContext)) {
            this.targetClassName = className + "BeanGeneratedImpl";
        } else if (GeneratorContext.PORTABLE.equals((Object)this.generatorContext)) {
            this.targetClassName = className + "PortableGeneratedImpl";
        }
        ArrayList properties = new ArrayList();
        TypeElement c = classElement;
        c.getEnclosedElements().forEach(el -> {
            Property propertyAnnotation = el.getAnnotation(Property.class);
            if (propertyAnnotation != null) {
                properties.add(new PropertyData((Element)el, propertyAnnotation, elementUtils));
            }
        });
        List simpleProperties = properties.stream().filter(p -> !p.isSubPreference()).collect(Collectors.toList());
        List subPreferences = properties.stream().filter(p -> p.isSubPreference()).collect(Collectors.toList());
        List nonInheritedSubPreferences = subPreferences.stream().filter(p -> !p.isInherited()).collect(Collectors.toList());
        List inheritedSubPreferences = subPreferences.stream().filter(p -> p.isInherited()).collect(Collectors.toList());
        List constructorParams = properties.stream().map(p -> "@MapsTo(\"" + p.getFieldName() + "\") " + p.getTypeFullName() + " " + p.getFieldName()).collect(Collectors.toList());
        String constructorParamsText = String.join((CharSequence)", ", constructorParams);
        List propertyFields = properties.stream().map(PropertyData::getFieldName).collect(Collectors.toList());
        String propertyFieldsText = String.join((CharSequence)", ", propertyFields);
        if (GeneratorUtils.debugLoggingEnabled()) {
            List simplePropertiesNames = simpleProperties.stream().map(PropertyData::getFieldName).collect(Collectors.toList());
            String simplePropertiesText = String.join((CharSequence)", ", simplePropertiesNames);
            List subPreferencesNames = subPreferences.stream().map(PropertyData::getFieldName).collect(Collectors.toList());
            String subPreferencesText = String.join((CharSequence)", ", subPreferencesNames);
            List inheritedSubPreferencesNames = inheritedSubPreferences.stream().map(PropertyData::getFieldName).collect(Collectors.toList());
            String inheritedSubPreferencesText = String.join((CharSequence)", ", inheritedSubPreferencesNames);
            List nonInheritedSubPreferencesNames = nonInheritedSubPreferences.stream().map(PropertyData::getFieldName).collect(Collectors.toList());
            String nonInheritedSubPreferencesText = String.join((CharSequence)", ", nonInheritedSubPreferencesNames);
            messager.printMessage(Diagnostic.Kind.NOTE, "Source package name: " + sourcePackage);
            messager.printMessage(Diagnostic.Kind.NOTE, "Source class name: " + sourceClassName);
            messager.printMessage(Diagnostic.Kind.NOTE, "Target package name: " + targetPackage);
            messager.printMessage(Diagnostic.Kind.NOTE, "Target class name: " + this.targetClassName);
            messager.printMessage(Diagnostic.Kind.NOTE, "Preference key: " + preferenceKey);
            messager.printMessage(Diagnostic.Kind.NOTE, "Property fields: " + propertyFieldsText);
            messager.printMessage(Diagnostic.Kind.NOTE, "Simple properties fields: " + simplePropertiesText);
            messager.printMessage(Diagnostic.Kind.NOTE, "Sub-preferences fields: " + subPreferencesText);
            messager.printMessage(Diagnostic.Kind.NOTE, "Inherited subPreferences fields: " + inheritedSubPreferencesText);
            messager.printMessage(Diagnostic.Kind.NOTE, "Non-inherited subPreferences fields: " + nonInheritedSubPreferencesText);
            messager.printMessage(Diagnostic.Kind.NOTE, "Constructor parameters: " + constructorParamsText);
        }
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("sourcePackage", sourcePackage);
        root.put("sourceClassName", sourceClassName);
        root.put("targetPackage", targetPackage);
        root.put("targetClassName", this.targetClassName);
        root.put("preferenceKey", preferenceKey);
        root.put("rootPreference", rootPreference);
        root.put("preferenceBundleKey", preferenceBundleKey);
        root.put("properties", properties);
        root.put("simpleProperties", simpleProperties);
        root.put("subPreferences", subPreferences);
        root.put("inheritedSubPreferences", inheritedSubPreferences);
        root.put("nonInheritedSubPreferences", nonInheritedSubPreferences);
        root.put("constructorParamsText", constructorParamsText);
        root.put("propertyFieldsText", propertyFieldsText);
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        try {
            Template template = null;
            if (GeneratorContext.BEAN.equals((Object)this.generatorContext)) {
                template = this.config.getTemplate("workbenchPreferenceBean.ftl");
            } else if (GeneratorContext.PORTABLE.equals((Object)this.generatorContext)) {
                template = this.config.getTemplate("workbenchPreferencePortable.ftl");
            }
            if (template != null) {
                template.process(root, bw);
            }
        }
        catch (IOException ioe) {
            throw new GenerationException((Throwable)ioe);
        }
        catch (TemplateException te) {
            throw new GenerationException((Throwable)te);
        }
        finally {
            try {
                bw.close();
                sw.close();
            }
            catch (IOException ioe) {
                throw new GenerationException((Throwable)ioe);
            }
        }
        messager.printMessage(Diagnostic.Kind.NOTE, "Successfully generated code for [" + className + "]");
        return sw.getBuffer();
    }

    public String getTargetClassName() {
        return this.targetClassName;
    }
}

