/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.relocated.freemarker.core;

import java.util.Date;
import org.uberfire.ext.preferences.relocated.freemarker.core.ArithmeticEngine;
import org.uberfire.ext.preferences.relocated.freemarker.core.BooleanExpression;
import org.uberfire.ext.preferences.relocated.freemarker.core.Environment;
import org.uberfire.ext.preferences.relocated.freemarker.core.EvaluationUtil;
import org.uberfire.ext.preferences.relocated.freemarker.core.Expression;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateBooleanModel;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateDateModel;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateException;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateModel;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateNumberModel;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateScalarModel;

final class ComparisonExpression
extends BooleanExpression {
    static final int EQUALS = 1;
    static final int NOT_EQUALS = 2;
    static final int LESS_THAN = 3;
    static final int GREATER_THAN = 4;
    static final int LESS_THAN_EQUALS = 5;
    static final int GREATER_THAN_EQUALS = 6;
    private final Expression left;
    private final Expression right;
    private final int operation;
    private final String opString;

    ComparisonExpression(Expression left, Expression right, String opString) {
        this.left = left;
        this.right = right;
        this.opString = opString = opString.intern();
        if (opString == "==" || opString == "=") {
            this.operation = 1;
        } else if (opString == "!=") {
            this.operation = 2;
        } else if (opString == "gt" || opString == "\\gt" || opString == ">" || opString == "&gt;") {
            this.operation = 4;
        } else if (opString == "gte" || opString == "\\gte" || opString == ">=" || opString == "&gt;=") {
            this.operation = 6;
        } else if (opString == "lt" || opString == "\\lt" || opString == "<" || opString == "&lt;") {
            this.operation = 3;
        } else if (opString == "lte" || opString == "\\lte" || opString == "<=" || opString == "&lt;=") {
            this.operation = 5;
        } else {
            throw new RuntimeException("Unknown comparison operator " + opString);
        }
    }

    boolean isTrue(Environment env) throws TemplateException {
        TemplateModel ltm = this.left.getAsTemplateModel(env);
        TemplateModel rtm = this.right.getAsTemplateModel(env);
        if (env != null && env.isClassicCompatible()) {
            if (ltm == null) {
                ltm = TemplateScalarModel.EMPTY_STRING;
            }
            if (rtm == null) {
                rtm = TemplateScalarModel.EMPTY_STRING;
            }
        }
        ComparisonExpression.assertNonNull(ltm, this.left, env);
        ComparisonExpression.assertNonNull(rtm, this.right, env);
        int comp = 0;
        if (ltm instanceof TemplateNumberModel && rtm instanceof TemplateNumberModel) {
            Number first = EvaluationUtil.getNumber((TemplateNumberModel)ltm, this.left, env);
            Number second = EvaluationUtil.getNumber((TemplateNumberModel)rtm, this.right, env);
            ArithmeticEngine ae = env != null ? env.getArithmeticEngine() : this.getTemplate().getArithmeticEngine();
            comp = ae.compareNumbers(first, second);
        } else if (ltm instanceof TemplateDateModel && rtm instanceof TemplateDateModel) {
            int rtype;
            TemplateDateModel ltdm = (TemplateDateModel)ltm;
            TemplateDateModel rtdm = (TemplateDateModel)rtm;
            int ltype = ltdm.getDateType();
            if (ltype != (rtype = rtdm.getDateType())) {
                throw new TemplateException("Can not compare dates of different type. Left date is of " + TemplateDateModel.TYPE_NAMES.get(ltype) + " type, right date is of " + TemplateDateModel.TYPE_NAMES.get(rtype) + " type.", env);
            }
            if (ltype == 0) {
                throw new TemplateException("Left date is of UNKNOWN type, and can not be compared.", env);
            }
            if (rtype == 0) {
                throw new TemplateException("Right date is of UNKNOWN type, and can not be compared.", env);
            }
            Date first = EvaluationUtil.getDate(ltdm, this.left, env);
            Date second = EvaluationUtil.getDate(rtdm, this.right, env);
            comp = first.compareTo(second);
        } else if (ltm instanceof TemplateScalarModel && rtm instanceof TemplateScalarModel) {
            if (this.operation != 1 && this.operation != 2) {
                throw new TemplateException("Can not use operator " + this.opString + " on string values.", env);
            }
            String first = EvaluationUtil.getString((TemplateScalarModel)ltm, this.left, env);
            String second = EvaluationUtil.getString((TemplateScalarModel)rtm, this.right, env);
            comp = env.getCollator().compare(first, second);
        } else if (ltm instanceof TemplateBooleanModel && rtm instanceof TemplateBooleanModel) {
            if (this.operation != 1 && this.operation != 2) {
                throw new TemplateException("Can not use operator " + this.opString + " on boolean values.", env);
            }
            boolean first = ((TemplateBooleanModel)ltm).getAsBoolean();
            boolean second = ((TemplateBooleanModel)rtm).getAsBoolean();
            comp = (first ? 1 : 0) - (second ? 1 : 0);
        } else if (env.isClassicCompatible()) {
            String first = this.left.getStringValue(env);
            String second = this.right.getStringValue(env);
            comp = env.getCollator().compare(first, second);
        } else {
            throw new TemplateException("The only legal comparisons are between two numbers, two strings, or two dates.\nLeft  hand operand is a " + ltm.getClass().getName() + "\n" + "Right hand operand is a " + rtm.getClass().getName() + "\n", env);
        }
        switch (this.operation) {
            case 1: {
                return comp == 0;
            }
            case 2: {
                return comp != 0;
            }
            case 3: {
                return comp < 0;
            }
            case 4: {
                return comp > 0;
            }
            case 5: {
                return comp <= 0;
            }
            case 6: {
                return comp >= 0;
            }
        }
        throw new TemplateException("unknown operation", env);
    }

    public String getCanonicalForm() {
        return this.left.getCanonicalForm() + ' ' + this.opString + ' ' + this.right.getCanonicalForm();
    }

    boolean isLiteral() {
        return this.constantValue != null || this.left.isLiteral() && this.right.isLiteral();
    }

    Expression _deepClone(String name, Expression subst) {
        return new ComparisonExpression(this.left.deepClone(name, subst), this.right.deepClone(name, subst), this.opString);
    }
}

