/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.relocated.freemarker.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import org.uberfire.ext.preferences.relocated.freemarker.core.CollectionAndSequence;
import org.uberfire.ext.preferences.relocated.freemarker.core.Environment;
import org.uberfire.ext.preferences.relocated.freemarker.core.Expression;
import org.uberfire.ext.preferences.relocated.freemarker.core.TemplateObject;
import org.uberfire.ext.preferences.relocated.freemarker.template.SimpleSequence;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateCollectionModel;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateException;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateHashModelEx;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateModel;

final class HashLiteral
extends Expression {
    private final ArrayList keys;
    private final ArrayList values;
    private final int size;

    HashLiteral(ArrayList keys, ArrayList values) {
        this.keys = keys;
        this.values = values;
        this.size = keys.size();
        keys.trimToSize();
        values.trimToSize();
    }

    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        return new SequenceHash(env);
    }

    public String getCanonicalForm() {
        StringBuffer buf = new StringBuffer("{");
        for (int i = 0; i < this.size; ++i) {
            Expression key = (Expression)this.keys.get(i);
            Expression value = (Expression)this.values.get(i);
            buf.append(key.getCanonicalForm());
            buf.append(" : ");
            buf.append(value.getCanonicalForm());
            if (i == this.size - 1) continue;
            buf.append(",");
        }
        buf.append("}");
        return buf.toString();
    }

    boolean isLiteral() {
        if (this.constantValue != null) {
            return true;
        }
        for (int i = 0; i < this.size; ++i) {
            Expression key = (Expression)this.keys.get(i);
            Expression value = (Expression)this.values.get(i);
            if (key.isLiteral() && value.isLiteral()) continue;
            return false;
        }
        return true;
    }

    Expression _deepClone(String name, Expression subst) {
        ArrayList clonedKeys = (ArrayList)this.keys.clone();
        ListIterator<Expression> iter = clonedKeys.listIterator();
        while (iter.hasNext()) {
            iter.set(((Expression)iter.next()).deepClone(name, subst));
        }
        ArrayList clonedValues = (ArrayList)this.values.clone();
        ListIterator<Expression> iter2 = clonedValues.listIterator();
        while (iter2.hasNext()) {
            iter2.set(((Expression)iter2.next()).deepClone(name, subst));
        }
        return new HashLiteral(clonedKeys, clonedValues);
    }

    private class SequenceHash
    implements TemplateHashModelEx {
        private HashMap keyMap = new HashMap();
        private TemplateCollectionModel keyCollection;
        private TemplateCollectionModel valueCollection;

        SequenceHash(Environment env) throws TemplateException {
            ArrayList<String> keyList = new ArrayList<String>(HashLiteral.this.size);
            ArrayList<TemplateModel> valueList = new ArrayList<TemplateModel>(HashLiteral.this.size);
            for (int i = 0; i < HashLiteral.this.size; ++i) {
                Expression keyExp = (Expression)HashLiteral.this.keys.get(i);
                Expression valExp = (Expression)HashLiteral.this.values.get(i);
                String key = keyExp.getStringValue(env);
                TemplateModel value = valExp.getAsTemplateModel(env);
                TemplateObject.assertNonNull(value, valExp, env);
                this.keyMap.put(key, value);
                keyList.add(key);
                valueList.add(value);
            }
            this.keyCollection = new CollectionAndSequence(new SimpleSequence(keyList));
            this.valueCollection = new CollectionAndSequence(new SimpleSequence(valueList));
        }

        public int size() {
            return HashLiteral.this.size;
        }

        public TemplateCollectionModel keys() {
            return this.keyCollection;
        }

        public TemplateCollectionModel values() {
            return this.valueCollection;
        }

        public TemplateModel get(String key) {
            return (TemplateModel)this.keyMap.get(key);
        }

        public boolean isEmpty() {
            return HashLiteral.this.size == 0;
        }
    }
}

