/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.relocated.freemarker.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.uberfire.ext.preferences.relocated.freemarker.core.BlockAssignment;
import org.uberfire.ext.preferences.relocated.freemarker.core.Environment;
import org.uberfire.ext.preferences.relocated.freemarker.core.Macro;
import org.uberfire.ext.preferences.relocated.freemarker.core.MixedContent;
import org.uberfire.ext.preferences.relocated.freemarker.core.ParseException;
import org.uberfire.ext.preferences.relocated.freemarker.core.TemplateObject;
import org.uberfire.ext.preferences.relocated.freemarker.template.SimpleSequence;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateException;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateNodeModel;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateSequenceModel;
import org.uberfire.ext.preferences.relocated.freemarker.template.utility.Collections12;

public abstract class TemplateElement
extends TemplateObject
implements TreeNode {
    TemplateElement parent;
    TemplateElement nestedBlock;
    List nestedElements;

    abstract void accept(Environment var1) throws TemplateException, IOException;

    public abstract String getDescription();

    public TemplateNodeModel getParentNode() {
        return null;
    }

    public String getNodeNamespace() {
        return null;
    }

    public String getNodeType() {
        return "element";
    }

    public TemplateSequenceModel getChildNodes() {
        if (this.nestedElements != null) {
            return new SimpleSequence(this.nestedElements);
        }
        SimpleSequence result = new SimpleSequence();
        if (this.nestedBlock != null) {
            result.add(this.nestedBlock);
        }
        return result;
    }

    public String getNodeName() {
        String classname = this.getClass().getName();
        int shortNameOffset = classname.lastIndexOf(46) + 1;
        return classname.substring(shortNameOffset);
    }

    public boolean isLeaf() {
        return this.nestedBlock == null && (this.nestedElements == null || this.nestedElements.isEmpty());
    }

    public boolean getAllowsChildren() {
        return !this.isLeaf();
    }

    public int getIndex(TreeNode node) {
        if (this.nestedBlock instanceof MixedContent) {
            return this.nestedBlock.getIndex(node);
        }
        if (this.nestedBlock != null) {
            if (node == this.nestedBlock) {
                return 0;
            }
        } else if (this.nestedElements != null) {
            return this.nestedElements.indexOf(node);
        }
        return -1;
    }

    public int getChildCount() {
        if (this.nestedBlock instanceof MixedContent) {
            return this.nestedBlock.getChildCount();
        }
        if (this.nestedBlock != null) {
            return 1;
        }
        if (this.nestedElements != null) {
            return this.nestedElements.size();
        }
        return 0;
    }

    public Enumeration children() {
        if (this.nestedBlock instanceof MixedContent) {
            return this.nestedBlock.children();
        }
        if (this.nestedBlock != null) {
            return Collections.enumeration(Collections12.singletonList(this.nestedBlock));
        }
        if (this.nestedElements != null) {
            return Collections.enumeration(this.nestedElements);
        }
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public TreeNode getChildAt(int index) {
        if (this.nestedBlock instanceof MixedContent) {
            return this.nestedBlock.getChildAt(index);
        }
        if (this.nestedBlock != null) {
            if (index == 0) {
                return this.nestedBlock;
            }
            throw new ArrayIndexOutOfBoundsException("invalid index");
        }
        if (this.nestedElements != null) {
            return (TreeNode)this.nestedElements.get(index);
        }
        throw new ArrayIndexOutOfBoundsException("element has no children");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setChildAt(int index, TemplateElement element) {
        if (this.nestedBlock instanceof MixedContent) {
            this.nestedBlock.setChildAt(index, element);
            return;
        } else if (this.nestedBlock != null) {
            if (index != 0) throw new IndexOutOfBoundsException("invalid index");
            this.nestedBlock = element;
            element.parent = this;
            return;
        } else {
            if (this.nestedElements == null) throw new IndexOutOfBoundsException("element has no children");
            this.nestedElements.set(index, element);
            element.parent = this;
        }
    }

    public TreeNode getParent() {
        return this.parent;
    }

    void setParentRecursively(TemplateElement parent) {
        this.parent = parent;
        int nestedSize = this.nestedElements == null ? 0 : this.nestedElements.size();
        for (int i = 0; i < nestedSize; ++i) {
            ((TemplateElement)this.nestedElements.get(i)).setParentRecursively(this);
        }
        if (this.nestedBlock != null) {
            this.nestedBlock.setParentRecursively(this);
        }
    }

    TemplateElement postParseCleanup(boolean stripWhitespace) throws ParseException {
        if (this.nestedElements != null) {
            TemplateElement te;
            for (int i = 0; i < this.nestedElements.size(); ++i) {
                te = (TemplateElement)this.nestedElements.get(i);
                te = te.postParseCleanup(stripWhitespace);
                this.nestedElements.set(i, te);
                te.parent = this;
            }
            if (stripWhitespace) {
                Iterator it = this.nestedElements.iterator();
                while (it.hasNext()) {
                    te = (TemplateElement)it.next();
                    if (!te.isIgnorable()) continue;
                    it.remove();
                }
            }
            if (this.nestedElements instanceof ArrayList) {
                ((ArrayList)this.nestedElements).trimToSize();
            }
        }
        if (this.nestedBlock != null) {
            this.nestedBlock = this.nestedBlock.postParseCleanup(stripWhitespace);
            if (this.nestedBlock.isIgnorable()) {
                this.nestedBlock = null;
            } else {
                this.nestedBlock.parent = this;
            }
        }
        return this;
    }

    boolean isIgnorable() {
        return false;
    }

    TemplateElement prevTerminalNode() {
        TemplateElement prev = this.previousSibling();
        if (prev != null) {
            return prev.getLastLeaf();
        }
        if (this.parent != null) {
            return this.parent.prevTerminalNode();
        }
        return null;
    }

    TemplateElement nextTerminalNode() {
        TemplateElement next = this.nextSibling();
        if (next != null) {
            return next.getFirstLeaf();
        }
        if (this.parent != null) {
            return this.parent.nextTerminalNode();
        }
        return null;
    }

    TemplateElement previousSibling() {
        if (this.parent == null) {
            return null;
        }
        List siblings = this.parent.nestedElements;
        if (siblings == null) {
            return null;
        }
        for (int i = siblings.size() - 1; i >= 0; --i) {
            if (siblings.get(i) != this) continue;
            return i > 0 ? (TemplateElement)siblings.get(i - 1) : null;
        }
        return null;
    }

    TemplateElement nextSibling() {
        if (this.parent == null) {
            return null;
        }
        List siblings = this.parent.nestedElements;
        if (siblings == null) {
            return null;
        }
        for (int i = 0; i < siblings.size(); ++i) {
            if (siblings.get(i) != this) continue;
            return i + 1 < siblings.size() ? (TemplateElement)siblings.get(i + 1) : null;
        }
        return null;
    }

    private TemplateElement getFirstChild() {
        if (this.nestedBlock != null) {
            return this.nestedBlock;
        }
        if (this.nestedElements != null && this.nestedElements.size() > 0) {
            return (TemplateElement)this.nestedElements.get(0);
        }
        return null;
    }

    private TemplateElement getLastChild() {
        if (this.nestedBlock != null) {
            return this.nestedBlock;
        }
        if (this.nestedElements != null && this.nestedElements.size() > 0) {
            return (TemplateElement)this.nestedElements.get(this.nestedElements.size() - 1);
        }
        return null;
    }

    private TemplateElement getFirstLeaf() {
        TemplateElement te = this;
        while (!(te.isLeaf() || te instanceof Macro || te instanceof BlockAssignment)) {
            te = te.getFirstChild();
        }
        return te;
    }

    private TemplateElement getLastLeaf() {
        TemplateElement te = this;
        while (!(te.isLeaf() || te instanceof Macro || te instanceof BlockAssignment)) {
            te = te.getLastChild();
        }
        return te;
    }

    boolean heedsOpeningWhitespace() {
        return false;
    }

    boolean heedsTrailingWhitespace() {
        return false;
    }
}

