/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.relocated.freemarker.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.uberfire.ext.preferences.relocated.freemarker.core.Environment;
import org.uberfire.ext.preferences.relocated.freemarker.core.Expression;
import org.uberfire.ext.preferences.relocated.freemarker.core.TemplateElement;
import org.uberfire.ext.preferences.relocated.freemarker.template.EmptyMap;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateException;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateModel;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateTransformModel;

final class TransformBlock
extends TemplateElement {
    private Expression transformExpression;
    Map namedArgs;

    TransformBlock(Expression transformExpression, Map namedArgs, TemplateElement nestedBlock) {
        this.transformExpression = transformExpression;
        this.namedArgs = namedArgs;
        this.nestedBlock = nestedBlock;
    }

    void accept(Environment env) throws TemplateException, IOException {
        Map args;
        TemplateTransformModel ttm = env.getTransform(this.transformExpression);
        if (ttm != null) {
            if (this.namedArgs != null && !this.namedArgs.isEmpty()) {
                args = new HashMap();
                Iterator it = this.namedArgs.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    String key = (String)entry.getKey();
                    Expression valueExp = (Expression)entry.getValue();
                    TemplateModel value = valueExp.getAsTemplateModel(env);
                    args.put(key, value);
                }
            } else {
                args = EmptyMap.instance;
            }
        } else {
            TemplateModel tm = this.transformExpression.getAsTemplateModel(env);
            throw TransformBlock.invalidTypeException(tm, this.transformExpression, env, "transform");
        }
        env.visit(this.nestedBlock, ttm, args);
    }

    public String getCanonicalForm() {
        StringBuffer buf = new StringBuffer("<#transform ");
        buf.append(this.transformExpression);
        if (this.namedArgs != null) {
            Iterator it = this.namedArgs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                buf.append(' ');
                buf.append(entry.getKey());
                buf.append('=');
                Expression val = (Expression)entry.getValue();
                buf.append(val.getCanonicalForm());
            }
        }
        buf.append(">");
        if (this.nestedBlock != null) {
            buf.append(this.nestedBlock.getCanonicalForm());
        }
        buf.append("</#transform>");
        return buf.toString();
    }

    public String getDescription() {
        return "transform " + this.transformExpression;
    }
}

