/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.relocated.freemarker.core;

import org.uberfire.ext.preferences.relocated.freemarker.core.ArithmeticEngine;
import org.uberfire.ext.preferences.relocated.freemarker.core.Environment;
import org.uberfire.ext.preferences.relocated.freemarker.core.Expression;
import org.uberfire.ext.preferences.relocated.freemarker.core.NonNumericalException;
import org.uberfire.ext.preferences.relocated.freemarker.template.SimpleNumber;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateException;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateModel;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateNumberModel;

final class UnaryPlusMinusExpression
extends Expression {
    private final Expression target;
    private final boolean isMinus;
    private static final Integer MINUS_ONE = new Integer(-1);

    UnaryPlusMinusExpression(Expression target, boolean isMinus) {
        this.target = target;
        this.isMinus = isMinus;
    }

    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        TemplateNumberModel targetModel = null;
        try {
            targetModel = (TemplateNumberModel)this.target.getAsTemplateModel(env);
        }
        catch (ClassCastException cce) {
            String msg = "Error " + this.getStartLocation();
            msg = msg + "\nExpression " + this.target + " is not numerical.";
            throw new NonNumericalException(msg, env);
        }
        if (!this.isMinus) {
            return targetModel;
        }
        Number n = targetModel.getAsNumber();
        n = ArithmeticEngine.CONSERVATIVE_ENGINE.multiply(MINUS_ONE, n);
        return new SimpleNumber(n);
    }

    public String getCanonicalForm() {
        String op = this.isMinus ? "-" : "+";
        return op + this.target.getCanonicalForm();
    }

    boolean isLiteral() {
        return this.target.isLiteral();
    }

    Expression _deepClone(String name, Expression subst) {
        return new UnaryPlusMinusExpression(this.target.deepClone(name, subst), this.isMinus);
    }
}

