/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.relocated.freemarker.ext.beans;

import java.lang.reflect.Member;
import java.util.List;
import org.uberfire.ext.preferences.relocated.freemarker.ext.beans.BeansWrapper;
import org.uberfire.ext.preferences.relocated.freemarker.ext.beans.MemberAndArguments;
import org.uberfire.ext.preferences.relocated.freemarker.ext.beans.MethodUtilities;
import org.uberfire.ext.preferences.relocated.freemarker.ext.beans.OverloadedFixArgMethod;
import org.uberfire.ext.preferences.relocated.freemarker.ext.beans.OverloadedMethod;
import org.uberfire.ext.preferences.relocated.freemarker.ext.beans.OverloadedVarArgMethod;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateModelException;

class MethodMap {
    private final String name;
    private final BeansWrapper wrapper;
    private final OverloadedMethod fixArgMethod = new OverloadedFixArgMethod();
    private OverloadedMethod varArgMethod;

    MethodMap(String name, BeansWrapper wrapper) {
        this.name = name;
        this.wrapper = wrapper;
    }

    BeansWrapper getWrapper() {
        return this.wrapper;
    }

    void addMember(Member member) {
        this.fixArgMethod.addMember(member);
        if (MethodUtilities.isVarArgs(member)) {
            if (this.varArgMethod == null) {
                this.varArgMethod = new OverloadedVarArgMethod();
            }
            this.varArgMethod.addMember(member);
        }
    }

    MemberAndArguments getMemberAndArguments(List arguments) throws TemplateModelException {
        Object memberAndArguments = this.fixArgMethod.getMemberAndArguments(arguments, this.wrapper);
        if (memberAndArguments == OverloadedMethod.NO_SUCH_METHOD) {
            if (this.varArgMethod != null) {
                memberAndArguments = this.varArgMethod.getMemberAndArguments(arguments, this.wrapper);
            }
            if (memberAndArguments == OverloadedMethod.NO_SUCH_METHOD) {
                throw new TemplateModelException("No signature of method " + this.name + " matches the arguments");
            }
        }
        if (memberAndArguments == OverloadedMethod.AMBIGUOUS_METHOD) {
            throw new TemplateModelException("Multiple signatures of method " + this.name + " match the arguments");
        }
        return (MemberAndArguments)memberAndArguments;
    }
}

