/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.relocated.freemarker.cache;

import java.net.URL;
import org.uberfire.ext.preferences.relocated.freemarker.cache.URLTemplateLoader;

public class ClassTemplateLoader
extends URLTemplateLoader {
    private Class loaderClass;
    private String path;

    public ClassTemplateLoader() {
        this.setFields(this.getClass(), "/");
    }

    public ClassTemplateLoader(Class loaderClass) {
        this.setFields(loaderClass, "");
    }

    public ClassTemplateLoader(Class loaderClass, String path) {
        this.setFields(loaderClass, path);
    }

    protected URL getURL(String name) {
        String fullPath = this.path + name;
        if (this.path.equals("/") && !ClassTemplateLoader.isSchemeless(fullPath)) {
            return null;
        }
        return this.loaderClass.getResource(fullPath);
    }

    private static boolean isSchemeless(String fullPath) {
        int i = 0;
        int ln = fullPath.length();
        if (i < ln && fullPath.charAt(i) == '/') {
            ++i;
        }
        while (i < ln) {
            char c = fullPath.charAt(i);
            if (c == '/') {
                return true;
            }
            if (c == ':') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void setFields(Class loaderClass, String path) {
        if (loaderClass == null) {
            throw new IllegalArgumentException("loaderClass == null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        this.loaderClass = loaderClass;
        this.path = ClassTemplateLoader.canonicalizePrefix(path);
    }
}

