/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.relocated.freemarker.core;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.uberfire.ext.preferences.relocated.freemarker.core.Environment;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateException;
import org.uberfire.ext.preferences.relocated.freemarker.template.utility.OptimizerUtil;

public abstract class ArithmeticEngine {
    public static final BigDecimalEngine BIGDECIMAL_ENGINE = new BigDecimalEngine();
    public static final ConservativeEngine CONSERVATIVE_ENGINE = new ConservativeEngine();
    protected int minScale = 12;
    protected int maxScale = 12;
    protected int roundingPolicy = 4;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public abstract int compareNumbers(Number var1, Number var2) throws TemplateException;

    public abstract Number add(Number var1, Number var2) throws TemplateException;

    public abstract Number subtract(Number var1, Number var2) throws TemplateException;

    public abstract Number multiply(Number var1, Number var2) throws TemplateException;

    public abstract Number divide(Number var1, Number var2) throws TemplateException;

    public abstract Number modulus(Number var1, Number var2) throws TemplateException;

    public abstract Number toNumber(String var1);

    public void setMinScale(int minScale) {
        if (minScale < 0) {
            throw new IllegalArgumentException("minScale < 0");
        }
        this.minScale = minScale;
    }

    public void setMaxScale(int maxScale) {
        if (maxScale < this.minScale) {
            throw new IllegalArgumentException("maxScale < minScale");
        }
        this.maxScale = maxScale;
    }

    public void setRoundingPolicy(int roundingPolicy) {
        if (roundingPolicy != 2 && roundingPolicy != 1 && roundingPolicy != 3 && roundingPolicy != 5 && roundingPolicy != 6 && roundingPolicy != 4 && roundingPolicy != 7 && roundingPolicy != 0) {
            throw new IllegalArgumentException("invalid rounding policy");
        }
        this.roundingPolicy = roundingPolicy;
    }

    private static BigDecimal toBigDecimal(Number num) {
        return num instanceof BigDecimal ? (BigDecimal)num : new BigDecimal(num.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ConservativeEngine
    extends ArithmeticEngine {
        private static final int INTEGER = 0;
        private static final int LONG = 1;
        private static final int FLOAT = 2;
        private static final int DOUBLE = 3;
        private static final int BIGINTEGER = 4;
        private static final int BIGDECIMAL = 5;
        private static final Map classCodes = ConservativeEngine.createClassCodesMap();

        public int compareNumbers(Number first, Number second) throws TemplateException {
            switch (ConservativeEngine.getCommonClassCode(first, second)) {
                case 0: {
                    int n1 = first.intValue();
                    int n2 = second.intValue();
                    return n1 < n2 ? -1 : (n1 == n2 ? 0 : 1);
                }
                case 1: {
                    long n1 = first.longValue();
                    long n2 = second.longValue();
                    return n1 < n2 ? -1 : (n1 == n2 ? 0 : 1);
                }
                case 2: {
                    float n1 = first.floatValue();
                    float n2 = second.floatValue();
                    return n1 < n2 ? -1 : (n1 == n2 ? 0 : 1);
                }
                case 3: {
                    double n1 = first.doubleValue();
                    double n2 = second.doubleValue();
                    return n1 < n2 ? -1 : (n1 == n2 ? 0 : 1);
                }
                case 4: {
                    BigInteger n1 = ConservativeEngine.toBigInteger(first);
                    BigInteger n2 = ConservativeEngine.toBigInteger(second);
                    return n1.compareTo(n2);
                }
                case 5: {
                    BigDecimal n1 = ArithmeticEngine.toBigDecimal(first);
                    BigDecimal n2 = ArithmeticEngine.toBigDecimal(second);
                    return n1.compareTo(n2);
                }
            }
            throw new Error();
        }

        public Number add(Number first, Number second) throws TemplateException {
            switch (ConservativeEngine.getCommonClassCode(first, second)) {
                case 0: {
                    int n1 = first.intValue();
                    int n2 = second.intValue();
                    int n = n1 + n2;
                    return (n ^ n1) < 0 && (n ^ n2) < 0 ? (Number)new Long((long)n1 + (long)n2) : (Number)new Integer(n);
                }
                case 1: {
                    long n1 = first.longValue();
                    long n2 = second.longValue();
                    long n = n1 + n2;
                    return (n ^ n1) < 0L && (n ^ n2) < 0L ? ConservativeEngine.toBigInteger(first).add(ConservativeEngine.toBigInteger(second)) : new Long(n);
                }
                case 2: {
                    return new Float(first.floatValue() + second.floatValue());
                }
                case 3: {
                    return new Double(first.doubleValue() + second.doubleValue());
                }
                case 4: {
                    BigInteger n1 = ConservativeEngine.toBigInteger(first);
                    BigInteger n2 = ConservativeEngine.toBigInteger(second);
                    return n1.add(n2);
                }
                case 5: {
                    BigDecimal n1 = ArithmeticEngine.toBigDecimal(first);
                    BigDecimal n2 = ArithmeticEngine.toBigDecimal(second);
                    return n1.add(n2);
                }
            }
            throw new Error();
        }

        public Number subtract(Number first, Number second) throws TemplateException {
            switch (ConservativeEngine.getCommonClassCode(first, second)) {
                case 0: {
                    int n1 = first.intValue();
                    int n2 = second.intValue();
                    int n = n1 - n2;
                    return (n ^ n1) < 0 && (n ^ ~n2) < 0 ? (Number)new Long((long)n1 - (long)n2) : (Number)new Integer(n);
                }
                case 1: {
                    long n1 = first.longValue();
                    long n2 = second.longValue();
                    long n = n1 - n2;
                    return (n ^ n1) < 0L && (n ^ (n2 ^ 0xFFFFFFFFFFFFFFFFL)) < 0L ? ConservativeEngine.toBigInteger(first).subtract(ConservativeEngine.toBigInteger(second)) : new Long(n);
                }
                case 2: {
                    return new Float(first.floatValue() - second.floatValue());
                }
                case 3: {
                    return new Double(first.doubleValue() - second.doubleValue());
                }
                case 4: {
                    BigInteger n1 = ConservativeEngine.toBigInteger(first);
                    BigInteger n2 = ConservativeEngine.toBigInteger(second);
                    return n1.subtract(n2);
                }
                case 5: {
                    BigDecimal n1 = ArithmeticEngine.toBigDecimal(first);
                    BigDecimal n2 = ArithmeticEngine.toBigDecimal(second);
                    return n1.subtract(n2);
                }
            }
            throw new Error();
        }

        public Number multiply(Number first, Number second) throws TemplateException {
            switch (ConservativeEngine.getCommonClassCode(first, second)) {
                case 0: {
                    int n1 = first.intValue();
                    int n2 = second.intValue();
                    int n = n1 * n2;
                    return n1 == 0 || n / n1 == n2 ? (Number)new Integer(n) : (Number)new Long((long)n1 * (long)n2);
                }
                case 1: {
                    long n1 = first.longValue();
                    long n2 = second.longValue();
                    long n = n1 * n2;
                    return n1 == 0L || n / n1 == n2 ? new Long(n) : ConservativeEngine.toBigInteger(first).multiply(ConservativeEngine.toBigInteger(second));
                }
                case 2: {
                    return new Float(first.floatValue() * second.floatValue());
                }
                case 3: {
                    return new Double(first.doubleValue() * second.doubleValue());
                }
                case 4: {
                    BigInteger n1 = ConservativeEngine.toBigInteger(first);
                    BigInteger n2 = ConservativeEngine.toBigInteger(second);
                    return n1.multiply(n2);
                }
                case 5: {
                    BigDecimal n1 = ArithmeticEngine.toBigDecimal(first);
                    BigDecimal n2 = ArithmeticEngine.toBigDecimal(second);
                    BigDecimal r = n1.multiply(n2);
                    return r.scale() > this.maxScale ? r.setScale(this.maxScale, this.roundingPolicy) : r;
                }
            }
            throw new Error();
        }

        public Number divide(Number first, Number second) throws TemplateException {
            switch (ConservativeEngine.getCommonClassCode(first, second)) {
                case 0: {
                    int n1 = first.intValue();
                    int n2 = second.intValue();
                    if (n1 % n2 == 0) {
                        return new Integer(n1 / n2);
                    }
                    return new Double((double)n1 / (double)n2);
                }
                case 1: {
                    long n1 = first.longValue();
                    long n2 = second.longValue();
                    if (n1 % n2 == 0L) {
                        return new Long(n1 / n2);
                    }
                    return new Double((double)n1 / (double)n2);
                }
                case 2: {
                    return new Float(first.floatValue() / second.floatValue());
                }
                case 3: {
                    return new Double(first.doubleValue() / second.doubleValue());
                }
                case 4: {
                    BigInteger n1 = ConservativeEngine.toBigInteger(first);
                    BigInteger n2 = ConservativeEngine.toBigInteger(second);
                    BigInteger[] divmod = n1.divideAndRemainder(n2);
                    if (divmod[1].equals(BigInteger.ZERO)) {
                        return divmod[0];
                    }
                    BigDecimal bd1 = new BigDecimal(n1);
                    BigDecimal bd2 = new BigDecimal(n2);
                    return bd1.divide(bd2, this.minScale, this.roundingPolicy);
                }
                case 5: {
                    BigDecimal n1 = ArithmeticEngine.toBigDecimal(first);
                    BigDecimal n2 = ArithmeticEngine.toBigDecimal(second);
                    int scale1 = n1.scale();
                    int scale2 = n2.scale();
                    int scale = Math.max(scale1, scale2);
                    scale = Math.max(this.minScale, scale);
                    return n1.divide(n2, scale, this.roundingPolicy);
                }
            }
            throw new Error();
        }

        public Number modulus(Number first, Number second) throws TemplateException {
            switch (ConservativeEngine.getCommonClassCode(first, second)) {
                case 0: {
                    return new Integer(first.intValue() % second.intValue());
                }
                case 1: {
                    return new Long(first.longValue() % second.longValue());
                }
                case 2: {
                    return new Float(first.floatValue() % second.floatValue());
                }
                case 3: {
                    return new Double(first.doubleValue() % second.doubleValue());
                }
                case 4: {
                    BigInteger n1 = ConservativeEngine.toBigInteger(first);
                    BigInteger n2 = ConservativeEngine.toBigInteger(second);
                    return n1.mod(n2);
                }
                case 5: {
                    throw new TemplateException("Can't calculate remainder on BigDecimals", Environment.getCurrentEnvironment());
                }
            }
            throw new Error();
        }

        public Number toNumber(String s) {
            return OptimizerUtil.optimizeNumberRepresentation(new BigDecimal(s));
        }

        private static Map createClassCodesMap() {
            HashMap<Class, Integer> map = new HashMap<Class, Integer>(17);
            Integer intcode = new Integer(0);
            map.put(class$java$lang$Byte == null ? (class$java$lang$Byte = ArithmeticEngine.class$("java.lang.Byte")) : class$java$lang$Byte, intcode);
            map.put(class$java$lang$Short == null ? (class$java$lang$Short = ArithmeticEngine.class$("java.lang.Short")) : class$java$lang$Short, intcode);
            map.put(class$java$lang$Integer == null ? (class$java$lang$Integer = ArithmeticEngine.class$("java.lang.Integer")) : class$java$lang$Integer, intcode);
            map.put(class$java$lang$Long == null ? (class$java$lang$Long = ArithmeticEngine.class$("java.lang.Long")) : class$java$lang$Long, new Integer(1));
            map.put(class$java$lang$Float == null ? (class$java$lang$Float = ArithmeticEngine.class$("java.lang.Float")) : class$java$lang$Float, new Integer(2));
            map.put(class$java$lang$Double == null ? (class$java$lang$Double = ArithmeticEngine.class$("java.lang.Double")) : class$java$lang$Double, new Integer(3));
            map.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = ArithmeticEngine.class$("java.math.BigInteger")) : class$java$math$BigInteger, new Integer(4));
            map.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ArithmeticEngine.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new Integer(5));
            return map;
        }

        private static int getClassCode(Number num) throws TemplateException {
            try {
                return (Integer)classCodes.get(num.getClass());
            }
            catch (NullPointerException e) {
                if (num == null) {
                    throw new TemplateException("Unknown number type null", Environment.getCurrentEnvironment());
                }
                throw new TemplateException("Unknown number type " + num.getClass().getName(), Environment.getCurrentEnvironment());
            }
        }

        private static int getCommonClassCode(Number num1, Number num2) throws TemplateException {
            int c2;
            int c1 = ConservativeEngine.getClassCode(num1);
            int c = c1 > (c2 = ConservativeEngine.getClassCode(num2)) ? c1 : c2;
            switch (c) {
                case 2: {
                    if ((c1 < c2 ? c1 : c2) != 1) break;
                    return 3;
                }
                case 4: {
                    int min;
                    int n = min = c1 < c2 ? c1 : c2;
                    if (min != 3 && min != 2) break;
                    return 5;
                }
            }
            return c;
        }

        private static BigInteger toBigInteger(Number num) {
            return num instanceof BigInteger ? (BigInteger)num : new BigInteger(num.toString());
        }
    }

    public static class BigDecimalEngine
    extends ArithmeticEngine {
        public int compareNumbers(Number first, Number second) {
            BigDecimal left = ArithmeticEngine.toBigDecimal(first);
            BigDecimal right = ArithmeticEngine.toBigDecimal(second);
            return left.compareTo(right);
        }

        public Number add(Number first, Number second) {
            BigDecimal left = ArithmeticEngine.toBigDecimal(first);
            BigDecimal right = ArithmeticEngine.toBigDecimal(second);
            return left.add(right);
        }

        public Number subtract(Number first, Number second) {
            BigDecimal left = ArithmeticEngine.toBigDecimal(first);
            BigDecimal right = ArithmeticEngine.toBigDecimal(second);
            return left.subtract(right);
        }

        public Number multiply(Number first, Number second) {
            BigDecimal right;
            BigDecimal left = ArithmeticEngine.toBigDecimal(first);
            BigDecimal result = left.multiply(right = ArithmeticEngine.toBigDecimal(second));
            if (result.scale() > this.maxScale) {
                result = result.setScale(this.maxScale, this.roundingPolicy);
            }
            return result;
        }

        public Number divide(Number first, Number second) {
            BigDecimal left = ArithmeticEngine.toBigDecimal(first);
            BigDecimal right = ArithmeticEngine.toBigDecimal(second);
            return this.divide(left, right);
        }

        public Number modulus(Number first, Number second) {
            long left = first.longValue();
            long right = second.longValue();
            return new Long(left % right);
        }

        public Number toNumber(String s) {
            return new BigDecimal(s);
        }

        private BigDecimal divide(BigDecimal left, BigDecimal right) {
            int scale1 = left.scale();
            int scale2 = right.scale();
            int scale = Math.max(scale1, scale2);
            scale = Math.max(this.minScale, scale);
            return left.divide(right, scale, this.roundingPolicy);
        }
    }
}

