/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.relocated.freemarker.core;

import java.io.IOException;
import org.uberfire.ext.preferences.relocated.freemarker.core.Environment;
import org.uberfire.ext.preferences.relocated.freemarker.core.Expression;
import org.uberfire.ext.preferences.relocated.freemarker.core.TemplateElement;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateException;

final class ConditionalBlock
extends TemplateElement {
    final Expression condition;
    private final boolean isFirst;
    boolean isSimple;

    ConditionalBlock(Expression condition, TemplateElement nestedBlock, boolean isFirst) {
        this.condition = condition;
        this.nestedBlock = nestedBlock;
        this.isFirst = isFirst;
    }

    void accept(Environment env) throws TemplateException, IOException {
        if ((this.condition == null || this.condition.isTrue(env)) && this.nestedBlock != null) {
            env.visit(this.nestedBlock);
        }
    }

    public String getCanonicalForm() {
        StringBuffer buf = new StringBuffer();
        if (this.condition == null) {
            buf.append("<#else");
        } else if (this.isFirst) {
            buf.append("<#if ");
        } else {
            buf.append("<#elseif ");
        }
        if (this.condition != null) {
            buf.append(this.condition.getCanonicalForm());
        }
        buf.append(">");
        if (this.nestedBlock != null) {
            buf.append(this.nestedBlock.getCanonicalForm());
        }
        if (this.isSimple) {
            buf.append("</#if>");
        }
        return buf.toString();
    }

    public String getDescription() {
        String s = "if ";
        if (this.condition == null) {
            s = "else ";
        } else if (!this.isFirst) {
            s = "elseif ";
        }
        String cond = this.condition != null ? this.condition.toString() : "";
        return s + cond;
    }
}

