/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.relocated.freemarker.core;

import java.io.IOException;
import org.uberfire.ext.preferences.relocated.freemarker.core.Environment;
import org.uberfire.ext.preferences.relocated.freemarker.core.Expression;
import org.uberfire.ext.preferences.relocated.freemarker.core.TemplateElement;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateException;

final class DollarVariable
extends TemplateElement {
    private final Expression expression;
    private final Expression escapedExpression;

    DollarVariable(Expression expression, Expression escapedExpression) {
        this.expression = expression;
        this.escapedExpression = escapedExpression;
    }

    void accept(Environment env) throws TemplateException, IOException {
        env.getOut().write(this.escapedExpression.getStringValue(env));
    }

    public String getCanonicalForm() {
        return "${" + this.expression.getCanonicalForm() + "}";
    }

    public String getDescription() {
        return this.getSource() + (this.expression == this.escapedExpression ? "" : " escaped ${" + this.escapedExpression.getCanonicalForm() + "}");
    }

    boolean heedsOpeningWhitespace() {
        return true;
    }

    boolean heedsTrailingWhitespace() {
        return true;
    }
}

