/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.relocated.freemarker.core;

import java.io.IOException;
import org.uberfire.ext.preferences.relocated.freemarker.core.Environment;
import org.uberfire.ext.preferences.relocated.freemarker.core.Expression;
import org.uberfire.ext.preferences.relocated.freemarker.core.InvalidReferenceException;
import org.uberfire.ext.preferences.relocated.freemarker.core.ParseException;
import org.uberfire.ext.preferences.relocated.freemarker.core.TemplateElement;
import org.uberfire.ext.preferences.relocated.freemarker.template.Template;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateException;

public final class LibraryLoad
extends TemplateElement {
    private Expression templateName;
    private String namespace;
    private final String templatePath;

    LibraryLoad(Template template, Expression templateName, String namespace) {
        this.namespace = namespace;
        String templatePath1 = template.getName();
        int lastSlash = templatePath1.lastIndexOf(47);
        this.templatePath = lastSlash == -1 ? "" : templatePath1.substring(0, lastSlash + 1);
        this.templateName = templateName;
    }

    void accept(Environment env) throws TemplateException, IOException {
        Template importedTemplate;
        String templateNameString = this.templateName.getStringValue(env);
        if (templateNameString == null) {
            String msg = "Error " + this.getStartLocation() + "The expression " + this.templateName + " is undefined.";
            throw new InvalidReferenceException(msg, env);
        }
        try {
            if (!env.isClassicCompatible() && templateNameString.indexOf("://") <= 0) {
                int protIndex;
                templateNameString = templateNameString.length() > 0 && templateNameString.charAt(0) == '/' ? ((protIndex = this.templatePath.indexOf("://")) > 0 ? this.templatePath.substring(0, protIndex + 2) + templateNameString : templateNameString.substring(1)) : this.templatePath + templateNameString;
            }
            importedTemplate = env.getTemplateForImporting(templateNameString);
        }
        catch (ParseException pe) {
            String msg = "Error parsing imported template " + templateNameString;
            throw new TemplateException(msg, pe, env);
        }
        catch (IOException ioe) {
            String msg = "Error reading imported file " + templateNameString;
            throw new TemplateException(msg, ioe, env);
        }
        env.importLib(importedTemplate, this.namespace);
    }

    public String getCanonicalForm() {
        StringBuffer buf = new StringBuffer("<#import ");
        buf.append(this.templateName);
        buf.append(" as ");
        buf.append(this.namespace);
        buf.append("/>");
        return buf.toString();
    }

    public String getDescription() {
        return "import " + this.templateName + " as " + this.namespace;
    }

    public String getTemplateName() {
        return this.templateName.toString();
    }
}

