/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.preferences.relocated.freemarker.core;

import java.io.IOException;
import java.util.ArrayList;
import org.uberfire.ext.preferences.relocated.freemarker.core.Environment;
import org.uberfire.ext.preferences.relocated.freemarker.core.ParseException;
import org.uberfire.ext.preferences.relocated.freemarker.core.TemplateElement;
import org.uberfire.ext.preferences.relocated.freemarker.template.TemplateException;

final class MixedContent
extends TemplateElement {
    MixedContent() {
        this.nestedElements = new ArrayList();
    }

    void addElement(TemplateElement element) {
        this.nestedElements.add(element);
    }

    TemplateElement postParseCleanup(boolean stripWhitespace) throws ParseException {
        super.postParseCleanup(stripWhitespace);
        if (this.nestedElements.size() == 1) {
            return (TemplateElement)this.nestedElements.get(0);
        }
        return this;
    }

    void accept(Environment env) throws TemplateException, IOException {
        for (int i = 0; i < this.nestedElements.size(); ++i) {
            TemplateElement element = (TemplateElement)this.nestedElements.get(i);
            env.visit(element);
        }
    }

    public String getCanonicalForm() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.nestedElements.size(); ++i) {
            TemplateElement element = (TemplateElement)this.nestedElements.get(i);
            buf.append(element.getCanonicalForm());
        }
        return buf.toString();
    }

    public String getDescription() {
        if (this.parent == null) {
            return "root element";
        }
        return "content";
    }

    boolean isIgnorable() {
        return this.nestedElements == null || this.nestedElements.size() == 0;
    }
}

